/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.activitystreams.impl;

import com.adobe.granite.activitystreams.Activity;
import com.adobe.granite.activitystreams.ActivityCollection;
import com.adobe.granite.activitystreams.ActivityException;
import com.adobe.granite.activitystreams.ActivityManager;
import com.adobe.granite.activitystreams.ActivityStream;
import com.adobe.granite.activitystreams.AggregateOptions;
import com.adobe.granite.activitystreams.MutableActivity;
import com.adobe.granite.activitystreams.MutableActivityObject;
import com.adobe.granite.activitystreams.MutableMediaLink;
import com.adobe.granite.activitystreams.impl.ActivityStreamImpl;
import com.adobe.granite.activitystreams.impl.JcrActivity;
import com.adobe.granite.activitystreams.impl.MutableActivityImpl;
import com.adobe.granite.activitystreams.impl.MutableActivityObjectImpl;
import com.adobe.granite.activitystreams.impl.MutableMediaLinkImpl;
import com.adobe.granite.activitystreams.impl.StreamsAggregate;
import com.adobe.granite.socialgraph.Direction;
import com.adobe.granite.socialgraph.GraphNode;
import com.adobe.granite.socialgraph.Relationship;
import com.adobe.granite.socialgraph.SocialGraph;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.Value;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.AccessControlPolicyIterator;
import javax.jcr.security.Privilege;
import org.apache.commons.lang.ArrayUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlPolicy;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(metatype=true, label="Adobe Granite Activity Manager", description="Service responsible to collect and distribute activities and managing the activity streams.")
@Service(value={ActivityManager.class})
public class ActivityManagerImpl
implements ActivityManager {
    private static final Logger log = LoggerFactory.getLogger(ActivityManagerImpl.class);
    private static final String ACTIVITIES_NODE_NAME = "activities";
    protected static final String ACTIVITY_DEFAULT_STREAM_NAME = "public";
    protected static final String ACTIVITY_TOPIC_STREAM_NAME = "default";
    public static final String NT_ACTIVITIES_NODE = "sling:OrderedFolder";
    public static final String RESOURCE_TYPE_ACTIVITIES = "granite/activitystreams/components/activities";
    public static final String NT_STREAM_NODE = "sling:OrderedFolder";
    public static final String RESOURCE_TYPE_ACTIVITY_STREAM = "granite/activitystreams/components/stream";
    public static final String NT_FOLDER_NODE = "sling:OrderedFolder";
    public static final String NT_ACTIVITY_NODE = "nt:unstructured";
    public static final String[] DEFAULT_AGGREGATE_RELATIONSHIPS = new String[]{"following", "member"};
    @Property(value={"following", "member"}, label="Aggregate Relationships", description="Defines the relationship types to use for default aggregation.")
    private static final String AGGREGATE_RELATIONSHIPS = "aggregate.relationships";
    @Property(boolValue={true}, label="Descend Virtual Nodes", description="Defines if aggregation should follow virtual graph nodes.")
    private static final String AGGREGATE_DESCEND_VIRTUAL = "aggregate.descend.virtual";
    @Reference
    private SlingRepository repository = null;
    @Reference
    private EventAdmin eventAdmin = null;
    private String[] aggregateTypes;
    private boolean aggregateDescendVirtual;

    @Activate
    private void activate(Map<String, Object> properties) {
        this.aggregateTypes = OsgiUtil.toStringArray((Object)properties.get(AGGREGATE_RELATIONSHIPS));
        if (this.aggregateTypes.length == 0) {
            this.aggregateTypes = DEFAULT_AGGREGATE_RELATIONSHIPS;
        }
        this.aggregateDescendVirtual = OsgiUtil.toBoolean((Object)properties.get(AGGREGATE_DESCEND_VIRTUAL), (boolean)true);
        this.setUpACLs();
    }

    @Deactivate
    private void deactivate() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setUpACLs() {
        log.info("adjust ACL rules for activities.");
        Session admin = null;
        try {
            admin = this.repository.loginAdministrative(null);
            if (!(admin instanceof JackrabbitSession)) {
                log.warn("Unable to apply ACLs. No Jackrabbit session: " + admin);
                return;
            }
            AccessControlManager acMgr = admin.getAccessControlManager();
            PrincipalManager pMgr = ((JackrabbitSession)admin).getPrincipalManager();
            JackrabbitAccessControlList acl = this.getAcl(acMgr, "/home");
            if (acl != null) {
                String[] rules = new String[]{"+*/activities", "-*/activities/*", "+*/activities/sling:resourceType", "+*/activities/public", "+*/activities/public/*"};
                boolean modified = false;
                Principal p = pMgr.getEveryone();
                if (p != null) {
                    Privilege[] priv = new Privilege[]{acMgr.privilegeFromName("jcr:read")};
                    for (String rule : rules) {
                        String glob = rule.substring(1);
                        boolean allow = rule.charAt(0) == '+';
                        HashMap<String, Value> restrictions = new HashMap<String, Value>();
                        Value v = admin.getValueFactory().createValue(glob);
                        restrictions.put("rep:glob", v);
                        modified |= acl.addEntry(p, priv, allow, restrictions);
                    }
                }
                if (modified) {
                    acMgr.setPolicy("/home", (AccessControlPolicy)acl);
                }
            }
            admin.save();
            log.info("done.");
        }
        catch (Exception e) {
            log.error("Error while applying ACLs", (Throwable)e);
        }
        finally {
            if (admin != null) {
                admin.logout();
            }
        }
    }

    private JackrabbitAccessControlList getAcl(AccessControlManager acm, String path) {
        try {
            AccessControlPolicyIterator app = acm.getApplicablePolicies(path);
            while (app.hasNext()) {
                AccessControlPolicy pol = app.nextAccessControlPolicy();
                if (!(pol instanceof JackrabbitAccessControlPolicy)) continue;
                log.debug("No Policy present create a new ACL Policy");
                return (JackrabbitAccessControlList)pol;
            }
            for (AccessControlPolicy pol : acm.getPolicies(path)) {
                if (!(pol instanceof JackrabbitAccessControlPolicy)) continue;
                log.debug("Found existing ACL Policy");
                return (JackrabbitAccessControlList)pol;
            }
        }
        catch (RepositoryException e) {
            log.warn("Error while retrieving ACL for {}: {}", (Object)path, (Object)e.toString());
        }
        return null;
    }

    @Override
    public MutableActivity newActivity() {
        return new MutableActivityImpl();
    }

    @Override
    public MutableActivity newActivity(JSONObject jsonObject) {
        return new MutableActivityImpl(jsonObject);
    }

    @Override
    public MutableActivityObject newActivityObject() {
        return new MutableActivityObjectImpl();
    }

    @Override
    public MutableMediaLink newMediaLink() {
        return new MutableMediaLinkImpl();
    }

    @Override
    @Deprecated
    public ActivityStream getUserStream(ResourceResolver resolver, String userId, String streamName) throws ActivityException {
        return this.getUserStream(resolver, userId, streamName, true);
    }

    @Override
    public ActivityStream getUserStream(ResourceResolver resolver, String userId, String streamName, boolean create) throws ActivityException {
        try {
            JackrabbitSession session = (JackrabbitSession)resolver.adaptTo(Session.class);
            Authorizable auth = session.getUserManager().getAuthorizable(userId);
            if (!(auth instanceof User)) {
                return null;
            }
            return this.getStream(resolver, auth, streamName, create);
        }
        catch (RepositoryException e) {
            log.error("Unable to read user with id {}: {}", (Object)userId, (Object)e.toString());
            return null;
        }
    }

    @Override
    public ActivityStream getGroupStream(ResourceResolver resolver, String groupName, String streamName, boolean create) throws ActivityException {
        try {
            JackrabbitSession session = (JackrabbitSession)resolver.adaptTo(Session.class);
            Authorizable auth = session.getUserManager().getAuthorizable(groupName);
            if (!(auth instanceof Group)) {
                return null;
            }
            return this.getStream(resolver, auth, streamName, create);
        }
        catch (RepositoryException e) {
            log.error("Unable to read group with name {}: {}", (Object)groupName, (Object)e.toString());
            return null;
        }
    }

    @Override
    @Deprecated
    public ActivityStream getUserStream(ResourceResolver resolver, User user, String streamName) throws ActivityException {
        return this.getStream(resolver, (Authorizable)user, streamName, true);
    }

    @Override
    public ActivityStream getStream(ResourceResolver resolver, Authorizable user, String streamName, boolean create) throws ActivityException {
        try {
            String myPath;
            if (streamName == null || streamName.length() == 0) {
                streamName = ACTIVITY_DEFAULT_STREAM_NAME;
            }
            if ((myPath = this.internalGetOrCreateUserStream(user, streamName, create)) == null) {
                return null;
            }
            Session session = (Session)resolver.adaptTo(Session.class);
            if (!session.nodeExists(myPath)) {
                log.warn("Unable to retrieve user's stream due to access control restrictions.");
                return null;
            }
            return new ActivityStreamImpl(this, resolver, myPath);
        }
        catch (RepositoryException e) {
            throw new ActivityException("Unable to get user stream", e);
        }
    }

    @Override
    @Deprecated
    public ActivityStream getTopicStream(Resource topicResource, String streamName) throws ActivityException {
        return this.getStream(topicResource, streamName, true);
    }

    @Override
    public ActivityStream getStream(Resource streamResource) throws ActivityException {
        return new ActivityStreamImpl(this, streamResource.getResourceResolver(), streamResource.getPath());
    }

    @Override
    public ActivityStream getStream(Resource containerResource, String streamName, boolean create) throws ActivityException {
        Authorizable auth = (Authorizable)containerResource.adaptTo(Authorizable.class);
        if (auth != null) {
            return this.getStream(containerResource.getResourceResolver(), auth, streamName, create);
        }
        try {
            String myPath;
            if (streamName == null || streamName.length() == 0) {
                streamName = ACTIVITY_TOPIC_STREAM_NAME;
            }
            if ((myPath = this.internalGetOrCreateTopicStream(containerResource, streamName, create)) == null) {
                return null;
            }
            ResourceResolver resolver = containerResource.getResourceResolver();
            Session session = (Session)resolver.adaptTo(Session.class);
            if (!session.nodeExists(myPath)) {
                log.warn("Unable to retrieve topic stream due to access control restrictions.");
                return null;
            }
            return new ActivityStreamImpl(this, resolver, myPath);
        }
        catch (RepositoryException e) {
            throw new ActivityException("Unable to get stream", e);
        }
    }

    @Override
    public ActivityCollection getActivities(ResourceResolver resolver, String userId) throws ActivityException {
        Collection<ActivityStream> streams = this.listStreams(resolver, userId, null);
        return new StreamsAggregate(this, resolver, streams);
    }

    @Override
    public ActivityCollection getActivities(ResourceResolver resolver, String userId, AggregateOptions options) throws ActivityException {
        Collection<ActivityStream> streams = this.listStreams(resolver, userId, options);
        return new StreamsAggregate(this, resolver, streams);
    }

    @Override
    public Activity getActivity(ResourceResolver resolver, String id) throws ActivityException {
        if (id == null) {
            return null;
        }
        Resource r = resolver.getResource(id);
        if (r == null) {
            return null;
        }
        return new JcrActivity(this, r);
    }

    @Override
    public Collection<ActivityStream> listStreams(Resource containerResource) throws ActivityException {
        ResourceResolver resolver = containerResource.getResourceResolver();
        StringBuilder activitiesPath = new StringBuilder(containerResource.getPath());
        Authorizable auth = (Authorizable)containerResource.adaptTo(Authorizable.class);
        if (auth == null) {
            activitiesPath.append("/jcr:content");
        }
        activitiesPath.append("/").append(ACTIVITIES_NODE_NAME);
        LinkedList<ActivityStream> ret = new LinkedList<ActivityStream>();
        this.internalAddStreams(resolver, activitiesPath.toString(), ret, AggregateOptions.DEFAULT);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ActivityStream> listStreams(ResourceResolver resolver, String userId, AggregateOptions options) throws ActivityException {
        JackrabbitSession adminSession = null;
        try {
            if (options == null) {
                options = AggregateOptions.DEFAULT;
            }
            ArrayList<ActivityStream> streams = new ArrayList<ActivityStream>();
            HashSet<String> traversed = new HashSet<String>();
            if (userId == null) {
                userId = resolver.getUserID();
            }
            adminSession = (JackrabbitSession)this.repository.loginAdministrative(null);
            UserManager uMgr = adminSession.getUserManager();
            this.internalTraverseStreams(resolver, uMgr, null, userId, streams, traversed, options);
            ArrayList<ActivityStream> arrayList = streams;
            return arrayList;
        }
        catch (RepositoryException e) {
            log.error("Unable to read activities for user {}: {}", (Object)userId, (Object)e.toString());
            List<ActivityStream> list = Collections.emptyList();
            return list;
        }
        finally {
            if (adminSession != null) {
                adminSession.logout();
            }
        }
    }

    @Override
    public Iterable<String> getFollowers(Activity activity) throws ActivityException, IllegalArgumentException {
        return this.getFollowers(activity.getStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<String> getFollowers(ActivityStream stream) throws ActivityException, IllegalArgumentException {
        if (stream == null) {
            String msg = "stream must be non-null";
            log.error(msg);
            throw new IllegalArgumentException(msg);
        }
        String streamPath = stream.getResource().getPath();
        try {
            String id;
            Resource container = stream.getContainerResource();
            if (container == null) {
                log.warn("Unable to resolve followers of {}. Unable to obtain container resource of {}.", (Object)streamPath, (Object)stream.getId());
                return Collections.emptyList();
            }
            HashSet<String> users = new HashSet<String>();
            Authorizable auth = (Authorizable)container.adaptTo(Authorizable.class);
            if (auth instanceof User) {
                id = auth.getID();
                users.add(id);
            } else {
                id = auth instanceof Group ? auth.getID() : container.getPath();
            }
            SocialGraph graph = (SocialGraph)container.getResourceResolver().adaptTo(SocialGraph.class);
            GraphNode node = graph.getNode(id);
            if (node != null) {
                for (Relationship r : node.getRelationships(Direction.INCOMING, this.aggregateTypes)) {
                    GraphNode other = r.getStartNode();
                    if (other.isVirtual()) {
                        if (!this.aggregateDescendVirtual) continue;
                        for (Relationship r1 : other.getRelationships(Direction.INCOMING, this.aggregateTypes)) {
                            GraphNode other1 = r1.getStartNode();
                            if (other1.isVirtual()) continue;
                            users.add(other1.getId());
                        }
                        continue;
                    }
                    users.add(other.getId());
                }
            }
            Session adminSession = null;
            try {
                adminSession = this.repository.loginAdministrative(null);
                Iterator iter = users.iterator();
                while (iter.hasNext()) {
                    String userId = (String)iter.next();
                    log.debug("Checking read permissions for follower: {}", (Object)userId);
                    Session s = null;
                    try {
                        s = adminSession.impersonate((Credentials)new SimpleCredentials(userId, ArrayUtils.EMPTY_CHAR_ARRAY));
                        if (s.hasPermission(streamPath, "read")) continue;
                        iter.remove();
                    }
                    catch (LoginException e) {
                        log.debug("unable to impersonate to {}: {}", (Object)userId, (Object)e.toString());
                        iter.remove();
                    }
                    finally {
                        if (s == null) continue;
                        s.logout();
                    }
                }
            }
            finally {
                if (adminSession != null) {
                    adminSession.logout();
                }
            }
            return users;
        }
        catch (RepositoryException e) {
            throw new ActivityException("Error while resolving followers of " + streamPath, e);
        }
    }

    private void internalTraverseStreams(ResourceResolver resolver, UserManager uMgr, GraphNode graphNode, String id, List<ActivityStream> streams, Set<String> traversed, AggregateOptions options) {
        traversed.add(id);
        if (id.startsWith("/")) {
            String activitiesPath = id + "/jcr:content/" + ACTIVITIES_NODE_NAME;
            this.internalAddStreams(resolver, activitiesPath, streams, options);
        } else {
            String activitiesPath = this.internalGetAuthorizableActivitiesPath(uMgr, id);
            if (activitiesPath != null) {
                this.internalAddStreams(resolver, activitiesPath, streams, options);
            }
            if (graphNode == null) {
                SocialGraph graph = (SocialGraph)resolver.adaptTo(SocialGraph.class);
                graphNode = graph.getNode(id);
            } else if (!this.aggregateDescendVirtual || !graphNode.isVirtual()) {
                graphNode = null;
            }
            if (graphNode != null) {
                String[] types = options.relationshipTypes();
                if (types == null) {
                    types = this.aggregateTypes;
                }
                if (types.length > 0) {
                    Iterable relationships = graphNode.getRelationships(Direction.OUTGOING, types);
                    for (Relationship r : relationships) {
                        GraphNode other = r.getEndNode();
                        if (other == null || traversed.contains(other.getId())) continue;
                        this.internalTraverseStreams(resolver, uMgr, other, other.getId(), streams, traversed, options);
                    }
                }
            }
        }
    }

    private void internalAddStreams(ResourceResolver resolver, String activitiesPath, List<ActivityStream> streams, AggregateOptions options) {
        Resource resource = resolver.getResource(activitiesPath);
        if (resource != null) {
            Iterator iter = resource.listChildren();
            while (iter.hasNext()) {
                Resource streamResource = (Resource)iter.next();
                if (!streamResource.isResourceType(RESOURCE_TYPE_ACTIVITY_STREAM)) continue;
                ActivityStreamImpl stream = new ActivityStreamImpl(this, resolver, streamResource.getPath());
                if (!options.getActivityStreamFilter().includes(stream)) continue;
                streams.add(stream);
            }
        }
    }

    private String internalGetOrCreateUserStream(Authorizable auth, String streamName, boolean create) throws ActivityException {
        Session admin = null;
        try {
            Node streamNode;
            admin = this.repository.loginAdministrative(null);
            if (!admin.nodeExists(auth.getPath())) {
                throw new ActivityException("Authorizable " + auth.getID() + " home path does not exist.");
            }
            Node userHome = admin.getNode(auth.getPath());
            Node activitiesNode = this.getOrAddNode(userHome, ACTIVITIES_NODE_NAME, "sling:OrderedFolder", create);
            if (activitiesNode == null) {
                String string = null;
                return string;
            }
            if (!activitiesNode.hasProperty("sling:resourceType")) {
                activitiesNode.setProperty("sling:resourceType", RESOURCE_TYPE_ACTIVITIES);
            }
            if ((streamNode = this.getOrAddNode(activitiesNode, streamName, "sling:OrderedFolder", create)) == null) {
                String string = null;
                return string;
            }
            if (!streamNode.hasProperty("sling:resourceType")) {
                streamNode.setProperty("sling:resourceType", RESOURCE_TYPE_ACTIVITY_STREAM);
            }
            admin.save();
            String string = streamNode.getPath();
            return string;
        }
        catch (RepositoryException e) {
            throw new ActivityException("Unable get or create user's private stream.", e);
        }
        finally {
            if (admin != null) {
                admin.logout();
            }
        }
    }

    private String internalGetOrCreateTopicStream(Resource topicResource, String streamName, boolean create) {
        Session admin = null;
        try {
            Node streamNode;
            admin = this.repository.loginAdministrative(null);
            String streamRootPath = topicResource.getPath() + "/jcr:content";
            if (!admin.nodeExists(streamRootPath)) {
                log.error("Topic {} path not exist.", (Object)streamRootPath);
                String string = null;
                return string;
            }
            Node topicHome = admin.getNode(streamRootPath);
            Node activitiesNode = this.getOrAddNode(topicHome, ACTIVITIES_NODE_NAME, "sling:OrderedFolder", create);
            if (activitiesNode == null) {
                String string = null;
                return string;
            }
            if (!activitiesNode.hasProperty("sling:resourceType")) {
                activitiesNode.setProperty("sling:resourceType", RESOURCE_TYPE_ACTIVITIES);
            }
            if ((streamNode = this.getOrAddNode(activitiesNode, streamName, "sling:OrderedFolder", create)) == null) {
                String string = null;
                return string;
            }
            if (!streamNode.hasProperty("sling:resourceType")) {
                streamNode.setProperty("sling:resourceType", RESOURCE_TYPE_ACTIVITY_STREAM);
            }
            admin.save();
            String string = streamNode.getPath();
            return string;
        }
        catch (RepositoryException e) {
            throw new ActivityException("Unable get or create a new topic stream.", e);
        }
        finally {
            if (admin != null) {
                admin.logout();
            }
        }
    }

    private String internalGetAuthorizableActivitiesPath(UserManager uMgr, String id) {
        try {
            Authorizable auth = uMgr.getAuthorizable(id);
            if (auth != null) {
                return auth.getPath() + "/" + ACTIVITIES_NODE_NAME;
            }
        }
        catch (RepositoryException e) {
            log.warn("Error while retrieving user stream path: {}", (Object)e.toString());
        }
        return null;
    }

    private Node getOrAddNode(Node parent, String name, String nodeType, boolean create) throws RepositoryException {
        if (parent.hasNode(name)) {
            return parent.getNode(name);
        }
        if (create) {
            return parent.addNode(name, nodeType);
        }
        return null;
    }

    public void onActivityAppended(JcrActivity newActivity) {
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("id", newActivity.getId());
        ((Dictionary)props).put("path", newActivity.getPath());
        EventAdmin local = this.eventAdmin;
        if (local != null) {
            local.sendEvent(new Event("com/adobe/granite/activitystreams/activity/ADDED", props));
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected void bindEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    protected void unbindEventAdmin(EventAdmin eventAdmin) {
        if (this.eventAdmin == eventAdmin) {
            this.eventAdmin = null;
        }
    }
}

