/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.activitystreams.impl;

import com.adobe.granite.activitystreams.Activity;
import com.adobe.granite.activitystreams.ActivityException;
import com.adobe.granite.activitystreams.ActivityStream;
import com.adobe.granite.activitystreams.MutableActivity;
import com.adobe.granite.activitystreams.impl.ActivityManagerImpl;
import com.adobe.granite.activitystreams.impl.JcrActivity;
import com.adobe.granite.activitystreams.utils.Util;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityStreamImpl
implements ActivityStream {
    private final ActivityManagerImpl activityManager;
    private final ResourceResolver resolver;
    private final String path;
    private static final long BUCKET_SIZE = 1000L;

    public ActivityStreamImpl(ActivityManagerImpl activityManager, ResourceResolver resolver, String path) {
        this.activityManager = activityManager;
        this.resolver = resolver;
        this.path = path;
    }

    @Override
    public String getId() {
        return this.path;
    }

    @Override
    public String getName() {
        return Text.getName((String)this.path);
    }

    @Override
    public String getTitle() {
        Node node = this.getStreamNode();
        try {
            if (node != null && node.hasProperty("jcr:content/jcr:title")) {
                return node.getProperty("jcr:content/jcr:title").getString();
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return null;
    }

    @Override
    @Deprecated
    public boolean isDefaultUserStream() {
        return this.isDefaultStream();
    }

    @Override
    public boolean isDefaultStream() {
        String defaultName = this.path.indexOf("/jcr:content/") < 0 ? "public" : "default";
        return Text.getName((String)this.path).equals(defaultName);
    }

    private Node getStreamNode() {
        Resource r = this.resolver.getResource(this.path);
        return r == null ? null : (Node)r.adaptTo(Node.class);
    }

    @Override
    public Resource getResource() {
        return this.resolver.getResource(this.path);
    }

    @Override
    public Resource getContainerResource() {
        Resource r = this.resolver.getResource(this.path);
        if (r == null) {
            return null;
        }
        Resource activities = r.getParent();
        if (activities == null) {
            return null;
        }
        Resource container = activities.getParent();
        if (container != null && container.getName().equals("jcr:content")) {
            container = container.getParent();
        }
        return container;
    }

    @Override
    public String getContainerId() {
        int idx = this.path.indexOf("/jcr:content");
        if (idx > 0) {
            return this.path.substring(0, idx);
        }
        idx = this.path.indexOf("/activities/");
        if (idx > 0) {
            return Text.getName((String)this.path.substring(0, idx));
        }
        return null;
    }

    @Override
    public Iterable<Activity> getActivities(int offset, int length) throws ActivityException {
        Node node = this.getStreamNode();
        if (node == null) {
            return Collections.emptyList();
        }
        try {
            ArrayList<Activity> ret = new ArrayList<Activity>();
            this.collectActivities(ret, node);
            Collections.sort(ret, new Comparator<Activity>(){

                @Override
                public int compare(Activity o1, Activity o2) {
                    long diff = o2.getPublished() - o1.getPublished();
                    return diff < 0L ? -1 : (diff == 0L ? 0 : 1);
                }
            });
            if (offset > ret.size()) {
                return Collections.emptyList();
            }
            if (length > 0) {
                return ret.subList(offset, Math.min(offset + length, ret.size()));
            }
            return ret;
        }
        catch (RepositoryException e) {
            throw new ActivityException("Repository error while reading activities of stream " + this.getId(), e);
        }
    }

    @Override
    public Activity append(Activity activity) throws ActivityException {
        Node node = this.getStreamNode();
        if (node == null) {
            throw new ActivityException("Stream auto-creation not supported yet.");
        }
        MutableActivity act = activity.getMutableActivity();
        if (act.getPublished() == 0L) {
            act.setPublished(System.currentTimeMillis());
        }
        if (act.getActorUserId() == null) {
            throw new ActivityException("Unable to append activity that does not specify an actor.");
        }
        int numRetries = 10;
        Node actNode = null;
        while (numRetries-- > 0) {
            try {
                actNode = this.writeActivityNode(node, act);
                node.getSession().save();
                break;
            }
            catch (InvalidItemStateException e) {
                try {
                    node.getSession().refresh(false);
                }
                catch (RepositoryException e1) {}
            }
            catch (RepositoryException e) {
                throw new ActivityException("Unable to persist activity", e);
            }
        }
        if (actNode == null) {
            throw new ActivityException("Unable to persist newly created activity after 10 retries.");
        }
        try {
            JcrActivity newActivity = new JcrActivity(this.activityManager, this.resolver.getResource(actNode.getPath()));
            this.activityManager.onActivityAppended(newActivity);
            return newActivity;
        }
        catch (RepositoryException e) {
            throw new ActivityException("Unable to read newly created activity", e);
        }
    }

    @Override
    public void delete() throws ActivityException {
        Node node = this.getStreamNode();
        if (node == null) {
            return;
        }
        try {
            node.remove();
            node.getSession().save();
        }
        catch (RepositoryException e) {
            throw new ActivityException("Error while deleting activity stream", e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ActivityStream)) {
            return false;
        }
        ActivityStream that = (ActivityStream)o;
        return this.path.equals(that.getId());
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    private Node writeActivityNode(Node streamNode, MutableActivity act) throws RepositoryException {
        String name;
        Node dayNode;
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(act.getPublished());
        Node yearNode = JcrUtils.getOrAddNode((Node)streamNode, (String)String.valueOf(c.get(1)), (String)"sling:OrderedFolder");
        String month = String.valueOf(c.get(2) + 1);
        month = month.length() > 1 ? month : "0" + month;
        Node monthNode = JcrUtils.getOrAddNode((Node)yearNode, (String)month, (String)"sling:OrderedFolder");
        String day = String.valueOf(c.get(5));
        day = day.length() > 1 ? day : "0" + day;
        Node parentNode = dayNode = JcrUtils.getOrAddNode((Node)monthNode, (String)day, (String)"sling:OrderedFolder");
        NodeIterator iter = dayNode.getNodes();
        long size = iter.getSize();
        if (size < 0L || size > 1000L) {
            size = 0L;
            int maxNum = -1;
            while (iter.hasNext()) {
                int buckNum;
                ++size;
                Node child = iter.nextNode();
                String name2 = child.getName();
                if (name2.charAt(0) != '@' || (buckNum = Integer.parseInt(name2.substring(1))) <= maxNum) continue;
                maxNum = buckNum;
                parentNode = child;
            }
            if (size > 1000L && (maxNum < 0 || this.numChildNodes(parentNode, 1000L) >= 1000L)) {
                parentNode = dayNode.addNode("@" + String.valueOf(maxNum + 1), "sling:OrderedFolder");
            }
        }
        if ((name = act.getTitle()) == null) {
            name = "activity " + act.getActorUserId() + " " + act.getVerb();
        }
        name = Util.createValidName(name);
        Node activityNode = JcrUtils.getOrCreateUniqueByPath((Node)parentNode, (String)name, (String)"nt:unstructured");
        JcrActivity.write(activityNode, act);
        act.setId(activityNode.getPath());
        return activityNode;
    }

    private long numChildNodes(Node node, long limit) throws RepositoryException {
        NodeIterator iter = node.getNodes();
        if (iter.getSize() >= 0L) {
            return iter.getSize();
        }
        int num = 0;
        while (iter.hasNext() && (long)num < limit) {
            iter.nextNode();
            ++num;
        }
        return num;
    }

    private void collectActivities(List<Activity> activities, Node parent) throws RepositoryException {
        NodeIterator iter = parent.getNodes();
        while (iter.hasNext()) {
            Node child = iter.nextNode();
            if (JcrActivity.isActivityNode(child)) {
                activities.add(new JcrActivity(this.activityManager, this.resolver.getResource(child.getPath())));
                continue;
            }
            this.collectActivities(activities, child);
        }
    }
}

