/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.activitystreams.impl;

import com.adobe.granite.activitystreams.Activity;
import com.adobe.granite.activitystreams.ActivityObject;
import com.adobe.granite.activitystreams.ActivityStream;
import com.adobe.granite.activitystreams.MediaLink;
import com.adobe.granite.activitystreams.MutableActivity;
import com.adobe.granite.activitystreams.impl.ActivityManagerImpl;
import com.adobe.granite.activitystreams.impl.ActivityStreamImpl;
import com.adobe.granite.activitystreams.impl.JcrActivityObject;
import com.adobe.granite.activitystreams.impl.JcrBase;
import com.adobe.granite.activitystreams.impl.JcrMediaLink;
import com.adobe.granite.activitystreams.impl.MutableActivityImpl;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.commons.json.JSONObject;

public class JcrActivity
extends JcrBase
implements Activity {
    public static final String PROPERTY_ACTOR = "actor";
    public static final String PROPERTY_ACTOR_ID = "jcr:createdBy";
    public static final String PROPERTY_CONTENT = "jcr:description";
    public static final String PROPERTY_GENERATOR = "generator";
    public static final String PROPERTY_ICON = "icon";
    public static final String PROPERTY_ID = "id";
    public static final String PROPERTY_OBJECT = "object";
    public static final String PROPERTY_PUBLISHED = "jcr:created";
    public static final String PROPERTY_PROVIDER = "provider";
    public static final String PROPERTY_TARGET = "target";
    public static final String PROPERTY_TITLE = "jcr:title";
    public static final String PROPERTY_TITLE_LEGACY = "title";
    public static final String PROPERTY_UPDATED = "jcr:lastModified";
    public static final String PROPERTY_URL = "url";
    public static final String PROPERTY_VERB = "verb";
    public static final String RESOURCE_TYPE_ACTIVITY = "granite/activitystreams/components/activity";
    public static final String RESOURCE_TYPE_CQ_ACTIVITY = "cq/activitystreams/components/activity";
    public static final Set<String> RESERVED_ACTIVITY_PROPERTIES;
    private final ActivityManagerImpl activityManager;

    public static boolean isActivityNode(Node node) throws RepositoryException {
        if (node.hasProperty("sling:resourceType")) {
            String rt = node.getProperty("sling:resourceType").getString();
            return rt.equals(RESOURCE_TYPE_ACTIVITY) || rt.equals(RESOURCE_TYPE_CQ_ACTIVITY);
        }
        return false;
    }

    public JcrActivity(ActivityManagerImpl activityManager, Resource resource) {
        super(resource);
        this.activityManager = activityManager;
    }

    public String getId() {
        return (String)this.properties.get(PROPERTY_ID, (Object)this.getPath());
    }

    public String getURL() {
        return (String)this.properties.get(PROPERTY_URL, (Object)(this.getId() + ".html"));
    }

    public String getVerb() {
        return (String)this.properties.get(PROPERTY_VERB, (Object)"post");
    }

    public String getTitle() {
        String title = (String)this.properties.get(PROPERTY_TITLE, String.class);
        if (title == null) {
            title = (String)this.properties.get(PROPERTY_TITLE_LEGACY, String.class);
        }
        return title;
    }

    public ActivityObject getActor() {
        return this.readObject(PROPERTY_ACTOR);
    }

    public String getActorUserId() {
        return (String)this.properties.get(PROPERTY_ACTOR_ID, String.class);
    }

    public String getContent() {
        return (String)this.properties.get(PROPERTY_CONTENT, String.class);
    }

    public ActivityObject getTarget() {
        return this.readObject(PROPERTY_TARGET);
    }

    public ActivityObject getObject() {
        return this.readObject(PROPERTY_OBJECT);
    }

    public long getPublished() {
        return (Long)this.properties.get(PROPERTY_PUBLISHED, (Object)0L);
    }

    public ActivityObject getProvider() {
        return this.readObject(PROPERTY_PROVIDER);
    }

    public ActivityObject getGenerator() {
        return this.readObject(PROPERTY_GENERATOR);
    }

    public long getUpdated() {
        return (Long)this.properties.get(PROPERTY_UPDATED, (Object)0L);
    }

    public MediaLink getIcon() {
        return this.readMediaLink(PROPERTY_ICON);
    }

    public MutableActivity getMutableActivity() {
        return new MutableActivityImpl(this, this.resource);
    }

    public JSONObject toJSON() {
        return this.getMutableActivity().toJSON();
    }

    public ActivityStream getStream() {
        Resource r;
        for (r = this.getResource(); r != null && !r.isResourceType("granite/activitystreams/components/stream"); r = r.getParent()) {
        }
        if (r != null) {
            return new ActivityStreamImpl(this.activityManager, r.getResourceResolver(), r.getPath());
        }
        return null;
    }

    public static void write(Node activityNode, MutableActivity act) throws RepositoryException {
        JcrActivityObject.write(activityNode, PROPERTY_ACTOR, act.getActor());
        JcrActivity.writeProperty(activityNode, PROPERTY_ACTOR_ID, act.getActorUserId(), null);
        JcrActivity.writeProperty(activityNode, PROPERTY_CONTENT, act.getContent(), null);
        JcrActivityObject.write(activityNode, PROPERTY_GENERATOR, act.getGenerator());
        JcrMediaLink.write(activityNode, PROPERTY_ICON, act.getIcon());
        JcrActivity.writeProperty(activityNode, PROPERTY_ID, act.getId(), null);
        JcrActivityObject.write(activityNode, PROPERTY_OBJECT, act.getObject());
        JcrActivity.writeDateProperty(activityNode, PROPERTY_PUBLISHED, act.getPublished(), 0L);
        JcrActivityObject.write(activityNode, PROPERTY_PROVIDER, act.getProvider());
        JcrActivityObject.write(activityNode, PROPERTY_TARGET, act.getTarget());
        JcrActivity.writeProperty(activityNode, PROPERTY_TITLE, act.getTitle(), null);
        JcrActivity.writeDateProperty(activityNode, PROPERTY_UPDATED, act.getUpdated(), 0L);
        JcrActivity.writeProperty(activityNode, PROPERTY_URL, act.getURL(), null);
        JcrActivity.writeProperty(activityNode, PROPERTY_VERB, act.getVerb(), "post");
        JcrActivity.writeProperties(activityNode, act.getProperties(), RESERVED_ACTIVITY_PROPERTIES);
        if (!activityNode.hasProperty("sling:resourceType")) {
            activityNode.setProperty("sling:resourceType", RESOURCE_TYPE_ACTIVITY);
        }
    }

    static {
        HashSet<String> reserved = new HashSet<String>();
        reserved.add(PROPERTY_ID);
        reserved.add(PROPERTY_URL);
        reserved.add(PROPERTY_VERB);
        reserved.add(PROPERTY_TITLE);
        reserved.add(PROPERTY_ACTOR);
        reserved.add(PROPERTY_ACTOR_ID);
        reserved.add(PROPERTY_CONTENT);
        reserved.add(PROPERTY_GENERATOR);
        reserved.add(PROPERTY_TARGET);
        reserved.add(PROPERTY_OBJECT);
        reserved.add(PROPERTY_PUBLISHED);
        reserved.add(PROPERTY_PROVIDER);
        reserved.add(PROPERTY_UPDATED);
        reserved.add(PROPERTY_ICON);
        reserved.add(PROPERTY_ID);
        reserved.add(PROPERTY_URL);
        reserved.add(PROPERTY_VERB);
        reserved.add(PROPERTY_TITLE_LEGACY);
        reserved.add(PROPERTY_ACTOR);
        reserved.add("actorId");
        reserved.add("content");
        reserved.add(PROPERTY_GENERATOR);
        reserved.add(PROPERTY_TARGET);
        reserved.add(PROPERTY_OBJECT);
        reserved.add("published");
        reserved.add(PROPERTY_PROVIDER);
        reserved.add("updated");
        reserved.add(PROPERTY_ICON);
        reserved.add("jcr:primaryType");
        reserved.add("sling:resourceType");
        RESERVED_ACTIVITY_PROPERTIES = Collections.unmodifiableSet(reserved);
    }
}

