/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.activitystreams.impl;

import com.adobe.granite.activitystreams.ActivityObject;
import com.adobe.granite.activitystreams.MediaLink;
import com.adobe.granite.activitystreams.MutableActivityObject;
import com.adobe.granite.activitystreams.impl.JcrBase;
import com.adobe.granite.activitystreams.impl.JcrMediaLink;
import com.adobe.granite.activitystreams.impl.MutableActivityObjectImpl;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.commons.json.JSONObject;

public class JcrActivityObject
extends JcrBase
implements ActivityObject {
    public static final String PROPERTY_ATTACHMENTS = "attachments";
    public static final String PROPERTY_AUTHOR = "author";
    public static final String PROPERTY_AUTHOR_ID = "authorId";
    public static final String PROPERTY_CONTENT = "jcr:description";
    public static final String PROPERTY_DISPLAY_NAME = "displayName";
    public static final String PROPERTY_DS_DUPLICATES = "downstreamDuplicates";
    public static final String PROPERTY_ID = "id";
    public static final String PROPERTY_IMAGE = "image";
    public static final String PROPERTY_OBJECT_TYPE = "objectType";
    public static final String PROPERTY_PUBLISHED = "jcr:created";
    public static final String PROPERTY_SUMMARY = "summary";
    public static final String PROPERTY_UPDATED = "jcr:lastModified";
    public static final String PROPERTY_US_DUPLICATES = "upstreamDuplicates";
    public static final String PROPERTY_URL = "url";
    public static final Set<String> RESERVED_OBJECT_PROPERTIES;

    public JcrActivityObject(Resource resource) {
        super(resource);
    }

    public String getId() {
        return (String)this.properties.get(PROPERTY_ID, null);
    }

    public String getURL() {
        return (String)this.properties.get(PROPERTY_URL, null);
    }

    public String getObjectType() {
        return (String)this.properties.get(PROPERTY_OBJECT_TYPE, null);
    }

    public String getDisplayName() {
        return (String)this.properties.get(PROPERTY_DISPLAY_NAME, null);
    }

    public String getSummary() {
        return (String)this.properties.get(PROPERTY_SUMMARY, null);
    }

    public MediaLink getImage() {
        return this.readMediaLink(PROPERTY_IMAGE);
    }

    public ActivityObject getAuthor() {
        return this.readObject(PROPERTY_AUTHOR);
    }

    public String getAuthorUserId() {
        return (String)this.properties.get(PROPERTY_AUTHOR_ID, null);
    }

    public ActivityObject[] getAttachments() {
        return null;
    }

    public String[] getDownstreamDuplicates() {
        return (String[])this.properties.get(PROPERTY_DS_DUPLICATES, String[].class);
    }

    public String[] getUpstreamDuplicates() {
        return (String[])this.properties.get(PROPERTY_US_DUPLICATES, String[].class);
    }

    public MutableActivityObject getMutableActivityObject() {
        return new MutableActivityObjectImpl(this, this.resource);
    }

    public String getContent() {
        return (String)this.properties.get(PROPERTY_CONTENT, String.class);
    }

    public long getPublished() {
        return (Long)this.properties.get(PROPERTY_PUBLISHED, (Object)0L);
    }

    public long getUpdated() {
        return (Long)this.properties.get(PROPERTY_UPDATED, (Object)0L);
    }

    public JSONObject toJSON() {
        return this.getMutableActivityObject().toJSON();
    }

    public static void write(Node node, String name, ActivityObject obj) throws RepositoryException {
        if (obj == null) {
            return;
        }
        Node objectNode = node.addNode(name, "{http://www.jcp.org/jcr/nt/1.0}unstructured");
        JcrActivityObject.write(objectNode, PROPERTY_AUTHOR, obj.getAuthor());
        JcrActivityObject.writeProperty(objectNode, PROPERTY_AUTHOR_ID, obj.getAuthorUserId(), null);
        JcrActivityObject.writeProperty(objectNode, PROPERTY_CONTENT, obj.getContent(), null);
        JcrActivityObject.writeProperty(objectNode, PROPERTY_DISPLAY_NAME, obj.getDisplayName(), null);
        JcrActivityObject.writeProperty(objectNode, PROPERTY_ID, obj.getId(), null);
        JcrMediaLink.write(objectNode, PROPERTY_IMAGE, obj.getImage());
        JcrActivityObject.writeProperty(objectNode, PROPERTY_OBJECT_TYPE, obj.getObjectType(), null);
        JcrActivityObject.writeDateProperty(objectNode, PROPERTY_PUBLISHED, obj.getPublished(), 0L);
        JcrActivityObject.writeProperty(objectNode, PROPERTY_SUMMARY, obj.getSummary(), null);
        JcrActivityObject.writeDateProperty(objectNode, PROPERTY_UPDATED, obj.getUpdated(), 0L);
        JcrActivityObject.writeProperty(objectNode, PROPERTY_URL, obj.getURL(), null);
        JcrActivityObject.writeProperties(objectNode, obj.getProperties(), RESERVED_OBJECT_PROPERTIES);
    }

    static {
        HashSet<String> reserved = new HashSet<String>();
        reserved.add(PROPERTY_ID);
        reserved.add(PROPERTY_URL);
        reserved.add(PROPERTY_OBJECT_TYPE);
        reserved.add(PROPERTY_DISPLAY_NAME);
        reserved.add(PROPERTY_SUMMARY);
        reserved.add(PROPERTY_CONTENT);
        reserved.add(PROPERTY_IMAGE);
        reserved.add(PROPERTY_PUBLISHED);
        reserved.add(PROPERTY_UPDATED);
        reserved.add(PROPERTY_AUTHOR);
        reserved.add(PROPERTY_AUTHOR_ID);
        reserved.add(PROPERTY_ATTACHMENTS);
        reserved.add(PROPERTY_DS_DUPLICATES);
        reserved.add(PROPERTY_US_DUPLICATES);
        reserved.add(PROPERTY_ID);
        reserved.add(PROPERTY_URL);
        reserved.add(PROPERTY_OBJECT_TYPE);
        reserved.add(PROPERTY_DISPLAY_NAME);
        reserved.add(PROPERTY_SUMMARY);
        reserved.add("content");
        reserved.add(PROPERTY_IMAGE);
        reserved.add("updated");
        reserved.add(PROPERTY_AUTHOR);
        reserved.add(PROPERTY_AUTHOR_ID);
        reserved.add(PROPERTY_ATTACHMENTS);
        reserved.add(PROPERTY_DS_DUPLICATES);
        reserved.add(PROPERTY_US_DUPLICATES);
        reserved.add("jcr:primaryType");
        reserved.add("sling:resourceType");
        RESERVED_OBJECT_PROPERTIES = Collections.unmodifiableSet(reserved);
    }
}

