/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.activitystreams.impl;

import com.adobe.granite.activitystreams.ActivityObject;
import com.adobe.granite.activitystreams.MediaLink;
import com.adobe.granite.activitystreams.MutableActivityObject;
import com.adobe.granite.activitystreams.impl.JcrActivityObject;
import com.adobe.granite.activitystreams.impl.MutableBase;
import com.adobe.granite.activitystreams.impl.MutableMediaLinkImpl;
import com.adobe.granite.activitystreams.utils.Util;
import java.util.Iterator;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MutableActivityObjectImpl
extends MutableBase
implements ActivityObject,
MutableActivityObject {
    private static final Logger log = LoggerFactory.getLogger(MutableActivityObjectImpl.class);

    protected MutableActivityObjectImpl() {
    }

    protected MutableActivityObjectImpl(JSONObject jsonObject) {
        if (jsonObject == null) {
            return;
        }
        Iterator iter = jsonObject.keys();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            try {
                Object value = jsonObject.get(key);
                if (value instanceof JSONObject) {
                    if ("image".equals(key)) {
                        this.properties.put((Object)key, (Object)new MutableMediaLinkImpl(jsonObject.getJSONObject(key)));
                        continue;
                    }
                    this.properties.put((Object)key, (Object)new MutableActivityObjectImpl(jsonObject.getJSONObject(key)));
                    continue;
                }
                this.properties.put((Object)key, value);
            }
            catch (JSONException e) {
                log.error("Error while getting data from JSON object", (Throwable)e);
            }
        }
    }

    protected MutableActivityObjectImpl(ActivityObject obj, Resource resource) {
        this.setAttachments(obj.getAttachments());
        this.setAuthor(Util.copy(obj.getAuthor()));
        this.setAuthorUserId(obj.getAuthorUserId());
        this.setContent(obj.getContent());
        this.setDisplayName(obj.getDisplayName());
        this.setDownstreamDuplicates(obj.getDownstreamDuplicates());
        this.setId(obj.getId());
        this.setImage(Util.copy(obj.getImage()));
        this.setObjectType(obj.getObjectType());
        this.setPublished(obj.getPublished());
        this.setSummary(obj.getSummary());
        this.setUpdated(obj.getUpdated());
        this.setUpstreamDuplicates(obj.getUpstreamDuplicates());
        this.setURL(obj.getURL());
        this.copyCustomProperties(obj.getProperties(), resource, JcrActivityObject.RESERVED_OBJECT_PROPERTIES);
    }

    public String getId() {
        return (String)this.properties.get("id", String.class);
    }

    public MutableActivityObject setId(String id) {
        this.properties.put((Object)"id", (Object)id);
        return this;
    }

    public String getURL() {
        return (String)this.properties.get("url", String.class);
    }

    public MutableActivityObject setURL(String url) {
        this.properties.put((Object)"url", (Object)url);
        return this;
    }

    public String getObjectType() {
        return (String)this.properties.get("objectType", String.class);
    }

    public MutableActivityObject setObjectType(String objectType) {
        this.properties.put((Object)"objectType", (Object)objectType);
        return this;
    }

    public ActivityObject getAuthor() {
        return (ActivityObject)this.properties.get((Object)"author");
    }

    public MutableActivityObject setAuthor(ActivityObject author) {
        this.properties.put((Object)"author", (Object)author);
        return this;
    }

    public String getAuthorUserId() {
        return (String)this.properties.get("authorId", String.class);
    }

    public MutableActivityObject setAuthorUserId(String userId) {
        this.properties.put((Object)"authorId", (Object)userId);
        return this;
    }

    public String getContent() {
        return (String)this.properties.get("content", String.class);
    }

    public MutableActivityObject setContent(String content) {
        this.properties.put((Object)"content", (Object)content);
        return this;
    }

    public String getDisplayName() {
        return (String)this.properties.get("displayName", String.class);
    }

    public MutableActivityObject setDisplayName(String displayName) {
        this.properties.put((Object)"displayName", (Object)displayName);
        return this;
    }

    public String getSummary() {
        return (String)this.properties.get("summary", String.class);
    }

    public MutableActivityObject setSummary(String summary) {
        this.properties.put((Object)"summary", (Object)summary);
        return this;
    }

    public long getPublished() {
        return (Long)this.properties.get("published", (Object)0L);
    }

    public MutableActivityObject setPublished(long published) {
        this.properties.put((Object)"published", (Object)published);
        return this;
    }

    public long getUpdated() {
        return (Long)this.properties.get("updated", (Object)0L);
    }

    public MutableActivityObject setUpdated(long updated) {
        this.properties.put((Object)"updated", (Object)updated);
        return this;
    }

    public MediaLink getImage() {
        return (MediaLink)this.properties.get((Object)"image");
    }

    public MutableActivityObject setImage(MediaLink icon) {
        this.properties.put((Object)"image", (Object)icon);
        return this;
    }

    public ActivityObject[] getAttachments() {
        return (ActivityObject[])this.properties.get((Object)"attachments");
    }

    public MutableActivityObject setAttachments(ActivityObject[] attachments) {
        this.properties.put((Object)"attachments", (Object)attachments);
        return this;
    }

    public String[] getDownstreamDuplicates() {
        return (String[])this.properties.get("downstreamDuplicates", String[].class);
    }

    public MutableActivityObject setDownstreamDuplicates(String[] ids) {
        this.properties.put((Object)"downstreamDuplicates", (Object)ids);
        return this;
    }

    public String[] getUpstreamDuplicates() {
        return (String[])this.properties.get("upstreamDuplicates", String[].class);
    }

    public MutableActivityObject setUpstreamDuplicates(String[] ids) {
        this.properties.put((Object)"upstreamDuplicates", (Object)ids);
        return this;
    }

    public MutableActivityObject setProperty(String name, Object value) {
        this.properties.put((Object)name, value);
        return this;
    }

    public MutableActivityObject getMutableActivityObject() {
        return this;
    }
}

