/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.activitystreams.impl;

import com.adobe.granite.activitystreams.MediaLink;
import com.adobe.granite.activitystreams.MutableMediaLink;
import com.adobe.granite.activitystreams.impl.JcrMediaLink;
import com.adobe.granite.activitystreams.impl.MutableActivityObjectImpl;
import com.adobe.granite.activitystreams.impl.MutableBase;
import java.util.Iterator;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MutableMediaLinkImpl
extends MutableBase
implements MutableMediaLink {
    private static final Logger log = LoggerFactory.getLogger(MutableMediaLinkImpl.class);

    public MutableMediaLinkImpl() {
    }

    protected MutableMediaLinkImpl(JSONObject jsonObject) {
        if (jsonObject == null) {
            return;
        }
        Iterator iter = jsonObject.keys();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            try {
                Object value = jsonObject.get(key);
                if (value instanceof JSONObject) {
                    this.properties.put((Object)key, (Object)new MutableActivityObjectImpl(jsonObject.getJSONObject(key)));
                    continue;
                }
                this.properties.put((Object)key, value);
            }
            catch (JSONException e) {
                log.error("Error while getting data from JSON object", (Throwable)e);
            }
        }
    }

    public MutableMediaLinkImpl(MediaLink link, Resource resource) {
        this.setURL(link.getURL());
        this.setDuration(link.getDuration());
        this.setWidth(link.getWidth());
        this.setHeight(link.getHeight());
        this.copyCustomProperties(link.getProperties(), resource, JcrMediaLink.RESERVED_MEDIA_PROPERTIES);
    }

    public String getURL() {
        return (String)this.properties.get("url", String.class);
    }

    public MutableMediaLink setURL(String url) {
        this.properties.put((Object)"url", (Object)url);
        return this;
    }

    public int getWidth() {
        return (Integer)this.properties.get("width", (Object)0);
    }

    public MutableMediaLink setWidth(int width) {
        this.properties.put((Object)"width", (Object)width);
        return this;
    }

    public int getHeight() {
        return (Integer)this.properties.get("height", (Object)0);
    }

    public MutableMediaLink setHeight(int height) {
        this.properties.put((Object)"height", (Object)height);
        return this;
    }

    public int getDuration() {
        return (Integer)this.properties.get("duration", (Object)0);
    }

    public MutableMediaLink setDuration(int duration) {
        this.properties.put((Object)"duration", (Object)duration);
        return this;
    }

    public MutableMediaLink setProperty(String name, Object value) {
        this.properties.put((Object)name, value);
        return this;
    }

    public MutableMediaLink getMutableMediaLink() {
        return this;
    }
}

