/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.activitystreams.impl;

import com.adobe.granite.activitystreams.Activity;
import com.adobe.granite.activitystreams.ActivityCollection;
import com.adobe.granite.activitystreams.ActivityException;
import com.adobe.granite.activitystreams.ActivityStream;
import com.adobe.granite.activitystreams.impl.ActivityManagerImpl;
import com.adobe.granite.activitystreams.impl.JcrActivity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamsAggregate
implements ActivityCollection {
    private static final Logger log = LoggerFactory.getLogger(StreamsAggregate.class);
    private final ActivityManagerImpl activityManager;
    private final ResourceResolver resolver;
    private final Collection<ActivityStream> streams;

    public StreamsAggregate(ActivityManagerImpl activityManager, ResourceResolver resolver, Collection<ActivityStream> streams) {
        this.activityManager = activityManager;
        this.resolver = resolver;
        this.streams = streams;
    }

    @Override
    public Iterable<Activity> getActivities(int offset, int length) throws ActivityException {
        ArrayList<Activity> ret = new ArrayList<Activity>();
        for (ActivityStream stream : this.streams) {
            try {
                Node node;
                Resource r = stream.getResource();
                Node node2 = node = r == null ? null : (Node)r.adaptTo(Node.class);
                if (node == null) {
                    log.debug("Unable to read stream {}", (Object)stream.getId());
                    continue;
                }
                this.collectActivities(ret, node);
            }
            catch (RepositoryException e) {
                log.warn("Error while traversing nodes", (Throwable)e);
            }
        }
        Collections.sort(ret, new Comparator<Activity>(){

            @Override
            public int compare(Activity o1, Activity o2) {
                return (int)(o2.getPublished() - o1.getPublished());
            }
        });
        if (offset > ret.size()) {
            return Collections.emptyList();
        }
        if (length > 0) {
            return ret.subList(offset, Math.min(offset + length, ret.size()));
        }
        return ret;
    }

    private void collectActivities(List<Activity> activities, Node parent) throws RepositoryException {
        NodeIterator iter = parent.getNodes();
        while (iter.hasNext()) {
            Node child = iter.nextNode();
            if (JcrActivity.isActivityNode(child)) {
                activities.add(new JcrActivity(this.activityManager, this.resolver.getResource(child.getPath())));
                continue;
            }
            this.collectActivities(activities, child);
        }
    }
}

