/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.activitystreams.impl.rest;

import com.adobe.granite.activitystreams.Activity;
import com.adobe.granite.activitystreams.ActivityCollection;
import com.adobe.granite.activitystreams.ActivityManager;
import com.adobe.granite.activitystreams.ActivityStream;
import com.adobe.granite.activitystreams.AggregateOptions;
import com.adobe.granite.activitystreams.MutableActivity;
import com.adobe.granite.activitystreams.utils.GenericAggregateOptions;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.servlet.ServletException;
import org.apache.commons.io.IOUtils;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.commons.json.io.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingServlet(resourceTypes={"granite/activitystreams/components/activities"}, methods={"GET", "POST"})
public class ActivitiesServlet
extends SlingAllMethodsServlet {
    private static final long serialVersionUID = -4571680968447024900L;
    protected final Logger log = LoggerFactory.getLogger(ActivitiesServlet.class);
    public static final String PARAM_TYPE = "type";
    public static final String SELF_TYPE = "self";
    public static final String PARAM_LIMIT = "limit";
    public static final String PARAM_OFFSET = "offset";
    @Reference
    protected ActivityManager activityMgr;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        try {
            ActivityCollection collection;
            Resource container = request.getResource().getParent();
            Authorizable auth = (Authorizable)container.adaptTo(Authorizable.class);
            if (auth == null || !(auth instanceof User)) {
                response.setStatus(404);
                response.flushBuffer();
                return;
            }
            int limit = ActivitiesServlet.toInt(request.getParameter(PARAM_LIMIT));
            int offset = ActivitiesServlet.toInt(request.getParameter(PARAM_OFFSET));
            String[] types = request.getParameterValues(PARAM_TYPE);
            if (types == null || types.length == 0) {
                collection = this.activityMgr.getActivities(request.getResourceResolver(), auth.getID());
            } else if (types.length == 1 && types[0].equals(SELF_TYPE)) {
                collection = this.activityMgr.getActivities(request.getResourceResolver(), auth.getID(), AggregateOptions.DIRECT);
            } else {
                GenericAggregateOptions options = new GenericAggregateOptions().setRelationshipTypes(types);
                collection = this.activityMgr.getActivities(request.getResourceResolver(), auth.getID(), options);
            }
            response.setContentType("application/json");
            response.setCharacterEncoding("utf8");
            response.setHeader("Cache-Control", "no-cache");
            response.setStatus(200);
            JSONWriter w = new JSONWriter((Writer)response.getWriter());
            w.object();
            w.key("items");
            w.array();
            for (Activity a : collection.getActivities(offset, limit)) {
                w.value((Object)a.toJSON());
            }
            w.endArray();
            w.endObject();
        }
        catch (Exception e) {
            this.log.error("Error while reading the activities", (Throwable)e);
            response.setStatus(500);
        }
    }

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        try {
            String operation = request.getParameter(":operation");
            if ("delete".equals(operation)) {
                ((Node)request.getResource().adaptTo(Node.class)).remove();
                ((Session)request.getResourceResolver().adaptTo(Session.class)).save();
                response.setStatus(200);
                return;
            }
            ActivityStream stream = this.activityMgr.getStream(request.getResource().getParent(), null, false);
            if (stream == null) {
                response.setStatus(404);
                response.flushBuffer();
                return;
            }
            String json = IOUtils.toString((Reader)request.getReader());
            MutableActivity activity = this.activityMgr.newActivity(new JSONObject(json));
            if (activity.getActorUserId() == null || "".equals(activity.getActorUserId())) {
                Resource container = stream.getContainerResource();
                Authorizable auth = (Authorizable)container.adaptTo(Authorizable.class);
                if (auth == null || !(auth instanceof User)) {
                    activity.setActorUserId(request.getRemoteUser());
                } else {
                    activity.setActorUserId(auth.getID());
                }
            }
            Activity newActivity = stream.append(activity);
            response.setContentType("application/json");
            response.setCharacterEncoding("utf8");
            response.setHeader("Location", newActivity.getId());
            response.setStatus(201);
            newActivity.toJSON().write((Writer)response.getWriter());
        }
        catch (Exception e) {
            this.log.error("Error while creating activity", (Throwable)e);
            response.setStatus(500);
        }
    }

    private static int toInt(String str) {
        try {
            return str == null ? 0 : Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    protected void bindActivityMgr(ActivityManager activityManager) {
        this.activityMgr = activityManager;
    }

    protected void unbindActivityMgr(ActivityManager activityManager) {
        if (this.activityMgr == activityManager) {
            this.activityMgr = null;
        }
    }
}

