/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.activitystreams.impl.rest;

import com.adobe.granite.activitystreams.ActivityManager;
import com.adobe.granite.activitystreams.ActivityStream;
import com.adobe.granite.activitystreams.utils.GenericAggregateOptions;
import com.adobe.granite.activitystreams.utils.GenericStreamFilter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.servlet.ServletException;
import org.apache.commons.lang.ArrayUtils;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingServlet(paths={"/libs/sling/servlet/default/activitystreams.GET.servlet", "/libs/sling/servlet/default/activitystreams.POST.servlet"})
public class ActivityStreamDiscoveryServlet
extends SlingAllMethodsServlet {
    private static final long serialVersionUID = -4571680968447024900L;
    protected final Logger log = LoggerFactory.getLogger(ActivityStreamDiscoveryServlet.class);
    public static final String PARAM_MODE = "mode";
    public static final String PARAM_TYPE = "type";
    public static final String SELF_TYPE = "self";
    @Reference
    protected ActivityManager activityMgr;

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        try {
            String title;
            String name = request.getParameter("name");
            ActivityStream stream = this.activityMgr.getStream(request.getResource(), name, false);
            boolean created = false;
            if (stream == null) {
                stream = this.activityMgr.getStream(request.getResource(), name, true);
                if (stream == null) {
                    response.setStatus(404);
                    response.flushBuffer();
                    return;
                }
                created = true;
            }
            if ((title = request.getParameter("title")) != null) {
                Node streamNode = (Node)stream.getResource().adaptTo(Node.class);
                Node content = streamNode.hasNode("jcr:content") ? streamNode.getNode("jcr:content") : streamNode.addNode("jcr:content");
                content.setProperty("jcr:title", title);
                streamNode.getSession().save();
            }
            response.setContentType("application/json");
            response.setCharacterEncoding("utf8");
            response.setHeader("Location", stream.getId());
            response.setHeader("Cache-Control", "no-cache");
            if (created) {
                response.setStatus(201);
            } else {
                response.setStatus(200);
            }
            JSONWriter w = new JSONWriter((Writer)response.getWriter());
            w.object();
            w.key("id").value((Object)stream.getId());
            w.key("status").value((Object)"ok");
            w.endObject();
        }
        catch (Exception e) {
            this.log.error("Error while creating activity stream", (Throwable)e);
            response.setStatus(500);
        }
    }

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        if (ResourceUtil.isNonExistingResource((Resource)request.getResource())) {
            response.setStatus(404);
            response.flushBuffer();
            return;
        }
        try {
            Collection<ActivityStream> streams;
            String[] types;
            GenericStreamFilter filter = new GenericStreamFilter().setMode(GenericStreamFilter.MODE.R);
            GenericAggregateOptions options = new GenericAggregateOptions().setRelationshipTypes(ArrayUtils.EMPTY_STRING_ARRAY).setActivityStreamFilter(filter);
            String mode = request.getParameter(PARAM_MODE);
            if (mode != null) {
                try {
                    filter.setMode(GenericStreamFilter.MODE.valueOf(mode.toUpperCase()));
                }
                catch (IllegalArgumentException e) {
                    this.log.warn("illegal mode specified: {}", (Object)mode);
                }
            }
            if ((types = request.getParameterValues(PARAM_TYPE)) != null && types.length == 1 && types[0].equals(SELF_TYPE)) {
                streams = this.activityMgr.listStreams(request.getResource());
            } else {
                options.setRelationshipTypes(types);
                Authorizable auth = (Authorizable)request.getResource().adaptTo(Authorizable.class);
                streams = auth instanceof User ? this.activityMgr.listStreams(request.getResourceResolver(), auth.getID(), options) : this.activityMgr.listStreams(request.getResource());
            }
            if (streams == null) {
                response.setStatus(404);
                response.flushBuffer();
                return;
            }
            response.setContentType("application/json");
            response.setCharacterEncoding("utf8");
            response.setHeader("Cache-Control", "no-cache");
            JSONWriter w = new JSONWriter((Writer)response.getWriter());
            w.object();
            w.key("items").array();
            for (ActivityStream stream : streams) {
                w.object();
                w.key("id").value((Object)stream.getId());
                w.key("name").value((Object)stream.getName());
                if (stream.getTitle() != null) {
                    w.key("title").value((Object)stream.getTitle());
                }
                w.key("isDefault").value(stream.isDefaultStream());
                w.key("containerId").value((Object)stream.getContainerId());
                w.endObject();
            }
            w.endArray();
            w.endObject();
        }
        catch (JSONException e) {
            this.log.error("Error while listing activity stream", (Throwable)e);
            response.setStatus(500);
        }
        catch (RepositoryException e) {
            this.log.error("Error while listing activity stream", (Throwable)e);
            response.setStatus(500);
        }
    }

    protected void bindActivityMgr(ActivityManager activityManager) {
        this.activityMgr = activityManager;
    }

    protected void unbindActivityMgr(ActivityManager activityManager) {
        if (this.activityMgr == activityManager) {
            this.activityMgr = null;
        }
    }
}

