/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.activitystreams.utils;

import com.adobe.granite.activitystreams.Activity;
import com.adobe.granite.activitystreams.ActivityObject;
import com.adobe.granite.activitystreams.MediaLink;
import com.adobe.granite.activitystreams.MutableActivity;
import com.adobe.granite.activitystreams.MutableActivityObject;
import com.adobe.granite.activitystreams.MutableMediaLink;

public class Util {
    public static final String[] STANDARD_LABEL_CHAR_MAPPING = new String[]{"_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "-", "_", "_", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "_", "_", "_", "_", "_", "_", "_", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "_", "_", "_", "_", "_", "_", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "_", "_", "_", "_", "_", "_", "f", "_", "_", "_", "fi", "fi", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "y", "_", "_", "_", "_", "i", "c", "p", "o", "v", "_", "s", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "_", "a", "a", "a", "a", "ae", "a", "ae", "c", "e", "e", "e", "e", "i", "i", "i", "i", "d", "n", "o", "o", "o", "o", "oe", "x", "o", "u", "u", "u", "ue", "y", "b", "ss", "a", "a", "a", "a", "ae", "a", "ae", "c", "e", "e", "e", "e", "i", "i", "i", "i", "o", "n", "o", "o", "o", "o", "oe", "_", "o", "u", "u", "u", "ue", "y", "b", "y"};

    public static MutableActivityObject copy(ActivityObject obj) {
        return obj == null ? null : obj.getMutableActivityObject();
    }

    public static MutableActivity copy(Activity obj) {
        return obj == null ? null : obj.getMutableActivity();
    }

    public static MutableMediaLink copy(MediaLink obj) {
        return obj == null ? null : obj.getMutableMediaLink();
    }

    public static String createValidName(String title) {
        return Util.createValidName(title, STANDARD_LABEL_CHAR_MAPPING);
    }

    public static String createValidName(String title, String[] labelCharMapping) {
        char[] chrs = title.toCharArray();
        StringBuilder name = new StringBuilder(chrs.length);
        boolean prevEscaped = false;
        for (int idx = 0; idx < title.length() && name.length() < 64; ++idx) {
            char c = title.charAt(idx);
            String repl = "_";
            if (c >= '\u0000' && c < labelCharMapping.length) {
                repl = labelCharMapping[c];
            }
            if (repl.equals("_")) {
                if (!prevEscaped && name.length() < 16) {
                    name.append('_');
                }
                prevEscaped = true;
                continue;
            }
            name.append(repl);
            prevEscaped = false;
        }
        return name.toString();
    }
}

