/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.activitystreams.impl;

import com.adobe.granite.activitystreams.ActivityObject;
import com.adobe.granite.activitystreams.MediaLink;
import com.adobe.granite.activitystreams.impl.JcrActivityObject;
import com.adobe.granite.activitystreams.impl.JcrMediaLink;
import java.util.Calendar;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class JcrBase {
    protected final Resource resource;
    protected final Node node;
    protected final ValueMap properties;

    public JcrBase(Resource resource) {
        this.resource = resource;
        this.node = (Node)resource.adaptTo(Node.class);
        this.properties = (ValueMap)resource.adaptTo(ValueMap.class);
    }

    public String getPath() {
        return this.resource.getPath();
    }

    public Resource getResource() {
        return this.resource;
    }

    public ValueMap getProperties() {
        return this.properties;
    }

    protected ActivityObject readObject(String name) {
        Resource obj = this.resource.getChild(name);
        if (obj == null) {
            return null;
        }
        return new JcrActivityObject(obj);
    }

    protected MediaLink readMediaLink(String name) {
        Resource obj = this.resource.getChild(name);
        if (obj == null) {
            return null;
        }
        return new JcrMediaLink(obj);
    }

    protected static void writeProperties(Node node, ValueMap properties, Set<String> reserved) throws RepositoryException {
        for (Map.Entry e : properties.entrySet()) {
            String name = (String)e.getKey();
            if (reserved.contains(name)) continue;
            if (e.getValue() instanceof ActivityObject) {
                JcrActivityObject.write(node, name, (ActivityObject)e.getValue());
                continue;
            }
            if (e.getValue() instanceof MediaLink) {
                JcrMediaLink.write(node, name, (MediaLink)e.getValue());
                continue;
            }
            if (e.getValue() instanceof Calendar) {
                node.setProperty(name, (Calendar)e.getValue());
                continue;
            }
            node.setProperty(name, String.valueOf(e.getValue()));
        }
    }

    protected static void writeProperty(Node node, String name, String value, String def) throws RepositoryException {
        if (value == null || value.equals(def)) {
            return;
        }
        node.setProperty(name, value);
    }

    protected static void writeProperty(Node node, String name, long value, long def) throws RepositoryException {
        if (value == def) {
            return;
        }
        node.setProperty(name, value);
    }

    protected static void writeDateProperty(Node node, String name, long date, long def) throws RepositoryException {
        if (date == def) {
            return;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(date);
        node.setProperty(name, cal);
    }
}

