/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.activitystreams.impl;

import com.adobe.granite.activitystreams.MediaLink;
import com.adobe.granite.activitystreams.MutableMediaLink;
import com.adobe.granite.activitystreams.impl.JcrBase;
import com.adobe.granite.activitystreams.impl.MutableMediaLinkImpl;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.json.JSONObject;

public class JcrMediaLink
extends JcrBase
implements MediaLink {
    public static final String PROPERTY_WIDTH = "width";
    public static final String PROPERTY_HEIGHT = "height";
    public static final String PROPERTY_DURATION = "duration";
    public static final String PROPERTY_URL = "url";
    public static final Set<String> RESERVED_MEDIA_PROPERTIES;

    public JcrMediaLink(Resource resource) {
        super(resource);
    }

    public int getWidth() {
        return (Integer)this.properties.get(PROPERTY_WIDTH, (Object)0);
    }

    public int getHeight() {
        return (Integer)this.properties.get(PROPERTY_HEIGHT, (Object)0);
    }

    public int getDuration() {
        return (Integer)this.properties.get(PROPERTY_DURATION, (Object)0);
    }

    public String getURL() {
        return (String)this.properties.get(PROPERTY_URL, (Object)(this.getPath() + ".html"));
    }

    public ValueMap getProperties() {
        return this.properties;
    }

    public MutableMediaLink getMutableMediaLink() {
        return new MutableMediaLinkImpl(this, this.resource);
    }

    public JSONObject toJSON() {
        return this.getMutableMediaLink().toJSON();
    }

    public static void write(Node node, String name, MediaLink media) throws RepositoryException {
        if (media == null) {
            return;
        }
        Node mediaNode = node.addNode(name, "{http://www.jcp.org/jcr/nt/1.0}unstructured");
        JcrMediaLink.writeProperty(mediaNode, PROPERTY_DURATION, media.getDuration(), 0L);
        JcrMediaLink.writeProperty(mediaNode, PROPERTY_HEIGHT, media.getHeight(), 0L);
        JcrMediaLink.writeProperty(mediaNode, PROPERTY_WIDTH, media.getWidth(), 0L);
        JcrMediaLink.writeProperty(mediaNode, PROPERTY_URL, media.getURL(), null);
        JcrMediaLink.writeProperties(mediaNode, media.getProperties(), RESERVED_MEDIA_PROPERTIES);
    }

    static {
        HashSet<String> reserved = new HashSet<String>();
        reserved.add(PROPERTY_DURATION);
        reserved.add(PROPERTY_URL);
        reserved.add(PROPERTY_HEIGHT);
        reserved.add(PROPERTY_WIDTH);
        reserved.add(PROPERTY_DURATION);
        reserved.add(PROPERTY_URL);
        reserved.add(PROPERTY_HEIGHT);
        reserved.add(PROPERTY_WIDTH);
        reserved.add("jcr:primaryType");
        reserved.add("sling:resourceType");
        reserved.add("sling:resourceSuperType");
        RESERVED_MEDIA_PROPERTIES = Collections.unmodifiableSet(reserved);
    }
}

