/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.activitystreams.impl;

import com.adobe.granite.activitystreams.Activity;
import com.adobe.granite.activitystreams.ActivityObject;
import com.adobe.granite.activitystreams.ActivityStream;
import com.adobe.granite.activitystreams.MediaLink;
import com.adobe.granite.activitystreams.MutableActivity;
import com.adobe.granite.activitystreams.impl.JcrActivity;
import com.adobe.granite.activitystreams.impl.MutableActivityObjectImpl;
import com.adobe.granite.activitystreams.impl.MutableBase;
import com.adobe.granite.activitystreams.impl.MutableMediaLinkImpl;
import com.adobe.granite.activitystreams.utils.Util;
import java.util.Iterator;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MutableActivityImpl
extends MutableBase
implements MutableActivity {
    private static final Logger log = LoggerFactory.getLogger(MutableActivityImpl.class);

    public MutableActivityImpl() {
    }

    protected MutableActivityImpl(JSONObject jsonObject) {
        if (jsonObject == null) {
            return;
        }
        Iterator iter = jsonObject.keys();
        while (iter.hasNext()) {
            String key = MutableActivityImpl.assertValidKey((String)iter.next());
            try {
                Object value = jsonObject.get(key);
                if (value instanceof JSONObject) {
                    if ("icon".equals(key)) {
                        this.properties.put((Object)key, (Object)new MutableMediaLinkImpl(jsonObject.getJSONObject(key)));
                        continue;
                    }
                    this.properties.put((Object)key, (Object)new MutableActivityObjectImpl(jsonObject.getJSONObject(key)));
                    continue;
                }
                this.properties.put((Object)key, value);
            }
            catch (JSONException e) {
                log.error("Error while getting data from JSON object", (Throwable)e);
            }
        }
    }

    protected MutableActivityImpl(Activity src, Resource resource) {
        this.setActor(Util.copy(src.getActor()));
        this.setActorUserId(src.getActorUserId());
        this.setContent(src.getContent());
        this.setIcon(Util.copy(src.getIcon()));
        this.setId(src.getId());
        this.setObject(Util.copy(src.getObject()));
        this.setProvider(Util.copy(src.getProvider()));
        this.setGenerator(Util.copy(src.getGenerator()));
        this.setPublished(src.getPublished());
        this.setTarget(Util.copy(src.getTarget()));
        this.setUpdated(src.getUpdated());
        this.setTitle(src.getTitle());
        this.setURL(src.getURL());
        this.setVerb(src.getVerb());
        this.copyCustomProperties(src.getProperties(), resource, JcrActivity.RESERVED_ACTIVITY_PROPERTIES);
    }

    public String getId() {
        return (String)this.properties.get("id", String.class);
    }

    public String getPath() {
        return null;
    }

    public MutableActivity setId(String id) {
        this.properties.put((Object)"id", (Object)id);
        return this;
    }

    public String getURL() {
        return (String)this.properties.get("url", String.class);
    }

    public MutableActivity setURL(String url) {
        this.properties.put((Object)"url", (Object)url);
        return this;
    }

    public String getVerb() {
        return (String)this.properties.get("verb", (Object)"post");
    }

    public MutableActivity setVerb(String verb) {
        this.properties.put((Object)"verb", (Object)verb);
        return this;
    }

    public String getTitle() {
        return (String)this.properties.get("title", String.class);
    }

    public MutableActivity setTitle(String title) {
        this.properties.put((Object)"title", (Object)title);
        return this;
    }

    public ActivityObject getActor() {
        return (ActivityObject)this.properties.get((Object)"actor");
    }

    public MutableActivity setActor(ActivityObject actor) {
        this.properties.put((Object)"actor", (Object)actor);
        return this;
    }

    public String getActorUserId() {
        return (String)this.properties.get("actorId", String.class);
    }

    public MutableActivity setActorUserId(String userId) {
        this.properties.put((Object)"actorId", (Object)userId);
        return this;
    }

    public String getContent() {
        return (String)this.properties.get("content", String.class);
    }

    public MutableActivity setContent(String content) {
        this.properties.put((Object)"content", (Object)content);
        return this;
    }

    public ActivityObject getTarget() {
        return (ActivityObject)this.properties.get((Object)"target");
    }

    public MutableActivity setTarget(ActivityObject target) {
        this.properties.put((Object)"target", (Object)target);
        return this;
    }

    public ActivityObject getObject() {
        return (ActivityObject)this.properties.get((Object)"object");
    }

    public MutableActivity setObject(ActivityObject object) {
        this.properties.put((Object)"object", (Object)object);
        return this;
    }

    public long getPublished() {
        return (Long)this.properties.get("published", (Object)0L);
    }

    public MutableActivity setPublished(long published) {
        this.properties.put((Object)"published", (Object)published);
        return this;
    }

    public ActivityObject getProvider() {
        return (ActivityObject)this.properties.get((Object)"provider");
    }

    public MutableActivity setProvider(ActivityObject provider) {
        this.properties.put((Object)"provider", (Object)provider);
        return this;
    }

    public ActivityObject getGenerator() {
        return (ActivityObject)this.properties.get((Object)"generator");
    }

    public MutableActivity setGenerator(ActivityObject generator) {
        this.properties.put((Object)"generator", (Object)generator);
        return this;
    }

    public long getUpdated() {
        return (Long)this.properties.get("updated", (Object)0L);
    }

    public MutableActivity setUpdated(long updated) {
        this.properties.put((Object)"updated", (Object)updated);
        return this;
    }

    public MediaLink getIcon() {
        return (MediaLink)this.properties.get((Object)"icon");
    }

    public MutableActivity setIcon(MediaLink icon) {
        this.properties.put((Object)"icon", (Object)icon);
        return this;
    }

    public MutableActivity getMutableActivity() {
        return this;
    }

    public MutableActivity setProperty(String name, Object value) {
        this.properties.put((Object)name, value);
        return this;
    }

    public ActivityStream getStream() {
        return null;
    }
}

