/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.activitystreams.impl;

import com.adobe.granite.activitystreams.ActivityObject;
import com.adobe.granite.activitystreams.JsonAdaptable;
import com.adobe.granite.activitystreams.MediaLink;
import com.adobe.granite.activitystreams.impl.JcrActivityObject;
import com.adobe.granite.activitystreams.impl.JcrMediaLink;
import com.adobe.granite.activitystreams.utils.Util;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.jackrabbit.util.ISO8601;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MutableBase
implements JsonAdaptable {
    private static final Logger log = LoggerFactory.getLogger(MutableBase.class);
    protected final ValueMap properties = new ValueMapDecorator(new HashMap());
    private static final Set<String> DATE_PROPERTIES = new HashSet<String>(Arrays.asList("updated", "published"));

    public ValueMap getProperties() {
        return this.properties;
    }

    protected void copyCustomProperties(ValueMap srcProps, Resource resource, Set<String> reserved) {
        for (Map.Entry e : srcProps.entrySet()) {
            String key = (String)e.getKey();
            if (reserved.contains(key)) continue;
            Object value = e.getValue();
            if (value instanceof ActivityObject) {
                this.properties.put((Object)key, (Object)Util.copy((ActivityObject)value));
                continue;
            }
            if (value instanceof MediaLink) {
                this.properties.put((Object)key, (Object)Util.copy((MediaLink)value));
                continue;
            }
            if (value instanceof String) {
                this.properties.put((Object)key, value);
                continue;
            }
            log.info("***** unknown type: {}", value.getClass());
            this.properties.put((Object)key, srcProps.get(key, (Object)""));
        }
        if (resource != null) {
            Iterator iter = resource.listChildren();
            while (iter.hasNext()) {
                Resource child = (Resource)iter.next();
                String name = child.getName();
                if ("icon".equals(name) || "image".equals(name)) {
                    this.properties.put((Object)name, (Object)new JcrMediaLink(child).getMutableMediaLink());
                    continue;
                }
                this.properties.put((Object)name, (Object)new JcrActivityObject(child).getMutableActivityObject());
            }
        }
    }

    @Override
    public JSONObject toJSON() {
        JSONObject obj = new JSONObject();
        for (String name : this.properties.keySet()) {
            Object value = this.properties.get((Object)name);
            try {
                if (value instanceof JsonAdaptable) {
                    obj.put(name, (Object)((JsonAdaptable)value).toJSON());
                    continue;
                }
                if (value instanceof Calendar) {
                    obj.put(name, (Object)ISO8601.format((Calendar)((Calendar)value)));
                    continue;
                }
                if (value instanceof Long && DATE_PROPERTIES.contains(name)) {
                    long v = (Long)value;
                    if (v <= 0L) continue;
                    Calendar c = Calendar.getInstance();
                    c.setTimeInMillis(v);
                    obj.put(name, (Object)ISO8601.format((Calendar)c));
                    continue;
                }
                obj.put(name, value);
            }
            catch (JSONException e) {
                log.warn("unable to convert to json. value={}", value, (Object)e);
            }
        }
        return obj;
    }

    protected static String assertValidKey(String key) {
        if (key == null || key.length() == 0 || key.indexOf(47) >= 0) {
            throw new IllegalArgumentException("Path like keys not allowed: " + key);
        }
        return key;
    }
}

