/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.activitystreams.impl.rest;

import com.adobe.granite.activitystreams.Activity;
import com.adobe.granite.activitystreams.ActivityManager;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.ServletException;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingServlet(resourceTypes={"granite/activitystreams/components/activity"}, methods={"GET"})
public class ActivityServlet
extends SlingAllMethodsServlet {
    private static final long serialVersionUID = -4571680968447024900L;
    protected final Logger log = LoggerFactory.getLogger(ActivityServlet.class);
    @Reference
    protected ActivityManager activityMgr;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        try {
            Activity a = this.activityMgr.getActivity(request.getResourceResolver(), request.getResource().getPath());
            if (a == null) {
                response.setStatus(404);
                response.flushBuffer();
                return;
            }
            long lastModified = a.getUpdated();
            if (lastModified == 0L) {
                lastModified = a.getPublished();
            }
            response.setContentType("application/json");
            response.setCharacterEncoding("utf8");
            response.setDateHeader("Last-Modified", lastModified);
            response.setStatus(200);
            a.toJSON().write((Writer)response.getWriter());
        }
        catch (Exception e) {
            this.log.error("Error while reading the activity", (Throwable)e);
            response.setStatus(500);
        }
    }

    protected void bindActivityMgr(ActivityManager activityManager) {
        this.activityMgr = activityManager;
    }

    protected void unbindActivityMgr(ActivityManager activityManager) {
        if (this.activityMgr == activityManager) {
            this.activityMgr = null;
        }
    }
}

