/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.auth.oauth.impl;

import com.adobe.granite.auth.oauth.HandlerRedirect;
import com.adobe.granite.auth.oauth.OAuthManager;
import com.adobe.granite.auth.oauth.Provider;
import com.adobe.granite.auth.oauth.impl.helper.OAuthHelper;
import com.adobe.granite.auth.oauth.impl.helper.OAuthUser;
import com.adobe.granite.auth.oauth.impl.helper.ProviderConfigManager;
import com.adobe.granite.auth.oauth.impl.helper.RequestHelper;
import com.adobe.granite.crypto.CryptoSupport;
import com.adobe.granite.security.user.UserProperties;
import com.adobe.granite.security.user.UserPropertiesManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.Session;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.io.IOUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyUnbounded;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.auth.core.spi.AuthenticationHandler;
import org.apache.sling.auth.core.spi.AuthenticationInfo;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.settings.SlingSettingsService;
import org.osgi.framework.BundleContext;
import org.scribe.model.Token;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(metatype=true, policy=ConfigurationPolicy.REQUIRE, label="%auth.bearer.name", description="%auth.bearer.description")
@Service
@Properties(value={@Property(name="service.ranking", intValue={100000}), @Property(name="path", value={"/"}), @Property(name="oauth.clientIds.allowed", unbounded=PropertyUnbounded.ARRAY)})
public class BearerAuthenticationHandler
implements AuthenticationHandler {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    protected static final String ALLOWED_CLIENT_IDS = "oauth.clientIds.allowed";
    private static final String TOKEN_REQUEST_PARAMETER_NAME = "auth.tokenRequestParameter";
    private static final String REDIRECT_KEY = "redirect";
    private static final boolean DEFAULT_SYNC_USER_PROFILE_WITH_IMS = true;
    @Property(boolValue={true})
    private static final String SYNC_USER_PROFILE_WITH_IMS = "auth.bearer.sync.ims";
    private static final String ACCESS_TOKEN_TYPE = "access_token";
    @Property(name="auth.tokenRequestParameter")
    private static final String TOKEN_REQUEST_PARAMETER_DEFAULT = "";
    @Property(value={"configid"})
    protected static final String CONFIGID_PARAMETER_NAME = "oauth.bearer.configid";
    @Reference
    private SlingRepository repository;
    @Reference
    private SlingSettingsService settings;
    @Reference
    private ProviderConfigManager providerConfigManager;
    @Reference
    private OAuthManager oauthManager;
    @Reference
    private ResourceResolverFactory resolverFactory;
    @Reference
    private CryptoSupport cryptoSupport;
    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL_UNARY)
    private HandlerRedirect handlerRedirect;
    private String repositoryId;
    private String requestParameterName;
    private String[] allowedClientIds;
    private MultiThreadedHttpConnectionManager connectionManager;
    private HttpClient httpClient;
    private boolean syncWithIms;
    private String configIdParameterName;

    /*
     * Exception decompiling
     */
    public AuthenticationInfo extractCredentials(HttpServletRequest request, HttpServletResponse response) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK], 12[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String validateTokenAndGetUserId(HttpServletRequest request, String accessToken, OAuthHelper oauthHelper, Provider provider) {
        if (provider != null && oauthHelper != null) {
            for (String clientId : this.allowedClientIds) {
                String validateTokenUrl = provider.getValidateTokenUrl(clientId, accessToken);
                this.log.debug("createCredentials: obtained validate token url {}", (Object)validateTokenUrl);
                if (validateTokenUrl != null && !TOKEN_REQUEST_PARAMETER_DEFAULT.equals(validateTokenUrl)) {
                    String userId = this.validateTokenAndGetUserId(provider, validateTokenUrl, clientId);
                    if (userId != null) {
                        return userId;
                    }
                    this.log.debug("createCredentials: invalid token, no valid user found");
                    continue;
                }
                this.log.error("createCredentials: validate token url for provider {} is null", (Object)provider);
            }
        } else {
            this.log.error("createCredentials: invalid config: helper is {} provider is {} ", (Object)oauthHelper, (Object)provider);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String validateTokenAndGetUserId(Provider provider, String validateTokenUrl, String clientId) {
        InputStream is;
        GetMethod get;
        String userId;
        block9: {
            userId = null;
            get = new GetMethod(validateTokenUrl);
            is = null;
            try {
                int responseStatus = this.httpClient.executeMethod((HttpMethod)get);
                is = get.getResponseBodyAsStream();
                String responseBody = IOUtils.toString((InputStream)is);
                if (responseStatus == 200) {
                    boolean validToken = provider.isValidToken(responseBody, clientId, ACCESS_TOKEN_TYPE);
                    if (validToken) {
                        userId = provider.getUserIdFromValidateTokenResponseBody(responseBody);
                    } else {
                        this.log.debug("validateTokenAndGetUserId: the provided token is invalid");
                    }
                    break block9;
                }
                this.log.debug("validateTokenAndGetUserId: bad request to validation url, failed with error {}", (Object)provider.getErrorDescriptionFromValidateTokenResponseBody(responseBody));
            }
            catch (HttpException e) {
                this.log.error("validateTokenAndGetUserId: Failed to connect to validate token url", (Throwable)e);
                get.releaseConnection();
                IOUtils.closeQuietly((InputStream)is);
            }
            catch (IOException e2) {
                this.log.error("validateTokenAndGetUserId: Failed to connect to validate token url", (Throwable)e2);
                {
                    catch (Throwable throwable) {
                        get.releaseConnection();
                        IOUtils.closeQuietly(is);
                        throw throwable;
                    }
                }
                get.releaseConnection();
                IOUtils.closeQuietly((InputStream)is);
            }
        }
        get.releaseConnection();
        IOUtils.closeQuietly((InputStream)is);
        return userId;
    }

    public boolean requestCredentials(HttpServletRequest request, HttpServletResponse response) throws IOException {
        return false;
    }

    public void dropCredentials(HttpServletRequest request, HttpServletResponse response) {
    }

    @Activate
    private void activate(BundleContext context, Map<String, Object> config) {
        this.repositoryId = RequestHelper.getRepositoryId(this.repository, this.settings);
        this.log.info("activate: Supporting tokens bound to Repository (Cluster) {}", (Object)this.repositoryId);
        this.requestParameterName = OsgiUtil.toString((Object)config.get(TOKEN_REQUEST_PARAMETER_NAME), (String)TOKEN_REQUEST_PARAMETER_DEFAULT);
        this.allowedClientIds = OsgiUtil.toStringArray((Object)config.get(ALLOWED_CLIENT_IDS), (String[])new String[0]);
        this.syncWithIms = OsgiUtil.toBoolean((Object)config.get(SYNC_USER_PROFILE_WITH_IMS), (boolean)true);
        this.configIdParameterName = OsgiUtil.toString((Object)config.get(CONFIGID_PARAMETER_NAME), (String)"configid");
        this.connectionManager = new MultiThreadedHttpConnectionManager();
        this.httpClient = new HttpClient((HttpConnectionManager)this.connectionManager);
    }

    @Deactivate
    private void deactivate() {
    }

    private String getBearerAccessToken(HttpServletRequest request) {
        String token;
        String auth = request.getHeader("Authorization");
        if (auth != null) {
            if (auth.trim().startsWith("Bearer")) {
                String[] parts = auth.split("\\s");
                if (parts.length == 2 && "Bearer".equals(parts[0])) {
                    this.log.debug("getAccessToken: Found access token");
                    return parts[1];
                }
                this.log.debug("getAccessToken: Wrong Authorization header format; ignoring");
            } else {
                this.log.debug("getAccessToken: Authorization scheme is not bearer; ignoring");
            }
        }
        if (!"POST".equals(request.getMethod())) {
            this.log.debug("getAccessToken: the request parameter is limited to POST operation; ignoring");
            return null;
        }
        String string = token = this.requestParameterName.length() > 0 ? request.getParameter(this.requestParameterName) : null;
        if (token != null) {
            this.log.debug("getAccessToken: Found access token");
            return token;
        }
        this.log.debug("getAccessToken: No Authorization header in the request and no request parameter specified; ignoring");
        return null;
    }

    private void setupAuthenticationFailure(HttpServletRequest request, HttpServletResponse response) {
        this.dropCredentials(request, response);
        request.setAttribute("j_reason", (Object)"Authentication Failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OAuthUser getUserDetails(Session adminSession, OAuthHelper oauthHelper, Provider provider, String oauthUserId) {
        User user = null;
        ResourceResolver adminResolver = null;
        OAuthUser oauthUser = null;
        try {
            HashMap<String, Object> props;
            UserManager um = ((JackrabbitSession)adminSession).getUserManager();
            adminResolver = this.resolverFactory.getAdministrativeResourceResolver(null);
            UserPropertiesManager upm = (UserPropertiesManager)adminResolver.adaptTo(UserPropertiesManager.class);
            if (oauthHelper.getProviderConfig().getForceStrictUsernameMatching()) {
                props = new HashMap<String, Object>();
                Iterator<Authorizable> auths = oauthHelper.getCRXUsersByOAuthId(um, provider, new OAuthUser(oauthUserId, Collections.<String, Object>emptyMap()));
                while (auths.hasNext() && user == null) {
                    Authorizable auth = auths.next();
                    if (auth.isGroup()) continue;
                    user = (User)auth;
                    UserProperties properties = upm.getUserProperties(user.getID(), "profile");
                    for (String property : properties.getPropertyNames()) {
                        String value = properties.getProperty(property);
                        if (value == null) continue;
                        props.put("profile/" + property, value);
                    }
                }
                user = oauthHelper.getCRXUserByMappedId(um, provider, new OAuthUser(oauthUserId, props));
            } else {
                user = oauthHelper.getCRXUserByOAuthId(um, provider, new OAuthUser(oauthUserId, Collections.<String, Object>emptyMap()));
            }
            if (user != null) {
                props = new HashMap();
                UserProperties properties = upm.getUserProperties(user.getID(), "profile");
                for (String property : properties.getPropertyNames()) {
                    String value = properties.getProperty(property);
                    if (value == null) continue;
                    props.put("profile/" + property, value);
                }
                oauthUser = new OAuthUser(oauthUserId, props);
            }
        }
        catch (Exception e) {
            this.log.error("Failed to fetch the user properties from the crx user: {}", (Object)oauthUserId, (Object)e);
        }
        finally {
            if (adminResolver != null && adminResolver.isLive()) {
                adminResolver.close();
            }
        }
        return oauthUser;
    }

    private OAuthUser getUserDetails(Provider provider, OAuthHelper oauthHelper, Token accessToken) throws IOException {
        String[] dynamicExtendedDetailsURLs;
        OAuthUser oauthUser = oauthHelper.fetchAndMapBasicData(provider, provider.getDetailsURL(), accessToken);
        String scope = oauthHelper.getProviderConfig().getScope();
        String[] extendedDetailsURLs = provider.getExtendedDetailsURLs(scope);
        if (extendedDetailsURLs != null) {
            for (String extendedDetailsURL : extendedDetailsURLs) {
                oauthUser = oauthHelper.fetchAndMapExtendedData(provider, extendedDetailsURL, accessToken, oauthUser);
            }
        }
        if ((dynamicExtendedDetailsURLs = provider.getExtendedDetailsURLs(scope, oauthUser.getId(), oauthUser.getProperties())) != null) {
            for (String dynamicExtendedDetailsUrl : dynamicExtendedDetailsURLs) {
                oauthUser = oauthHelper.fetchAndMapExtendedData(provider, dynamicExtendedDetailsUrl, accessToken, oauthUser);
            }
        }
        return oauthUser;
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected void bindSettings(SlingSettingsService slingSettingsService) {
        this.settings = slingSettingsService;
    }

    protected void unbindSettings(SlingSettingsService slingSettingsService) {
        if (this.settings == slingSettingsService) {
            this.settings = null;
        }
    }

    protected void bindProviderConfigManager(ProviderConfigManager providerConfigManager) {
        this.providerConfigManager = providerConfigManager;
    }

    protected void unbindProviderConfigManager(ProviderConfigManager providerConfigManager) {
        if (this.providerConfigManager == providerConfigManager) {
            this.providerConfigManager = null;
        }
    }

    protected void bindOauthManager(OAuthManager oAuthManager) {
        this.oauthManager = oAuthManager;
    }

    protected void unbindOauthManager(OAuthManager oAuthManager) {
        if (this.oauthManager == oAuthManager) {
            this.oauthManager = null;
        }
    }

    protected void bindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resolverFactory = resourceResolverFactory;
    }

    protected void unbindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resolverFactory == resourceResolverFactory) {
            this.resolverFactory = null;
        }
    }

    protected void bindCryptoSupport(CryptoSupport cryptoSupport) {
        this.cryptoSupport = cryptoSupport;
    }

    protected void unbindCryptoSupport(CryptoSupport cryptoSupport) {
        if (this.cryptoSupport == cryptoSupport) {
            this.cryptoSupport = null;
        }
    }

    protected void bindHandlerRedirect(HandlerRedirect handlerRedirect) {
        this.handlerRedirect = handlerRedirect;
    }

    protected void unbindHandlerRedirect(HandlerRedirect handlerRedirect) {
        if (this.handlerRedirect == handlerRedirect) {
            this.handlerRedirect = null;
        }
    }
}

