/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.auth.oauth.impl;

import com.adobe.granite.auth.oauth.ProviderType;
import com.adobe.granite.auth.oauth.impl.ProviderBase;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.scribe.builder.api.Api;
import org.scribe.builder.api.FacebookApi;

@Component(metatype=true, label="%auth.oauth.provider.facebook.name", description="%auth.oauth.provider.facebook.description", inherit=true)
@Properties(value={@Property(name="oauth.provider.id", value={"facebook"})})
public class FacebookProviderImpl
extends ProviderBase {
    public FacebookProviderImpl() {
        super(ProviderType.OAUTH2, (Api)new FacebookApi(), "https://graph.facebook.com/me");
    }

    public String mapProperty(String property) {
        if ("first_name".equals(property)) {
            return "profile/givenName";
        }
        if ("last_name".equals(property)) {
            return "profile/familyName";
        }
        if ("locale".equals(property)) {
            return "preferences/language";
        }
        return super.mapProperty(property);
    }

    public Object mapValue(String key, String value) {
        if ("profile/avatar".equals(key)) {
            return "http://graph.facebook.com/" + value + "/picture";
        }
        return super.mapValue(key, value);
    }
}

