/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.auth.oauth.impl;

import com.adobe.granite.auth.oauth.OAuthManager;
import com.adobe.granite.auth.oauth.Provider;
import com.adobe.granite.auth.oauth.impl.helper.OAuthHelper;
import com.adobe.granite.auth.oauth.impl.helper.OAuthUser;
import com.adobe.granite.auth.oauth.impl.helper.ProviderConfigManager;
import com.adobe.granite.auth.oauth.impl.helper.RequestHelper;
import com.adobe.granite.crypto.CryptoSupport;
import com.day.crx.security.token.TokenUtil;
import java.io.IOException;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.auth.core.spi.AbstractAuthenticationHandler;
import org.apache.sling.auth.core.spi.AuthenticationHandler;
import org.apache.sling.auth.core.spi.AuthenticationInfo;
import org.apache.sling.auth.core.spi.DefaultAuthenticationFeedbackHandler;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.settings.SlingSettingsService;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(metatype=true, policy=ConfigurationPolicy.REQUIRE)
@Service(value={AuthenticationHandler.class})
@Properties(value={@Property(name="path", value={"/"}), @Property(name="service.ranking", intValue={5000})})
public class OAuthAuthenticationHandler
extends AbstractAuthenticationHandler {
    private static final String AUTH_TYPE = "OAUTH";
    @Property(name="service.description")
    private static final String DESCRIPTION = "OAuth Authentication Handler";
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Reference
    private SlingRepository repository;
    @Reference
    private CryptoSupport cryptoSupport;
    @Reference
    private OAuthManager oauthManager;
    @Reference
    private SlingSettingsService settings;
    private String repositoryId;
    @Reference
    private ProviderConfigManager providerConfigManager;

    @Activate
    private void activate(BundleContext context, Map<String, Object> config) {
        this.repositoryId = RequestHelper.getRepositoryId(this.repository, this.settings);
        this.log.info("activate: Supporting tokens bound to Repository (Cluster) {}", (Object)this.repositoryId);
    }

    @Deactivate
    private void deactivate() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AuthenticationInfo extractCredentials(HttpServletRequest request, HttpServletResponse response) {
        block18: {
            OAuthHelper helper;
            String userId;
            OAuthHelper authHelper;
            String authConfigId = RequestHelper.getAuthenticatedConfigId(request);
            OAuthHelper oAuthHelper = authHelper = authConfigId == null ? null : this.providerConfigManager.getHelper(authConfigId);
            if (authHelper != null && !RequestHelper.isInitialCall(request, true) && (userId = authHelper.getAuthorizedId(request)) != null) {
                return this.createAuthenticationInfo(request, response, userId);
            }
            String configId = RequestHelper.getConfigId(request);
            OAuthHelper oAuthHelper2 = helper = configId == null ? null : this.providerConfigManager.getHelper(configId);
            if (RequestHelper.isInitialCall(request, true)) {
                configId = request.getParameter("configid");
                helper = this.providerConfigManager.getHelper(configId);
                Provider provider = this.oauthManager.getProvider(configId);
                String redirect = OAuthAuthenticationHandler.getLoginResource((HttpServletRequest)request, (String)"");
                if (helper != null && provider != null) {
                    try {
                        helper.requestAuthorization(request, response, provider, redirect, true);
                        return AuthenticationInfo.DOING_AUTH;
                    }
                    catch (IOException ioe) {
                        this.log.error("extractCredentials: Failure requesting authorization for configId " + configId, (Throwable)ioe);
                    }
                } else {
                    this.log.error("extractCredentials: invalid config: helper is {} provider is {} ", (Object)helper, (Object)provider);
                }
                this.setupAuthenticationFailure(request, response);
                return AuthenticationInfo.FAIL_AUTH;
            }
            if (!RequestHelper.isAuthzCode(request, true)) return null;
            Provider provider = this.oauthManager.getProvider(configId);
            if (helper == null || provider == null) {
                this.log.error("extractCredentials: Cannot process OAuth continuation; application seems unconfigured");
            } else {
                try {
                    OAuthUser oauthUser = helper.requestAccessCode(provider, request, response, true, true);
                    if (oauthUser == null) {
                        this.log.error("extractCredentials: Failed to retrieve user identification; cannot authenticate");
                        break block18;
                    }
                    Session s = null;
                    try {
                        s = this.repository.loginAdministrative(null);
                        User user = helper.createOrUpdateCRXUser(s, this.cryptoSupport, provider, request, oauthUser);
                        if (user != null) {
                            AuthenticationInfo authenticationInfo = this.createAuthenticationInfo(request, response, user.getID());
                            return authenticationInfo;
                        }
                        this.log.error("extractCredentials: Failed finding user for oauthUser={} of application {}", (Object)oauthUser, (Object)helper.getClientId());
                    }
                    finally {
                        if (s != null && s.isLive()) {
                            s.logout();
                        }
                    }
                }
                catch (RepositoryException re) {
                    this.log.error("extractCredentials: Failed to persist user or properties", (Throwable)re);
                }
                catch (IOException ioe) {
                    this.log.error("extractCredentials: Failed to retrieve user identification; cannot authenticate", (Throwable)ioe);
                }
            }
        }
        this.setupAuthenticationFailure(request, response);
        return AuthenticationInfo.FAIL_AUTH;
    }

    public boolean requestCredentials(HttpServletRequest request, HttpServletResponse response) {
        return false;
    }

    public void dropCredentials(HttpServletRequest request, HttpServletResponse response) {
        this.setAuthorizedId(request, response, null);
        RequestHelper.removeConfigId(request, response);
        RequestHelper.removeAuthenticatedConfigId(request, response);
    }

    public boolean authenticationSucceeded(HttpServletRequest request, HttpServletResponse response, AuthenticationInfo authInfo) {
        boolean result;
        if (!RequestHelper.isAuthzCode(request, true)) {
            return false;
        }
        ResourceResolver resolver = (ResourceResolver)request.getAttribute("org.apache.sling.auth.core.ResourceResolver");
        if (resolver != null) {
            this.setAuthorizedId(request, response, resolver.getUserID());
        } else {
            this.log.warn("authenticationSucceeded: ResourceResolver missing from request, cannot cache user id");
        }
        if (DefaultAuthenticationFeedbackHandler.handleRedirect((HttpServletRequest)request, (HttpServletResponse)response)) {
            result = false;
        } else {
            RequestHelper.handleRedirectAfterAuthentication(request, response);
            result = true;
        }
        return result;
    }

    public void authenticationFailed(HttpServletRequest request, HttpServletResponse response, AuthenticationInfo authInfo) {
        this.dropCredentials(request, response);
    }

    public String toString() {
        return DESCRIPTION;
    }

    private void setupAuthenticationFailure(HttpServletRequest request, HttpServletResponse response) {
        OAuthAuthenticationHandler.setLoginResourceAttribute((HttpServletRequest)request, null);
        this.dropCredentials(request, response);
        request.setAttribute("j_reason", (Object)"Authentication Failed");
    }

    private AuthenticationInfo createAuthenticationInfo(HttpServletRequest request, HttpServletResponse response, String userId) {
        try {
            return TokenUtil.createCredentials((HttpServletRequest)request, (HttpServletResponse)response, (SlingRepository)this.repository, (String)userId, (boolean)true);
        }
        catch (RepositoryException e) {
            this.log.error("Unable to create token credentials", (Throwable)e);
            return new AuthenticationInfo(AUTH_TYPE, userId);
        }
    }

    private void setAuthorizedId(HttpServletRequest request, HttpServletResponse response, String userId) {
        OAuthHelper helper;
        String configId = RequestHelper.getConfigId(request);
        OAuthHelper oAuthHelper = helper = configId == null ? null : this.providerConfigManager.getHelper(configId);
        if (helper != null) {
            helper.setAuthorizedId(request, response, userId);
            RequestHelper.storeAuthenticatedConfigId(configId, helper.getProviderConfig().getCookieMaxAge(), request, response);
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected void bindCryptoSupport(CryptoSupport cryptoSupport) {
        this.cryptoSupport = cryptoSupport;
    }

    protected void unbindCryptoSupport(CryptoSupport cryptoSupport) {
        if (this.cryptoSupport == cryptoSupport) {
            this.cryptoSupport = null;
        }
    }

    protected void bindOauthManager(OAuthManager oAuthManager) {
        this.oauthManager = oAuthManager;
    }

    protected void unbindOauthManager(OAuthManager oAuthManager) {
        if (this.oauthManager == oAuthManager) {
            this.oauthManager = null;
        }
    }

    protected void bindSettings(SlingSettingsService slingSettingsService) {
        this.settings = slingSettingsService;
    }

    protected void unbindSettings(SlingSettingsService slingSettingsService) {
        if (this.settings == slingSettingsService) {
            this.settings = null;
        }
    }

    protected void bindProviderConfigManager(ProviderConfigManager providerConfigManager) {
        this.providerConfigManager = providerConfigManager;
    }

    protected void unbindProviderConfigManager(ProviderConfigManager providerConfigManager) {
        if (this.providerConfigManager == providerConfigManager) {
            this.providerConfigManager = null;
        }
    }
}

