/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.auth.oauth.impl;

import com.adobe.granite.auth.oauth.OAuthManager;
import com.adobe.granite.auth.oauth.Provider;
import com.adobe.granite.auth.oauth.impl.helper.OAuthHelper;
import com.adobe.granite.auth.oauth.impl.helper.ProviderConfigManager;
import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.osgi.framework.BundleContext;
import org.scribe.model.OAuthRequest;
import org.scribe.model.Response;
import org.scribe.model.Verb;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(metatype=true, label="Adobe Granite OAuthManager Service", description="Service used to manage OAuth interactions.", name="com.adobe.granite.auth.oauth.OAuthManager")
@Service(value={OAuthManager.class})
@Property(name="service.description", value={"Service used to manage OAuth interactions."})
public class OAuthManagerImpl
implements OAuthManager {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference
    private ProviderConfigManager providerConfigManager;

    @Activate
    private void activate(BundleContext context, Map<String, Object> config) {
        this.log.info("activating OAuthManagerImpl");
    }

    @Deactivate
    private void deactivate() {
        this.log.debug("deactivating OAuthManagerImpl");
    }

    public OAuthManagerImpl() {
        this.log.info("creating OAuthManagerImpl");
    }

    @Override
    public Response getOAuthDataWithSharedToken(Resource encryptedTokenResource, String configId, OAuthRequest oauthRequest) throws IOException {
        this.log.debug("getOAuthDataWithSharedToken: fetching data from url:{}", (Object)oauthRequest.getUrl());
        OAuthHelper helper = this.providerConfigManager.getHelper(configId);
        Provider provider = this.getProvider(configId);
        return helper.getProtectedData(encryptedTokenResource, provider, oauthRequest);
    }

    @Override
    public String getOAuthDataWithSharedToken(Resource encryptedTokenResource, String configId, String url) throws IOException {
        Response response = this.getOAuthDataWithSharedToken(encryptedTokenResource, configId, new OAuthRequest(Verb.GET, url));
        return response.getBody();
    }

    @Override
    public Response getOAuthDataWithUserToken(SlingHttpServletRequest request, String configId, OAuthRequest oauthRequest) throws IOException {
        this.log.debug("getOAuthDataWithUserToken: fetching data from url:{}", (Object)oauthRequest.getUrl());
        OAuthHelper helper = this.providerConfigManager.getHelper(configId);
        Provider provider = this.getProvider(configId);
        User user = provider.getCurrentUser(request);
        return helper.getProtectedData(user, provider, oauthRequest);
    }

    @Override
    public String getOAuthDataWithUserToken(SlingHttpServletRequest request, String configId, String url) throws IOException {
        Response response = this.getOAuthDataWithUserToken(request, configId, new OAuthRequest(Verb.GET, url));
        return response.getBody();
    }

    @Override
    public Provider getProvider(String configId) {
        return this.providerConfigManager.getProvider(configId);
    }

    @Override
    public String getAuthorizedId(HttpServletRequest request, String configId) {
        OAuthHelper helper = this.providerConfigManager.getHelper(configId);
        return helper.getAuthorizedId(request);
    }

    protected void bindProviderConfigManager(ProviderConfigManager providerConfigManager) {
        this.providerConfigManager = providerConfigManager;
    }

    protected void unbindProviderConfigManager(ProviderConfigManager providerConfigManager) {
        if (this.providerConfigManager == providerConfigManager) {
            this.providerConfigManager = null;
        }
    }
}

