/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.auth.oauth.impl;

import com.adobe.granite.auth.oauth.Provider;
import com.adobe.granite.auth.oauth.ProviderExtension;
import com.adobe.granite.auth.oauth.ProviderType;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.commons.osgi.ServiceUtil;
import org.osgi.service.component.ComponentContext;
import org.scribe.builder.api.Api;
import org.scribe.model.OAuthRequest;
import org.scribe.model.Response;
import org.scribe.model.Verb;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value={Provider.class})
@Reference(name="providerExtension", referenceInterface=ProviderExtension.class, bind="bindProviderExtension", unbind="unbindProviderExtension", cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC)
public abstract class ProviderBase
implements Provider {
    @Property
    protected static final String PROP_OAUTH_PROVIDER_ID = "oauth.provider.id";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private String name;
    private String id;
    private ProviderType type;
    private Api api;
    private String detailsURL;
    private String[] extendedDetailsURLs;
    private static final String[] DEFAULT_EXTENDED_URLS = new String[0];
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private SortedMap<Comparable<Object>, ProviderExtension> registeredProviderExtensionHandlers = new TreeMap(Collections.reverseOrder());

    protected ProviderBase(ProviderType type, Api api, String detailsURL) {
        this.type = type;
        this.api = api;
        this.detailsURL = detailsURL;
    }

    @Override
    public ProviderType getType() {
        return this.type;
    }

    @Override
    public Api getApi() {
        return this.api;
    }

    @Override
    public String getDetailsURL() {
        return this.detailsURL;
    }

    @Override
    public String[] getExtendedDetailsURLs(String scope) {
        return this.extendedDetailsURLs;
    }

    @Override
    public String[] getExtendedDetailsURLs(String scope, String userId, Map<String, Object> props) {
        return DEFAULT_EXTENDED_URLS;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String mapProperty(String property) {
        return "profile/" + property;
    }

    public Object mapValue(String key, String value) {
        return value;
    }

    @Override
    public String mapUserId(String userId, Map<String, Object> props) {
        ProviderExtension providerExtension = this.getProviderExtension();
        if (providerExtension != null) {
            String delegatedUserId = providerExtension.mapUserId(userId, props);
            return delegatedUserId != null ? delegatedUserId : this.getDefaultUserId(userId, props);
        }
        return this.getDefaultUserId(userId, props);
    }

    @Override
    public String getUserFolderPath(String userId, String clientId, Map<String, Object> props) {
        ProviderExtension providerExtension = this.getProviderExtension();
        if (providerExtension != null) {
            String userFolderPath = providerExtension.getUserFolderPath(userId, clientId, props);
            return userFolderPath != null ? userFolderPath : this.getDefaultUserFolderPath(userId, clientId, props);
        }
        return this.getDefaultUserFolderPath(userId, clientId, props);
    }

    @Override
    public Map<String, Object> mapProperties(String srcUrl, String clientId, Map<String, Object> existing, Map<String, String> newProperties) {
        HashMap<String, Object> mapped = new HashMap<String, Object>();
        mapped.putAll(existing);
        for (Map.Entry<String, String> prop : newProperties.entrySet()) {
            String mappedKey = this.mapProperty(prop.getKey());
            Object mappedValue = this.mapValue(mappedKey, prop.getValue());
            mapped.put(mappedKey, mappedValue);
        }
        if (!mapped.containsKey("profile/avatar")) {
            Object mappedValue = this.mapValue("profile/avatar", this.id);
            mapped.put("profile/avatar", mappedValue);
        }
        return mapped;
    }

    @Override
    public String getAccessTokenPropertyPath(String clientId) {
        return "profile/app-" + clientId;
    }

    @Override
    public User getCurrentUser(SlingHttpServletRequest request) {
        Authorizable authorizable = (Authorizable)request.adaptTo(Authorizable.class);
        if (authorizable != null && !authorizable.isGroup()) {
            return (User)authorizable;
        }
        return null;
    }

    @Override
    public void onUserCreate(User user) {
        ProviderExtension providerExtension = this.getProviderExtension();
        if (providerExtension != null) {
            providerExtension.onUserCreate(user);
        }
    }

    @Override
    public void onUserUpdate(User user) {
        ProviderExtension providerExtension = this.getProviderExtension();
        if (providerExtension != null) {
            providerExtension.onUserUpdate(user);
        }
    }

    @Override
    public OAuthRequest getProtectedDataRequest(String url) {
        return new OAuthRequest(Verb.GET, url);
    }

    @Override
    public Map<String, String> parseProfileDataResponse(Response response) throws IOException {
        String body = response.getBody();
        try {
            JSONObject json = new JSONObject(body);
            HashMap<String, String> newProps = new HashMap<String, String>();
            Iterator keys = json.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                newProps.put(key, json.optString(key));
            }
            return newProps;
        }
        catch (JSONException je) {
            this.log.debug("problem parsing JSON; response body was: {}", (Object)body);
            throw new IOException(je.toString());
        }
    }

    @Override
    public String getUserIdProperty() {
        return "id";
    }

    @Override
    public String getOAuthIdPropertyPath(String clientId) {
        return "oauth/oauthid-" + clientId;
    }

    @Activate
    protected void activate(ComponentContext componentContext) throws Exception {
        this.name = OsgiUtil.toString(componentContext.getProperties().get("service.description"), (String)"");
        this.id = OsgiUtil.toString(componentContext.getProperties().get(PROP_OAUTH_PROVIDER_ID), (String)"");
        this.log.debug("activating provider id {}", (Object)this.id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deactivate
    protected void deactivate(ComponentContext componentContext) throws Exception {
        this.log.debug("deactivating provider id {}", (Object)this.id);
        this.lock.writeLock().lock();
        try {
            this.registeredProviderExtensionHandlers.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public String getValidateTokenUrl(String clientId, String token) {
        this.log.info("This provider doesn't support the validation of a token");
        return null;
    }

    @Override
    public boolean isValidToken(String responseBody, String clientId, String tokenType) {
        this.log.info("This provider doesn't support the validation of a token");
        return false;
    }

    @Override
    public String getUserIdFromValidateTokenResponseBody(String responseBody) {
        this.log.info("This provider doesn't support the validation of a token");
        return null;
    }

    @Override
    public String getErrorDescriptionFromValidateTokenResponseBody(String responseBody) {
        this.log.info("This provider doesn't support the validation of a token");
        return null;
    }

    private String getDefaultUserId(String userId, Map<String, Object> props) {
        return this.getId() + "-" + userId;
    }

    private String getDefaultUserFolderPath(String userId, String clientId, Map<String, Object> props) {
        return this.getId() + "/" + userId.substring(0, 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bindProviderExtension(ProviderExtension providerExtension, Map<String, Object> properties) {
        this.lock.writeLock().lock();
        try {
            this.registeredProviderExtensionHandlers.put(ServiceUtil.getComparableForServiceRanking(properties), providerExtension);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindProviderExtension(ProviderExtension providerExtension, Map<String, Object> properties) {
        this.lock.writeLock().lock();
        try {
            this.registeredProviderExtensionHandlers.remove(ServiceUtil.getComparableForServiceRanking(properties));
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProviderExtension getProviderExtension() {
        this.lock.readLock().lock();
        try {
            for (ProviderExtension pe : this.registeredProviderExtensionHandlers.values()) {
                if (pe.getId() == null || !pe.getId().equals(this.getId())) continue;
                ProviderExtension providerExtension = pe;
                return providerExtension;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return null;
    }
}

