/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.auth.oauth.impl.helper;

import com.adobe.granite.auth.oauth.OAuthIdInUseException;
import com.adobe.granite.auth.oauth.Provider;
import com.adobe.granite.auth.oauth.impl.helper.OAuthToken;
import com.adobe.granite.auth.oauth.impl.helper.OAuthUser;
import com.adobe.granite.auth.oauth.impl.helper.ProviderConfig;
import com.adobe.granite.auth.oauth.impl.helper.RequestHelper;
import com.adobe.granite.crypto.CryptoException;
import com.adobe.granite.crypto.CryptoSupport;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.MessageDigest;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.AuthorizableExistsException;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.resource.Resource;
import org.scribe.model.OAuthRequest;
import org.scribe.model.Response;
import org.scribe.model.Token;
import org.scribe.oauth.OAuthService;
import org.scribe.utils.OAuthEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OAuthHelper {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String PARAM_STATE = "state";
    public static final String REDIRECT_SUFFIX_AUTHENTICATE = "/j_security_check";
    public static final String CALLBACK_SUFFIX_AUTHENTICATE = "/callback/j_security_check";
    private static final int MAX_COLLISION_TRIES = 1000;
    public static final String REDIRECT_SUFFIX_CONNECT = "/connect";
    public static final String CALLBACK_SUFFIX_CONNECT = "/callback/connect";
    protected static final String TOKEN_ATTR_USER = "user";
    protected final ProviderConfig config;
    protected final String callBackUrl;

    protected OAuthHelper(ProviderConfig config) {
        this.config = config;
        this.callBackUrl = config.getCallBackUrl();
    }

    public abstract void requestAuthorization(Provider var1, HttpServletRequest var2, HttpServletResponse var3, String var4, boolean var5) throws IOException;

    public abstract OAuthUser requestAccessCode(Provider var1, HttpServletRequest var2, HttpServletResponse var3, boolean var4, boolean var5) throws IOException;

    public String getClientId() {
        return this.config.getClientId();
    }

    private String getUserPropKey(Provider provider) {
        return provider.getOAuthIdPropertyPath(this.config.getClientId());
    }

    public ProviderConfig getProviderConfig() {
        return this.config;
    }

    public void requestAuthorization(HttpServletRequest request, HttpServletResponse response, Provider provider, String redirect, boolean isAuthentication) throws IOException {
        RequestHelper.storeConfigId(this.config.getConfigId(), this.config.getCookieMaxAge(), request, response);
        String state = OAuthEncoder.encode((String)(redirect == null ? "" : redirect));
        this.requestAuthorization(provider, request, response, state, isAuthentication);
    }

    private void assignUserProfileData(User user, Map<String, Object> props, ValueFactory vf) throws RepositoryException {
        for (Map.Entry<String, Object> prop : props.entrySet()) {
            Object value = prop.getValue();
            if (value.getClass().isArray()) {
                Object[] allValues = (Object[])value;
                Value[] values = new Value[allValues.length];
                for (int i = 0; i < allValues.length; ++i) {
                    if (allValues[i] == null) continue;
                    values[i] = vf.createValue(allValues[i].toString());
                }
                user.setProperty(prop.getKey(), values);
                continue;
            }
            if (prop.getValue() == null) continue;
            user.setProperty(prop.getKey(), vf.createValue(prop.getValue().toString()));
        }
        Iterator it = user.getPropertyNames();
        while (it.hasNext()) {
            String property = (String)it.next();
            if (!property.startsWith("profile/facebook") || props.get(property) != null) continue;
            this.log.info("**** removing property:" + property);
            user.removeProperty(property);
        }
    }

    public void storeAccessToken(HttpServletRequest request, Provider provider, User user, ValueFactory vf) {
        if (this.config.getSaveAccessToken()) {
            String propertyPath = provider.getAccessTokenPropertyPath(this.config.getClientId());
            try {
                this.config.getOAuthTokenManager().saveToken(this.config.getClientId(), request, user, vf, propertyPath);
            }
            catch (RepositoryException e) {
                this.log.error("could not save access token for user {}", (Object)user, (Object)e);
            }
        } else {
            this.log.debug("config {} does not allow storing access token with user", (Object)this.config.getConfigId());
        }
    }

    public boolean storeAccessToken(HttpServletRequest request, Node encryptedTokenNode) throws RepositoryException {
        return this.config.getOAuthTokenManager().saveToken(this.config.getClientId(), request, encryptedTokenNode);
    }

    public String getAuthorizedId(HttpServletRequest request) {
        OAuthToken token = this.config.getOAuthTokenManager().getToken(this.config.getClientId(), request);
        if (token != null && token.isAuthentic()) {
            return (String)token.getAttribute(TOKEN_ATTR_USER);
        }
        return null;
    }

    public void setAuthorizedId(HttpServletRequest request, HttpServletResponse response, String userId) {
        if (userId == null) {
            this.config.getOAuthTokenManager().invalidate(this.config.getClientId(), request, response);
        } else {
            OAuthToken token = this.config.getOAuthTokenManager().getToken(this.config.getClientId(), request);
            if (token != null && token.isAuthentic()) {
                token.setAttribute(TOKEN_ATTR_USER, userId);
                this.config.getOAuthTokenManager().saveToken(token, request, response);
            }
        }
    }

    public OAuthUser getUserDetails(Provider provider, HttpServletRequest request, boolean includeExtendedDetails) throws IOException {
        OAuthToken token = this.config.getOAuthTokenManager().getToken(this.config.getClientId(), request);
        return this.getUserDetails(token, provider, includeExtendedDetails);
    }

    public OAuthUser getUserDetails(Provider provider, User user, boolean includeExtendedDetails) throws IOException {
        try {
            String encryptedTokenProperty = provider.getAccessTokenPropertyPath(this.config.getClientId());
            OAuthToken token = this.config.getOAuthTokenManager().getToken(this.config.getClientId(), user, encryptedTokenProperty);
            if (token != null && token.isAuthentic()) {
                return this.getUserDetails(token, provider, includeExtendedDetails);
            }
            this.log.debug("accesss token for user {} at property {} was missing or invalid", (Object)user, (Object)encryptedTokenProperty);
        }
        catch (RepositoryException re) {
            this.log.error("could not retrieve access token", (Throwable)re);
        }
        return null;
    }

    private OAuthUser getUserDetails(OAuthToken token, Provider provider, boolean includeExtendedDetails) throws IOException {
        if (token != null && token.isAuthentic()) {
            Token accessToken = new Token(token.getKey(), token.getSecret());
            ArrayList<String> urls = new ArrayList<String>();
            OAuthUser oauthUser = this.fetchAndMapBasicData(provider, provider.getDetailsURL(), accessToken);
            String[] extendedDetailsURLs = provider.getExtendedDetailsURLs(this.config.getScope());
            if (includeExtendedDetails && extendedDetailsURLs != null && extendedDetailsURLs.length > 0) {
                urls.addAll(Arrays.asList(extendedDetailsURLs));
                for (String url : urls) {
                    oauthUser = this.fetchAndMapExtendedData(provider, url, accessToken, oauthUser);
                }
            }
            return oauthUser;
        }
        this.log.warn("token was null or not authentic:{}", (Object)token);
        return null;
    }

    public Response getProtectedData(Resource encryptedTokenResource, Provider provider, OAuthRequest oauthRequest) {
        try {
            OAuthToken token = this.config.getOAuthTokenManager().getToken(encryptedTokenResource);
            if (token != null && token.isAuthentic()) {
                Token accessToken = new Token(token.getKey(), token.getSecret());
                return this.getProtectedData(accessToken, provider, oauthRequest);
            }
            this.log.debug("accesss token at {} was missing or invalid", (Object)encryptedTokenResource.getPath());
        }
        catch (RepositoryException re) {
            this.log.error("could not retrieve access token", (Throwable)re);
        }
        return null;
    }

    public Response getProtectedData(User user, Provider provider, OAuthRequest oauthRequest) {
        try {
            String encryptedTokenProperty = provider.getAccessTokenPropertyPath(this.config.getClientId());
            OAuthToken token = this.config.getOAuthTokenManager().getToken(this.config.getClientId(), user, encryptedTokenProperty);
            if (token != null && token.isAuthentic()) {
                Token accessToken = new Token(token.getKey(), token.getSecret());
                return this.getProtectedData(accessToken, provider, oauthRequest);
            }
            this.log.debug("accesss token for user {} at property {} was missing or invalid", (Object)user, (Object)encryptedTokenProperty);
        }
        catch (RepositoryException re) {
            this.log.error("could not retrieve access token", (Throwable)re);
        }
        return null;
    }

    private Response getProtectedData(Token accessToken, Provider provider, OAuthRequest request) {
        this.getService(provider).signRequest(accessToken, request);
        return request.send();
    }

    private Response getProtectedProfileData(Token accessToken, Provider provider, String url) {
        OAuthRequest request = provider.getProtectedDataRequest(url);
        return this.getProtectedData(accessToken, provider, request);
    }

    public OAuthUser fetchAndMapBasicData(Provider provider, String url, Token accessToken) throws IOException {
        Map<String, String> newProperties = this.fetchProfileData(provider, url, accessToken);
        String id = newProperties.get(provider.getUserIdProperty());
        if (id == null) {
            this.log.error("retrieveBasicData: could not retrieve user id from {}", (Object)provider.getDetailsURL());
            return null;
        }
        Map<String, Object> mappedProperties = provider.mapProperties(url, this.config.getClientId(), Collections.<String, Object>emptyMap(), newProperties);
        return new OAuthUser(id, mappedProperties);
    }

    public OAuthUser fetchAndMapExtendedData(Provider provider, String url, Token accessToken, OAuthUser oauthUser) throws IOException {
        Map<String, String> newProperties = this.fetchProfileData(provider, url, accessToken);
        Map<String, Object> mappedProperties = provider.mapProperties(url, this.config.getClientId(), oauthUser.getProperties(), newProperties);
        return new OAuthUser(oauthUser.getId(), mappedProperties);
    }

    private Map<String, String> fetchProfileData(Provider provider, String url, Token accessToken) throws IOException {
        this.log.debug("fetching data from url:{}", (Object)url);
        Response response = this.getProtectedProfileData(accessToken, provider, url);
        Map<String, String> newProps = provider.parseProfileDataResponse(response);
        return newProps;
    }

    protected OAuthService getService(Provider provider) {
        return this.config.getOAuthService(provider, this.callBackUrl);
    }

    protected OAuthService getService(Provider provider, HttpServletRequest request, boolean isAuthentication) {
        String callBackUrl;
        if (this.callBackUrl != null && !this.callBackUrl.startsWith("/")) {
            callBackUrl = this.callBackUrl;
        } else {
            StringBuilder buf = new StringBuilder();
            buf.append(request.isSecure() ? "https" : "http");
            buf.append("://");
            buf.append(this.getHost(request));
            if (this.callBackUrl != null && this.callBackUrl.startsWith("/")) {
                buf.append(this.callBackUrl);
            } else {
                buf.append(OAuthHelper.getOriginalRequestUri(request.getRequestURI()));
            }
            if (isAuthentication) {
                buf.append(CALLBACK_SUFFIX_AUTHENTICATE);
            } else {
                buf.append(CALLBACK_SUFFIX_CONNECT);
            }
            callBackUrl = buf.toString();
        }
        this.log.debug("getService: Getting Service with callback={}", (Object)callBackUrl);
        return this.config.getOAuthService(provider, callBackUrl);
    }

    private String getHost(HttpServletRequest request) {
        String xHost = request.getHeader("x-forwarded-host");
        if (xHost == null) {
            String host = request.getHeader("Host");
            if (host == null) {
                String urlS = request.getRequestURL().toString();
                try {
                    return new URI(urlS).getAuthority();
                }
                catch (URISyntaxException use) {
                    return request.getServerName() + ":" + request.getServerPort();
                }
            }
            return host;
        }
        if (xHost.indexOf(44) >= 0) {
            xHost = xHost.substring(xHost.indexOf(44));
        }
        return xHost.trim();
    }

    public static String getOriginalRequestUri(String callbackRequestUri) {
        int requestUriLength = callbackRequestUri.length();
        if (callbackRequestUri.endsWith(CALLBACK_SUFFIX_AUTHENTICATE)) {
            requestUriLength -= CALLBACK_SUFFIX_AUTHENTICATE.length();
        } else if (callbackRequestUri.endsWith(REDIRECT_SUFFIX_AUTHENTICATE)) {
            requestUriLength -= REDIRECT_SUFFIX_AUTHENTICATE.length();
        } else if (callbackRequestUri.endsWith(CALLBACK_SUFFIX_CONNECT)) {
            requestUriLength -= CALLBACK_SUFFIX_CONNECT.length();
        } else if (callbackRequestUri.endsWith(REDIRECT_SUFFIX_CONNECT)) {
            requestUriLength -= REDIRECT_SUFFIX_CONNECT.length();
        }
        return callbackRequestUri.substring(0, requestUriLength);
    }

    public User createOrUpdateCRXUser(Session s, CryptoSupport cryptoSupport, Provider provider, HttpServletRequest request, OAuthUser oauthUser) throws RepositoryException {
        try {
            return this.createOrUpdateCRXUser(s, cryptoSupport, provider, request, oauthUser, null);
        }
        catch (OAuthIdInUseException e) {
            return null;
        }
    }

    public User createOrUpdateCRXUser(Session s, CryptoSupport cryptoSupport, Provider provider, HttpServletRequest request, OAuthUser oauthUser, User linkedUser) throws RepositoryException, OAuthIdInUseException {
        boolean userCreate;
        UserManager um = ((JackrabbitSession)s).getUserManager();
        User existingUserWithOauthID = this.getProviderConfig().getForceStrictUsernameMatching() ? this.getCRXUserByMappedId(um, provider, oauthUser) : this.getCRXUserByOAuthId(um, provider, oauthUser);
        if (linkedUser != null && existingUserWithOauthID != null && !linkedUser.getID().equals(existingUserWithOauthID.getID())) {
            throw new OAuthIdInUseException("Cannot link to user " + linkedUser.getID() + "; OAuth ID " + oauthUser.getId() + " already linked to user " + existingUserWithOauthID.getID());
        }
        User user = linkedUser != null ? linkedUser : existingUserWithOauthID;
        boolean bl = userCreate = user == null;
        if (user == null && (user = this.createUserForOAuthId(s, cryptoSupport, provider, oauthUser)) == null) {
            this.log.warn("createOrUpdateCRXUser: could not create user, user auto creation may not be enabled");
            return null;
        }
        ValueFactory vf = s.getValueFactory();
        String userPropKey = this.getUserPropKey(provider);
        user.setProperty(userPropKey, vf.createValue(oauthUser.getId()));
        this.assignUserProfileData(user, oauthUser.getProperties(), vf);
        for (String group : this.getProviderConfig().getAutoCreateUsersGroups()) {
            Authorizable auth;
            if (group == null || group.length() <= 0 || (auth = um.getAuthorizable(group)) == null || !auth.isGroup() || ((Group)auth).isMember((Authorizable)user)) continue;
            ((Group)auth).addMember((Authorizable)user);
        }
        this.storeAccessToken(request, provider, user, vf);
        if (userCreate) {
            provider.onUserCreate(user);
        } else {
            provider.onUserUpdate(user);
        }
        return user;
    }

    public User getCRXUserByOAuthId(UserManager um, Provider provider, OAuthUser oauthUser) throws RepositoryException {
        String userPropKey = this.getUserPropKey(provider);
        Iterator auths = um.findAuthorizables(userPropKey, oauthUser.getId(), 1);
        User user = null;
        while (auths.hasNext() && user == null) {
            Authorizable auth = (Authorizable)auths.next();
            if (!auth.isGroup()) {
                user = (User)auth;
            }
            if (!auths.hasNext()) continue;
            this.log.info("getCRXUserByOAuthId: More than one user registered for ID={} of oauth config {}; assuming {}", new Object[]{oauthUser.getId(), this.getProviderConfig().getConfigId(), user.getID()});
        }
        return user;
    }

    public Iterator<Authorizable> getCRXUsersByOAuthId(UserManager um, Provider provider, OAuthUser oauthUser) throws RepositoryException {
        String userPropKey = this.getUserPropKey(provider);
        return um.findAuthorizables(userPropKey, oauthUser.getId(), 1);
    }

    public User getCRXUserByMappedId(UserManager um, Provider provider, OAuthUser oauthUser) throws RepositoryException {
        User user = null;
        String mappedOauthUsername = this.getMappedOauthUsername(provider, oauthUser);
        Authorizable auth = um.getAuthorizable(mappedOauthUsername);
        if (auth != null && !auth.isGroup()) {
            user = (User)auth;
            if (!oauthUser.getId().equals(this.getOauthUserId(provider, user))) {
                this.log.warn("Collision detected for userId: {} oauthUserId {}", (Object)user.getID(), (Object)oauthUser.getId());
                user = this.getCRXUserByOAuthId(um, provider, oauthUser);
                if (user == null) {
                    this.log.debug("user not found, handling collision, returning null");
                    return null;
                }
            }
        }
        return user;
    }

    private String getOauthUserId(Provider provider, User user) throws RepositoryException {
        String userIdProperty = this.getUserPropKey(provider);
        Value[] oauthUserIdProperty = user.hasProperty(userIdProperty) ? user.getProperty(userIdProperty) : null;
        return oauthUserIdProperty != null && oauthUserIdProperty.length > 0 ? oauthUserIdProperty[0].getString() : null;
    }

    private String getMappedOauthUsername(Provider provider, OAuthUser oauthUser) {
        String uid = provider.mapUserId(oauthUser.getId(), oauthUser.getProperties());
        if (this.getProviderConfig().getEncodeUserIds()) {
            uid = this.encodeBase64(StringUtils.getBytesUtf8((String)uid));
        }
        if (this.getProviderConfig().getHashUserIds()) {
            uid = this.hashUserId(uid);
        }
        return uid;
    }

    private String hashUserId(String userId) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] input = userId.getBytes("UTF-8");
            byte[] hash = md.digest(input);
            String base64Hash = Base64.encodeBase64URLSafeString((byte[])hash).toLowerCase();
            return base64Hash;
        }
        catch (Exception e) {
            this.log.error("Failed to hash a userId: ", (Object)e.getMessage());
            return null;
        }
    }

    private String generateUniqueIdentifier(UserManager um, String baseUserId) throws RepositoryException {
        Random random = new Random(System.currentTimeMillis());
        for (int i = 0; i < 1000; ++i) {
            String guessIdentifier = baseUserId + random.nextInt();
            if (um.getAuthorizable(guessIdentifier) != null) continue;
            return guessIdentifier;
        }
        return null;
    }

    private User createUserForOAuthId(Session s, CryptoSupport cryptoSupport, Provider provider, OAuthUser oauthUser) throws RepositoryException {
        if (provider == null) {
            this.log.error("createUserForOauthId: helper or provider is null");
            return null;
        }
        if (!this.getProviderConfig().getAutoCreateUsers()) {
            this.log.debug("createUserForId: User creation disabled");
            return null;
        }
        User user = null;
        try {
            String uid;
            UserManager um = ((JackrabbitSession)s).getUserManager();
            byte[] key = new byte[16];
            try {
                cryptoSupport.nextRandomBytes(key);
            }
            catch (CryptoException e) {
                this.log.error("cryptoSupport.nextRandomBytes failed", (Throwable)e);
                new Random().nextBytes(key);
            }
            final String principalId = uid = this.getMappedOauthUsername(provider, oauthUser);
            Principal principal = new Principal(){

                public String getName() {
                    return principalId;
                }
            };
            String intermediatePath = provider.getUserFolderPath(oauthUser.getId(), this.getProviderConfig().getClientId(), oauthUser.getProperties());
            try {
                user = um.createUser(uid, this.encodeBase64(key), principal, intermediatePath);
            }
            catch (AuthorizableExistsException e) {
                this.log.warn("Collision detected for userId: {} , generate unique identifier", (Object)uid);
                final String newPrincipalId = uid = this.generateUniqueIdentifier(um, this.getMappedOauthUsername(provider, oauthUser));
                principal = new Principal(){

                    public String getName() {
                        return newPrincipalId;
                    }
                };
                user = um.createUser(uid, this.encodeBase64(key), principal, intermediatePath);
            }
            return user;
        }
        catch (RepositoryException e) {
            if (user != null) {
                try {
                    user.remove();
                }
                catch (RepositoryException re) {
                    // empty catch block
                }
            }
            throw e;
        }
    }

    private String encodeBase64(byte[] value) {
        byte[] encoded = Base64.encodeBase64((byte[])value);
        return StringUtils.newStringUtf8((byte[])encoded);
    }
}

