/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.auth.oauth.impl.helper;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OAuthToken {
    public static final int UNITIALIZED = 0;
    public static final int UNAUTHORIZED = 1;
    public static final int AUTHORIZED = 2;
    public static final int ACCESS_TOKEN = 3;
    private int _state;
    private String _ck;
    private String _key;
    private String _secret;
    private Map<String, Object> _attributes;

    public OAuthToken() {
    }

    public OAuthToken(String ck) {
        this._ck = ck;
    }

    public OAuthToken(String ck, String key, String secret) {
        this(ck, key, secret, 0);
    }

    public OAuthToken(String ck, String key, String secret, int state) {
        this._ck = ck;
        this._key = key;
        this._secret = secret;
        this._state = state;
    }

    public int getState() {
        return this._state;
    }

    void setState(int state) {
        this._state = state;
    }

    public String getCk() {
        return this._ck;
    }

    public String getKey() {
        return this._key;
    }

    void setKey(String key) {
        this._key = key;
    }

    public String getSecret() {
        return this._secret;
    }

    void setSecret(String secret) {
        this._secret = secret;
    }

    void set(int state, String key, String secret) {
        this._state = state;
        this._key = key;
        this._secret = secret;
    }

    public boolean authorize(String key, String verifier) {
        if (this._state < 2) {
            if (this._state > 0 && this._key != null && this._key.equals(key)) {
                this._state = 2;
                if (verifier != null) {
                    this.setAttribute("oauth_verifier", verifier);
                }
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean isAuthentic() {
        return this._state == 3;
    }

    public Map<String, Object> getAttributes() {
        return this._attributes;
    }

    public Object getAttribute(String key) {
        return this._attributes == null ? null : this._attributes.get(key);
    }

    public void setAttribute(String key, Object value) {
        if (this._attributes == null) {
            this._attributes = new HashMap<String, Object>();
        }
        this._attributes.put(key, value);
    }

    public static OAuthToken fromJSON(String jsonString) {
        try {
            JSONObject json = new JSONObject(jsonString);
            OAuthToken token = new OAuthToken();
            token._state = json.optInt("st");
            token._ck = json.optString("ck");
            token._key = json.optString("k");
            token._secret = json.optString("sk");
            JSONObject attr = json.optJSONObject("a");
            if (attr != null) {
                HashMap<String, Object> attributes = new HashMap<String, Object>();
                Iterator keys = attr.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    attributes.put(key, attr.get(key));
                }
                token._attributes = attributes;
            }
            return token;
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    public String toJSON() throws IOException {
        try {
            JSONObject json = new JSONObject();
            json.put("st", this._state);
            json.put("ck", (Object)this._ck);
            if (this._key != null) {
                json.put("k", (Object)this._key);
            }
            if (this._secret != null) {
                json.put("sk", (Object)this._secret);
            }
            if (this._attributes != null) {
                json.put("a", this._attributes);
            }
            return json.toString();
        }
        catch (JSONException je) {
            throw new IOException(je.getMessage());
        }
    }
}

