/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.auth.oauth.impl.helper;

import com.adobe.granite.auth.oauth.impl.helper.OAuthToken;
import com.adobe.granite.crypto.CryptoException;
import com.adobe.granite.crypto.CryptoSupport;
import com.day.crx.security.token.TokenCookie;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OauthTokenManager {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String PROPERTY_OAUTH_TOKEN = "oauth.accesstoken.encrypted";
    private CryptoSupport cryptoSupport;
    private String _cookieDomain;
    private String _cookiePath;
    private int _maxAge = 600;
    private int _loginTimeout = 60;

    public OauthTokenManager(CryptoSupport cryptoSupport, int loginTimeout, int maxAge) {
        this.cryptoSupport = cryptoSupport;
        this._loginTimeout = loginTimeout;
        this._maxAge = maxAge;
        this._cookiePath = "/";
        this._cookieDomain = null;
    }

    public void setCryptoSupport(CryptoSupport cryptoSupport) {
        this.cryptoSupport = cryptoSupport;
    }

    public void setMaxAge(int maxAge) {
        this._maxAge = maxAge;
    }

    public void setLoginTimeout(int loginTimeout) {
        this._loginTimeout = loginTimeout;
    }

    public OAuthToken getToken(String consumerKey, HttpServletRequest request) {
        Object tokenAttr = request.getAttribute(consumerKey);
        if (tokenAttr instanceof OAuthToken) {
            this.log.debug("token retrieved via request attribute:{}", tokenAttr);
            return (OAuthToken)tokenAttr;
        }
        String cookie = TokenCookie.getCookie((HttpServletRequest)request, (String)consumerKey);
        if (cookie != null) {
            OAuthToken token = this.getToken(cookie);
            request.setAttribute(consumerKey, (Object)token);
            this.log.debug("token retrieved via cookie:{}", (Object)token);
            return token;
        }
        this.log.info("token not found in request attribute or cookie for:{}", (Object)consumerKey);
        return null;
    }

    public OAuthToken getToken(String consumerKey, User user, String accessTokenPropertyPath) throws RepositoryException {
        Value[] val;
        if (user.hasProperty(accessTokenPropertyPath) && (val = user.getProperty(accessTokenPropertyPath)) != null && val[0] != null) {
            String encryptedTokenString = val[0].getString();
            OAuthToken token = this.getToken(encryptedTokenString);
            this.log.debug("token retrieved from jcr:{}", (Object)token);
            return token;
        }
        this.log.info("token not found in user:{} for app id:{}", (Object)user, (Object)consumerKey);
        return null;
    }

    public OAuthToken getToken(Resource encryptedTokenResource) throws RepositoryException {
        String encryptedToken = (String)((ValueMap)encryptedTokenResource.adaptTo(ValueMap.class)).get(PROPERTY_OAUTH_TOKEN, String.class);
        return this.getToken(encryptedToken);
    }

    private OAuthToken getToken(String cookie) {
        if (cookie != null) {
            String value = null;
            try {
                value = this.cryptoSupport.unprotect(cookie);
                return OAuthToken.fromJSON(value);
            }
            catch (CryptoException e) {
                this.log.error("failed decrypting cookie:{}", (Object)cookie);
            }
        }
        return null;
    }

    public boolean saveToken(OAuthToken token, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute(token.getCk(), (Object)token);
        String value = this.getEncryptedTokenString(token);
        if (value == null) {
            return false;
        }
        return this.write(token.getCk(), "\"" + value + "\"", token.isAuthentic() ? this._maxAge : this._loginTimeout, request.isSecure(), response);
    }

    public boolean saveToken(String consumerKey, HttpServletRequest request, Node encryptedTokenNode) throws RepositoryException {
        OAuthToken token = this.getToken(consumerKey, request);
        String value = this.getEncryptedTokenString(token);
        encryptedTokenNode.setProperty(PROPERTY_OAUTH_TOKEN, value);
        encryptedTokenNode.getSession().save();
        return value != null;
    }

    public boolean saveToken(String consumerKey, HttpServletRequest request, User user, ValueFactory vf, String propertyPath) throws RepositoryException {
        OAuthToken token = this.getToken(consumerKey, request);
        String value = this.getEncryptedTokenString(token);
        user.setProperty(propertyPath, vf.createValue(value));
        return true;
    }

    public boolean invalidate(String consumerKey, HttpServletRequest request, HttpServletResponse response) {
        request.removeAttribute(consumerKey);
        return this.write(consumerKey, "", 0, request.isSecure(), response);
    }

    protected boolean write(String name, String value, int maxAge, boolean isSecure, HttpServletResponse response) {
        TokenCookie.setCookie((HttpServletResponse)response, (String)name, (String)value, (int)maxAge, (String)this._cookiePath, (String)this._cookieDomain, (boolean)true, (boolean)isSecure);
        return true;
    }

    private String getEncryptedTokenString(OAuthToken token) {
        try {
            return this.cryptoSupport.protect(token.toJSON());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.error("failed encrypting cookie:{}", (Object)(token == null ? null : token.toString()));
            return null;
        }
    }
}

