/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.auth.oauth.impl.helper;

import com.adobe.granite.auth.oauth.Provider;
import com.adobe.granite.auth.oauth.impl.helper.OauthTokenManager;
import com.adobe.granite.crypto.CryptoSupport;
import java.util.Dictionary;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyUnbounded;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.osgi.service.cm.ConfigurationException;
import org.scribe.model.OAuthConfig;
import org.scribe.model.SignatureType;
import org.scribe.oauth.OAuthService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(name="com.adobe.granite.auth.oauth.provider", ds=false, metatype=true, configurationFactory=true)
@Properties(value={@Property(name="oauth.config.id"), @Property(name="oauth.client.id"), @Property(name="oauth.client.secret"), @Property(name="oauth.scope", unbounded=PropertyUnbounded.ARRAY), @Property(name="oauth.config.provider.id"), @Property(name="oauth.create.users", boolValue={false}), @Property(name="force.strict.username.matching", boolValue={false}), @Property(name="oauth.create.users.groups", unbounded=PropertyUnbounded.ARRAY), @Property(name="oauth.encode.userids", boolValue={false}), @Property(name="oauth.hash.userids", boolValue={false}), @Property(name="oauth.callBackUrl", value={""}), @Property(name="oauth.access.token.persist", boolValue={false})})
public class ProviderConfig {
    private boolean autoCreateUsers;
    private boolean forceStrictUsernameMatching;
    private boolean encodeUserIds;
    private boolean hashUserIds;
    private String[] autoCreateUsersGroups;
    private final String configId;
    private final String providerId;
    private String callBackUrl;
    private boolean saveAccessToken;
    private OauthTokenManager tokenManager;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final String clientId;
    private final String clientSecret;
    private final String pid;
    private String scope;
    private int loginTimeout;
    private int cookieMaxAge;

    public ProviderConfig(String pid, int loginTimeout, int cookieMaxAge, Dictionary<String, Object> config, CryptoSupport cryptoSupport) throws ConfigurationException {
        String scope;
        this.pid = pid;
        this.cookieMaxAge = cookieMaxAge;
        this.loginTimeout = loginTimeout;
        String configId = OsgiUtil.toString((Object)config.get("oauth.config.id"), (String)"");
        if (configId.length() == 0) {
            throw new ConfigurationException("oauth.config.id", "Config ID must not be empty");
        }
        String clientId = OsgiUtil.toString((Object)config.get("oauth.client.id"), (String)"");
        String clientSecret = OsgiUtil.toString((Object)config.get("oauth.client.secret"), (String)"");
        this.providerId = OsgiUtil.toString((Object)config.get("oauth.config.provider.id"), (String)"");
        if (this.providerId.length() == 0) {
            throw new ConfigurationException("oauth.config.provider.id", "Provider ID must not be empty");
        }
        String[] scopes = OsgiUtil.toStringArray((Object)config.get("oauth.scope"));
        if (scopes == null || scopes.length == 0) {
            scope = null;
        } else {
            StringBuilder result = new StringBuilder();
            String separator = "";
            for (String string : scopes) {
                result.append(separator);
                result.append(string);
                separator = ",";
            }
            scope = result.toString();
        }
        this.autoCreateUsers = OsgiUtil.toBoolean((Object)config.get("oauth.create.users"), (boolean)false);
        this.encodeUserIds = OsgiUtil.toBoolean((Object)config.get("oauth.encode.userids"), (boolean)false);
        this.hashUserIds = OsgiUtil.toBoolean((Object)config.get("oauth.hash.userids"), (boolean)false);
        this.forceStrictUsernameMatching = OsgiUtil.toBoolean((Object)config.get("force.strict.username.matching"), (boolean)false);
        this.autoCreateUsersGroups = OsgiUtil.toStringArray((Object)config.get("oauth.create.users.groups"), (String[])new String[0]);
        this.saveAccessToken = OsgiUtil.toBoolean((Object)config.get("oauth.access.token.persist"), (boolean)false);
        String configCallBackUrl = OsgiUtil.toString((Object)config.get("oauth.callBackUrl"), (String)"");
        if (configCallBackUrl == null || configCallBackUrl.length() == 0) {
            configCallBackUrl = null;
        }
        this.callBackUrl = configCallBackUrl;
        this.configId = configId;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.scope = scope;
        this.tokenManager = new OauthTokenManager(cryptoSupport, loginTimeout, cookieMaxAge);
    }

    public String getConfigId() {
        return this.configId;
    }

    public String getPid() {
        return this.pid;
    }

    public String getProviderId() {
        return this.providerId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getCallBackUrl() {
        return this.callBackUrl;
    }

    public boolean getAutoCreateUsers() {
        return this.autoCreateUsers;
    }

    public boolean getEncodeUserIds() {
        return this.encodeUserIds;
    }

    public boolean getHashUserIds() {
        return this.hashUserIds;
    }

    public boolean getForceStrictUsernameMatching() {
        return this.forceStrictUsernameMatching;
    }

    public String[] getAutoCreateUsersGroups() {
        return this.autoCreateUsersGroups;
    }

    public boolean getSaveAccessToken() {
        return this.saveAccessToken;
    }

    public OauthTokenManager getOAuthTokenManager() {
        return this.tokenManager;
    }

    public int getCookieMaxAge() {
        return this.cookieMaxAge;
    }

    public int getLoginTimeout() {
        return this.loginTimeout;
    }

    public OAuthService getOAuthService(Provider provider, String callbackUrl) {
        OAuthConfig scribeConfig = new OAuthConfig(this.getClientId(), this.getClientSecret(), callbackUrl, SignatureType.QueryString, this.getScope(), null);
        return provider.getApi().createService(scribeConfig);
    }

    public String getScope() {
        return this.scope;
    }
}

