/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.auth.oauth.impl.helper;

import com.adobe.granite.auth.oauth.Provider;
import com.adobe.granite.auth.oauth.ProviderType;
import com.adobe.granite.auth.oauth.impl.helper.OAuthHelper;
import com.adobe.granite.auth.oauth.impl.helper.ProviderConfig;
import com.adobe.granite.auth.oauth.impl.helper.ProviderConfigManager;
import com.adobe.granite.auth.oauth.impl.oauth1a.Oauth1aHelper;
import com.adobe.granite.auth.oauth.impl.oauth2.Oauth2Helper;
import com.adobe.granite.crypto.CryptoSupport;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(metatype=true, label="Adobe Granite ProviderConfigManager Service", description="Private service for managing Provider, OAuthHelper, and ProviderConfig caches.", name="com.adobe.granite.auth.oauth.impl.helper.ProviderConfigManager")
@Service(value={ProviderConfigManager.class})
@Reference(name="oauthProvider", referenceInterface=Provider.class, bind="bindOauthProvider", unbind="unbindOauthProvider", cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC)
public class ProviderConfigManagerImpl
implements ProviderConfigManager {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private ServiceRegistration providerConfigService;
    private final Map<String, OAuthHelper> helperCache = new ConcurrentHashMap<String, OAuthHelper>();
    private final Map<String, ProviderConfig> configurations = new HashMap<String, ProviderConfig>();
    private final Map<String, Provider> providerCache = new HashMap<String, Provider>();
    private int cookieMaxAge;
    private int loginTimeout;
    @Property
    private static final String PROP_COOKIE_LOGIN_TIMEOUT = "oauth.cookie.login.timeout";
    private static final int DEFAULT_COOKIE_LOGIN_TIMEOUT = 60;
    @Property
    private static final String PROP_COOKIE_MAX_AGE = "oauth.cookie.max.age";
    private static final int DEFAULT_COOKIE_MAX_AGE = -1;
    @Reference
    private CryptoSupport cryptoSupport;

    @Activate
    private void activate(BundleContext context, Map<String, Object> config) {
        this.log.info("activating ProviderConfigManager");
        this.cookieMaxAge = OsgiUtil.toInteger((Object)config.get(PROP_COOKIE_MAX_AGE), (int)-1);
        this.loginTimeout = OsgiUtil.toInteger((Object)config.get(PROP_COOKIE_LOGIN_TIMEOUT), (int)60);
        ProviderConfigService msf = new ProviderConfigService();
        Properties props = new Properties();
        props.put("service.pid", "com.adobe.granite.auth.oauth.provider");
        props.put("service.vendor", config.get("service.vendor"));
        props.put("service.description", "OAuth Provider Configurator");
        this.providerConfigService = context.registerService(ManagedServiceFactory.class.getName(), (Object)msf, (Dictionary)props);
    }

    @Deactivate
    private void deactivate() {
        this.log.debug("deactivating ProviderConfigManager");
        this.configurations.clear();
        this.providerCache.clear();
        this.helperCache.clear();
        if (this.providerConfigService != null) {
            this.providerConfigService.unregister();
            this.providerConfigService = null;
        }
    }

    @Override
    public OAuthHelper getHelper(String configId) {
        return this.helperCache.get(configId);
    }

    @Override
    public Provider getProvider(String configId) {
        ProviderConfig config = this.configurations.get(configId);
        return config == null ? null : this.providerCache.get(config.getProviderId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bindOauthProvider(Provider newProvider, Map<String, Object> properties) {
        Provider existingProvider = this.providerCache.get(newProvider.getId());
        if (existingProvider != null) {
            this.log.error("provider id was not unique:{}, matched id of existing provider {}", (Object)newProvider.getId(), (Object)existingProvider.toString());
            return;
        }
        Map<String, Provider> map = this.providerCache;
        synchronized (map) {
            this.providerCache.put(newProvider.getId(), newProvider);
            for (Map.Entry<String, ProviderConfig> entry : this.configurations.entrySet()) {
                if (!entry.getValue().getProviderId().equals(newProvider.getId())) continue;
                OAuthHelper helper = this.createHelper(newProvider.getType(), entry.getValue());
                this.helperCache.put(entry.getKey(), helper);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindOauthProvider(Provider provider, Map<String, Object> properties) {
        Map<String, Provider> map = this.providerCache;
        synchronized (map) {
            this.providerCache.remove(provider.getId());
            for (Map.Entry<String, ProviderConfig> entry : this.configurations.entrySet()) {
                if (!entry.getValue().getProviderId().equals(provider.getId())) continue;
                this.helperCache.remove(entry.getKey());
            }
        }
    }

    private OAuthHelper createHelper(ProviderType type, ProviderConfig config) {
        switch (type) {
            case OAUTH1A: {
                return new Oauth1aHelper(config);
            }
            case OAUTH2: {
                return new Oauth2Helper(config);
            }
        }
        this.log.error("unsupported ProviderType:" + (Object)((Object)type));
        return null;
    }

    protected void bindCryptoSupport(CryptoSupport cryptoSupport) {
        this.cryptoSupport = cryptoSupport;
    }

    protected void unbindCryptoSupport(CryptoSupport cryptoSupport) {
        if (this.cryptoSupport == cryptoSupport) {
            this.cryptoSupport = null;
        }
    }

    private class ProviderConfigService
    implements ManagedServiceFactory {
        private ProviderConfigService() {
        }

        public String getName() {
            return "com.adobe.granite.auth.oauth.provider";
        }

        public void deleted(String pid) {
            Iterator it = ProviderConfigManagerImpl.this.configurations.entrySet().iterator();
            while (it.hasNext()) {
                ProviderConfig config = (ProviderConfig)it.next().getValue();
                if (!config.getPid().equals(pid)) continue;
                String configId = config.getConfigId();
                it.remove();
                ProviderConfigManagerImpl.this.helperCache.remove(configId);
            }
        }

        public void updated(String pid, Dictionary properties) throws ConfigurationException {
            ProviderConfig config = new ProviderConfig(pid, ProviderConfigManagerImpl.this.loginTimeout, ProviderConfigManagerImpl.this.cookieMaxAge, properties, ProviderConfigManagerImpl.this.cryptoSupport);
            String configId = config.getConfigId();
            ProviderConfig existing = (ProviderConfig)ProviderConfigManagerImpl.this.configurations.get(configId);
            if (existing != null && !config.getPid().equals(existing.getPid())) {
                throw new ConfigurationException("oauth.config.id", "Config Id must be unique.");
            }
            ProviderConfig old = ProviderConfigManagerImpl.this.configurations.put(configId, config);
            Provider provider = (Provider)ProviderConfigManagerImpl.this.providerCache.get(config.getProviderId());
            if (provider != null) {
                OAuthHelper helper = ProviderConfigManagerImpl.this.createHelper(provider.getType(), config);
                ProviderConfigManagerImpl.this.helperCache.put(configId, helper);
            } else if (old != null) {
                ProviderConfigManagerImpl.this.helperCache.remove(configId);
            }
        }
    }
}

