/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.auth.oauth.impl.helper;

import com.adobe.granite.auth.oauth.impl.helper.OAuthHelper;
import com.day.crx.security.token.TokenCookie;
import java.io.IOException;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.settings.SlingSettingsService;
import org.scribe.utils.OAuthEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RequestHelper {
    public static final String PARAM_CONFIG_ID = "configid";
    private static final String REPO_DESC_ID = "crx.repository.systemid";
    private static final String REPO_DESC_CLUSTER_ID = "crx.cluster.id";
    private static final String COOKIE_CONFIG_ID = "oauth-configid";
    private static final String COOKIE_AUTH_CONFIG_ID = "oauth-authid";
    private static final Logger log = LoggerFactory.getLogger(RequestHelper.class);

    private RequestHelper() {
    }

    public static String getRepositoryId(SlingRepository repository, SlingSettingsService settings) {
        String id = repository.getDescriptor(REPO_DESC_CLUSTER_ID);
        if (id == null && (id = repository.getDescriptor(REPO_DESC_ID)) == null && (id = settings.getSlingId()) == null) {
            id = UUID.randomUUID().toString();
            log.error("RequestHelper: Failure to acquire unique ID for this token authenticator. Using random UUID {}", (Object)id);
        }
        return id;
    }

    public static String getConfigId(HttpServletRequest request) {
        return TokenCookie.getCookie((HttpServletRequest)request, (String)COOKIE_CONFIG_ID);
    }

    public static String getAuthenticatedConfigId(HttpServletRequest request) {
        return TokenCookie.getCookie((HttpServletRequest)request, (String)COOKIE_AUTH_CONFIG_ID);
    }

    public static void storeConfigId(String configId, int maxAge, HttpServletRequest request, HttpServletResponse response) {
        TokenCookie.setCookie((HttpServletResponse)response, (String)COOKIE_CONFIG_ID, (String)configId, (int)maxAge, (String)"/", null, (boolean)true, (boolean)request.isSecure());
    }

    public static void storeAuthenticatedConfigId(String configId, int maxAge, HttpServletRequest request, HttpServletResponse response) {
        TokenCookie.setCookie((HttpServletResponse)response, (String)COOKIE_AUTH_CONFIG_ID, (String)configId, (int)maxAge, (String)"/", null, (boolean)true, (boolean)request.isSecure());
    }

    public static void removeConfigId(HttpServletRequest request, HttpServletResponse response) {
        RequestHelper.storeConfigId("", 0, request, response);
    }

    public static void removeAuthenticatedConfigId(HttpServletRequest request, HttpServletResponse response) {
        RequestHelper.storeAuthenticatedConfigId("", 0, request, response);
    }

    public static void handleRedirectAfterAuthentication(HttpServletRequest request, HttpServletResponse response) {
        String resource = request.getParameter("state");
        if (resource != null && !RequestHelper.isRedirectValid(request, resource = OAuthEncoder.decode((String)resource))) {
            log.error("Redirect target '{}' is invalid; checking request URI", (Object)resource);
            resource = null;
        }
        if (resource == null) {
            resource = OAuthHelper.getOriginalRequestUri(request.getRequestURI());
            if (resource.length() == 0) {
                resource = "/";
            } else if (!RequestHelper.isRedirectValid(request, resource)) {
                log.error("Request URI '{}' is invalid, redirecting to '/'", (Object)resource);
                resource = "/";
            }
        }
        try {
            log.debug("Redirecting to '{}' after successful authentication", (Object)resource);
            response.sendRedirect(resource);
        }
        catch (IOException ioe) {
            log.error("Failed to send redirect to: " + resource, (Throwable)ioe);
        }
    }

    public static boolean isInitialCall(HttpServletRequest request, boolean isAuthentication) {
        return (RequestHelper.isInitialLogin(request) || !isAuthentication && RequestHelper.isInitialConnect(request)) && request.getParameter(PARAM_CONFIG_ID) != null;
    }

    public static boolean isAuthzCode(HttpServletRequest request, boolean isAuthentication) {
        return "GET".equals(request.getMethod()) && (RequestHelper.isAuthzLogin(request) || !isAuthentication && RequestHelper.isAuthzConnect(request)) && (request.getParameter("code") != null || request.getParameter("oauth_verifier") != null);
    }

    private static boolean isInitialLogin(HttpServletRequest request) {
        return request.getRequestURI().endsWith("/j_security_check");
    }

    private static boolean isInitialConnect(HttpServletRequest request) {
        return request.getRequestURI().endsWith("/connect");
    }

    private static boolean isAuthzLogin(HttpServletRequest request) {
        return request.getRequestURI().endsWith("/callback/j_security_check");
    }

    private static boolean isAuthzConnect(HttpServletRequest request) {
        return request.getRequestURI().endsWith("/callback/connect");
    }

    public static boolean isRedirectValid(HttpServletRequest request, String target) {
        ResourceResolver resolver;
        if (target == null || target.length() == 0) {
            log.warn("isRedirectValid: Redirect target must not be empty or null");
            return false;
        }
        if (target.contains("://")) {
            log.warn("isRedirectValid: Redirect target '{}' must not be an URL", (Object)target);
            return false;
        }
        int query = target.indexOf(63);
        String path = query > 0 ? target.substring(0, query) : target;
        String contextPath = request.getContextPath();
        if (contextPath != null && target.startsWith(contextPath)) {
            path = path.substring(contextPath.length());
        }
        if (request != null && (resolver = (ResourceResolver)request.getAttribute("org.apache.sling.auth.core.ResourceResolver")) != null) {
            boolean isValid;
            boolean bl = isValid = !ResourceUtil.isNonExistingResource((Resource)resolver.resolve(request, path));
            if (!isValid) {
                log.warn("isRedirectValid: Redirect target '{}' does not resolve to an existing resource", (Object)target);
            }
            return isValid;
        }
        boolean isValid = target.startsWith("/");
        if (!isValid) {
            log.warn("isRedirectValid: Redirect target '{}' must be an absolute path", (Object)target);
        }
        return isValid;
    }

    private static String encodeBase64(byte[] value) {
        byte[] encoded = Base64.encodeBase64((byte[])value);
        return StringUtils.newStringUtf8((byte[])encoded);
    }
}

