/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.auth.oauth.impl.oauth1a;

import com.adobe.granite.auth.oauth.Provider;
import com.adobe.granite.auth.oauth.impl.helper.OAuthHelper;
import com.adobe.granite.auth.oauth.impl.helper.OAuthToken;
import com.adobe.granite.auth.oauth.impl.helper.OAuthUser;
import com.adobe.granite.auth.oauth.impl.helper.ProviderConfig;
import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.scribe.model.Token;
import org.scribe.model.Verifier;
import org.scribe.oauth.OAuthService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Oauth1aHelper
extends OAuthHelper {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public Oauth1aHelper(ProviderConfig config) {
        super(config);
    }

    public void requestAuthorization(Provider provider, HttpServletRequest request, HttpServletResponse response, String state, boolean isAuthentication) throws IOException {
        try {
            OAuthService service = this.getService(provider, request, isAuthentication);
            Token requestToken = service.getRequestToken();
            String redirectUrl = service.getAuthorizationUrl(requestToken);
            OAuthToken token = this.config.getOAuthTokenManager().getToken(this.config.getClientId(), request);
            if (token == null || !token.isAuthentic()) {
                token = new OAuthToken(this.config.getClientId(), requestToken.getToken(), requestToken.getSecret(), 1);
            } else {
                OAuthToken newToken = new OAuthToken(this.config.getClientId(), requestToken.getToken(), requestToken.getSecret(), 3);
                if (token.getAttributes() != null) {
                    for (Map.Entry<String, Object> attr : token.getAttributes().entrySet()) {
                        newToken.setAttribute(attr.getKey(), attr.getValue());
                    }
                }
                token = newToken;
            }
            if (state != null && state.length() > 0) {
                token.setAttribute("state", state);
            }
            request.setAttribute(this.config.getClientId(), (Object)token);
            this.config.getOAuthTokenManager().saveToken(token, request, response);
            response.sendRedirect(redirectUrl);
        }
        catch (Exception e) {
            IOException ex = new IOException("Failed requesting authorization");
            ex.initCause(e);
            throw ex;
        }
    }

    public OAuthUser requestAccessCode(Provider provider, HttpServletRequest request, HttpServletResponse response, boolean isAuthentication, boolean includeExtendedData) throws IOException {
        try {
            OAuthToken token = this.config.getOAuthTokenManager().getToken(this.config.getClientId(), request);
            if (token != null && (token.isAuthentic() || token.getState() == 1)) {
                Token requestToken = new Token(token.getKey(), token.getSecret());
                String oauthVerifier = request.getParameter("oauth_verifier");
                Verifier verifier = new Verifier(oauthVerifier);
                Token accessToken = this.getService(provider, request, isAuthentication).getAccessToken(requestToken, verifier);
                token = new OAuthToken(this.config.getClientId(), accessToken.getToken(), accessToken.getSecret(), 3);
                request.setAttribute(this.config.getClientId(), (Object)token);
                this.config.getOAuthTokenManager().saveToken(token, request, response);
                return this.getUserDetails(provider, request, includeExtendedData);
            }
            this.log.warn("token was null or not in UNAUTHORIZED state:{}", token == null ? null : Integer.valueOf(token.getState()));
            return null;
        }
        catch (Exception e) {
            IOException ex = new IOException("Failed requesting access code");
            ex.initCause(e);
            throw ex;
        }
    }
}

