/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.auth.oauth.impl.oauth2;

import com.adobe.granite.auth.oauth.Provider;
import com.adobe.granite.auth.oauth.impl.helper.OAuthHelper;
import com.adobe.granite.auth.oauth.impl.helper.OAuthToken;
import com.adobe.granite.auth.oauth.impl.helper.OAuthUser;
import com.adobe.granite.auth.oauth.impl.helper.ProviderConfig;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.scribe.model.Token;
import org.scribe.model.Verifier;
import org.scribe.oauth.OAuthService;
import org.scribe.utils.OAuthEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Oauth2Helper
extends OAuthHelper {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public Oauth2Helper(ProviderConfig config) {
        super(config);
    }

    public void requestAuthorization(Provider provider, HttpServletRequest request, HttpServletResponse response, String state, boolean isAuthentication) throws IOException {
        try {
            OAuthService service = this.getService(provider, request, isAuthentication);
            String redirectUrl = service.getAuthorizationUrl(null);
            OAuthToken token = this.config.getOAuthTokenManager().getToken(this.config.getClientId(), request);
            if (token == null || !token.isAuthentic()) {
                token = new OAuthToken(this.config.getClientId(), "", "", 1);
            }
            if (state != null && state.length() > 0) {
                token.setAttribute("state", state);
            }
            request.setAttribute(this.config.getClientId(), (Object)token);
            this.config.getOAuthTokenManager().saveToken(token, request, response);
            String stateParameter = request.getParameter("state");
            if (stateParameter != null && stateParameter.length() > 0) {
                redirectUrl = redirectUrl + "&state=" + OAuthEncoder.encode((String)stateParameter);
            }
            response.sendRedirect(redirectUrl);
        }
        catch (Exception e) {
            IOException ex = new IOException("Failed requesting authorization");
            ex.initCause(e);
            throw ex;
        }
    }

    public OAuthUser requestAccessCode(Provider provider, HttpServletRequest request, HttpServletResponse response, boolean isAuthentication, boolean includeExtendedDetails) throws IOException {
        OAuthToken token = this.config.getOAuthTokenManager().getToken(this.config.getClientId(), request);
        if (token != null && (token.isAuthentic() || token.getState() == 1)) {
            String oauthVerifier = request.getParameter("code");
            Verifier verifier = new Verifier(oauthVerifier);
            try {
                Token accessToken = this.getService(provider, request, isAuthentication).getAccessToken(null, verifier);
                token = new OAuthToken(this.config.getClientId(), accessToken.getToken(), accessToken.getSecret(), 3);
                request.setAttribute(this.config.getClientId(), (Object)token);
                this.config.getOAuthTokenManager().saveToken(token, request, response);
                return this.getUserDetails(provider, request, includeExtendedDetails);
            }
            catch (Exception e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
        }
        this.log.warn("token was null or not in UNAUTHORIZED state:{}", token == null ? null : Integer.valueOf(token.getState()));
        return null;
    }
}

