/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.auth.oauth.impl.servlet;

import com.adobe.granite.auth.oauth.OAuthManager;
import com.adobe.granite.auth.oauth.Provider;
import com.adobe.granite.auth.oauth.impl.helper.OAuthHelper;
import com.adobe.granite.auth.oauth.impl.helper.OAuthUser;
import com.adobe.granite.auth.oauth.impl.helper.ProviderConfigManager;
import com.adobe.granite.auth.oauth.impl.helper.RequestHelper;
import java.io.IOException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service(value={Servlet.class})
@Properties(value={@Property(name="service.description", value={"OAuth profile importing Servlet"}), @Property(name="sling.servlet.resourceTypes", value={"social/oauth/accesstoken"}), @Property(name="sling.servlet.methods", value={"GET"})})
public class OAuthAccessTokenServlet
extends SlingAllMethodsServlet {
    private Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String PARAM_CONFIG_ID = "configid";
    public static final String PROPERTY_OAUTH_ACCESSTOKEN_PATH = "oauth.accesstoken.path";
    private String repositoryId;
    @Reference
    private OAuthManager oauthManager;
    @Reference
    private ProviderConfigManager providerConfigManager;

    @Activate
    private void activate() {
    }

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        if (RequestHelper.isInitialCall((HttpServletRequest)request, false)) {
            this.requestAuthorization(request, response);
        } else if (RequestHelper.isAuthzCode((HttpServletRequest)request, false)) {
            this.requestAccessToken(request, response);
        } else {
            response.getWriter().println("Connected.");
        }
    }

    protected void requestAuthorization(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        String configId = request.getParameter(PARAM_CONFIG_ID);
        this.log.debug("requestAuthorization: configid is: {}", (Object)configId);
        String state = "";
        OAuthHelper helper = this.providerConfigManager.getHelper(configId);
        Provider provider = this.oauthManager.getProvider(configId);
        if (helper != null && provider != null) {
            helper.requestAuthorization((HttpServletRequest)request, (HttpServletResponse)response, provider, "", false);
        } else {
            this.log.error("requestAuthorization: invalid config: helper is {} provider is {} ", (Object)helper, (Object)provider);
        }
    }

    protected void requestAccessToken(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        String configId = RequestHelper.getConfigId((HttpServletRequest)request);
        OAuthHelper helper = this.providerConfigManager.getHelper(configId);
        Provider provider = this.oauthManager.getProvider(configId);
        if (helper != null && provider != null) {
            OAuthUser oauthUser = helper.requestAccessCode(provider, (HttpServletRequest)request, (HttpServletResponse)response, false, false);
            if (oauthUser != null) {
                ValueMap props = (ValueMap)request.getResource().adaptTo(ValueMap.class);
                String tokenStoragePath = null;
                try {
                    tokenStoragePath = (String)props.get(PROPERTY_OAUTH_ACCESSTOKEN_PATH, String.class);
                    Node tokenStorageNode = null;
                    if (tokenStoragePath != null && tokenStoragePath.length() > 0) {
                        tokenStorageNode = ((Session)request.getResourceResolver().adaptTo(Session.class)).getNode(tokenStoragePath);
                    } else {
                        this.log.debug("using request resource to store access token {}", (Object)request.getResource());
                        tokenStorageNode = (Node)request.getResource().adaptTo(Node.class);
                    }
                    tokenStoragePath = tokenStorageNode.getPath();
                    helper.storeAccessToken((HttpServletRequest)request, tokenStorageNode);
                }
                catch (RepositoryException e) {
                    this.log.error("could not store access token at:{}", (Object)tokenStoragePath);
                    throw new IOException("could not store access token.");
                }
            } else {
                this.log.error("requestAccessToken: could not retrieve user");
            }
        } else {
            this.log.error("requestAuthorization: invalid config: helper is {} provider is {} ", (Object)helper, (Object)provider);
        }
        RequestHelper.handleRedirectAfterAuthentication((HttpServletRequest)request, (HttpServletResponse)response);
    }

    protected void bindOauthManager(OAuthManager oAuthManager) {
        this.oauthManager = oAuthManager;
    }

    protected void unbindOauthManager(OAuthManager oAuthManager) {
        if (this.oauthManager == oAuthManager) {
            this.oauthManager = null;
        }
    }

    protected void bindProviderConfigManager(ProviderConfigManager providerConfigManager) {
        this.providerConfigManager = providerConfigManager;
    }

    protected void unbindProviderConfigManager(ProviderConfigManager providerConfigManager) {
        if (this.providerConfigManager == providerConfigManager) {
            this.providerConfigManager = null;
        }
    }
}

