/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.auth.oauth.impl.servlet;

import com.adobe.granite.auth.oauth.OAuthIdInUseException;
import com.adobe.granite.auth.oauth.OAuthManager;
import com.adobe.granite.auth.oauth.Provider;
import com.adobe.granite.auth.oauth.impl.helper.OAuthHelper;
import com.adobe.granite.auth.oauth.impl.helper.OAuthUser;
import com.adobe.granite.auth.oauth.impl.helper.ProviderConfigManager;
import com.adobe.granite.auth.oauth.impl.helper.RequestHelper;
import com.adobe.granite.crypto.CryptoSupport;
import java.io.IOException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.jcr.api.SlingRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service(value={Servlet.class})
@Properties(value={@Property(name="service.description", value={"OAuth profile importing Servlet"}), @Property(name="sling.servlet.resourceTypes", value={"social/oauth/connect"}), @Property(name="sling.servlet.methods", value={"GET"})})
public class OAuthProfileImportServlet
extends SlingAllMethodsServlet {
    private Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String PARAM_CONFIG_ID = "configid";
    private String repositoryId;
    @Reference
    private OAuthManager oauthManager;
    @Reference
    private SlingRepository repository;
    @Reference
    private CryptoSupport cryptoSupport;
    @Reference
    private ProviderConfigManager providerConfigManager;

    @Activate
    private void activate() throws Exception {
    }

    @Deactivate
    private void deactivate() throws Exception {
    }

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        if (RequestHelper.isInitialCall((HttpServletRequest)request, false)) {
            this.requestAuthorization(request, response);
        } else if (RequestHelper.isAuthzCode((HttpServletRequest)request, false)) {
            this.requestAccessToken(request, response);
        } else {
            response.getWriter().println("Connected.");
        }
    }

    protected void requestAuthorization(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        String configId = request.getParameter(PARAM_CONFIG_ID);
        this.log.debug("requestAuthorization: configid is: {}", (Object)configId);
        String state = "";
        OAuthHelper helper = this.providerConfigManager.getHelper(configId);
        Provider provider = this.oauthManager.getProvider(configId);
        if (helper != null && provider != null) {
            helper.requestAuthorization((HttpServletRequest)request, (HttpServletResponse)response, provider, "", false);
        } else {
            this.log.error("requestAuthorization: invalid config: helper is {} provider is {} ", (Object)helper, (Object)provider);
        }
    }

    protected void requestAccessToken(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        String configId = RequestHelper.getConfigId((HttpServletRequest)request);
        OAuthHelper helper = this.providerConfigManager.getHelper(configId);
        Provider provider = this.oauthManager.getProvider(configId);
        Object error = null;
        if (helper != null && provider != null) {
            OAuthUser oauthUser = helper.requestAccessCode(provider, (HttpServletRequest)request, (HttpServletResponse)response, false, true);
            this.updateUserDataAndRedirect(oauthUser, provider, helper, request, response);
        } else {
            this.log.error("requestAuthorization: invalid config: helper is {} provider is {} ", (Object)helper, (Object)provider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateUserDataAndRedirect(OAuthUser oauthUser, Provider provider, OAuthHelper helper, SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        String error = null;
        if (oauthUser != null) {
            Session s = null;
            try {
                s = this.repository.loginAdministrative(null);
                User user = provider.getCurrentUser(request);
                user = helper.createOrUpdateCRXUser(s, this.cryptoSupport, provider, (HttpServletRequest)request, oauthUser, user);
                if (user != null) {
                    helper.setAuthorizedId((HttpServletRequest)request, (HttpServletResponse)response, user.getID());
                }
                error = "User " + oauthUser.getId() + " cannot be created/updated.";
            }
            catch (RepositoryException e) {
                this.log.error("requestAccessToken: failed to assign user profile data", (Throwable)e);
                IOException ex = new IOException("Failed requesting access token");
                ex.initCause(e);
                throw ex;
            }
            catch (OAuthIdInUseException e) {
                error = e.getMessage();
            }
            finally {
                if (s != null && s.isLive()) {
                    s.logout();
                }
            }
        } else {
            this.log.error("requestAccessToken: could not retrieve user");
        }
        if (error != null) {
            request.setAttribute("com.adobe.granite.auth.oauth.OAuthImportError", (Object)error);
        } else {
            RequestHelper.handleRedirectAfterAuthentication((HttpServletRequest)request, (HttpServletResponse)response);
        }
    }

    protected void bindOauthManager(OAuthManager oAuthManager) {
        this.oauthManager = oAuthManager;
    }

    protected void unbindOauthManager(OAuthManager oAuthManager) {
        if (this.oauthManager == oAuthManager) {
            this.oauthManager = null;
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected void bindCryptoSupport(CryptoSupport cryptoSupport) {
        this.cryptoSupport = cryptoSupport;
    }

    protected void unbindCryptoSupport(CryptoSupport cryptoSupport) {
        if (this.cryptoSupport == cryptoSupport) {
            this.cryptoSupport = null;
        }
    }

    protected void bindProviderConfigManager(ProviderConfigManager providerConfigManager) {
        this.providerConfigManager = providerConfigManager;
    }

    protected void unbindProviderConfigManager(ProviderConfigManager providerConfigManager) {
        if (this.providerConfigManager == providerConfigManager) {
            this.providerConfigManager = null;
        }
    }
}

