/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.auth.saml;

import com.adobe.granite.auth.saml.binding.MessageContext;
import com.adobe.granite.auth.saml.binding.PostBinding;
import com.adobe.granite.auth.saml.binding.RequestBinding;
import com.adobe.granite.auth.saml.binding.ResponseBinding;
import com.adobe.granite.auth.saml.configuration.IdpConfiguration;
import com.adobe.granite.auth.saml.configuration.SpConfiguration;
import com.adobe.granite.auth.saml.impl.KeyProvider;
import com.adobe.granite.auth.saml.impl.SlingKeyProvider;
import com.adobe.granite.auth.saml.model.Assertion;
import com.adobe.granite.auth.saml.model.Attribute;
import com.adobe.granite.auth.saml.model.AuthnRequest;
import com.adobe.granite.auth.saml.model.Issuer;
import com.adobe.granite.auth.saml.model.NameIdPolicy;
import com.adobe.granite.auth.saml.model.Response;
import com.adobe.granite.crypto.CryptoException;
import com.adobe.granite.crypto.CryptoSupport;
import com.day.crx.security.token.TokenUtil;
import java.io.IOException;
import java.security.Key;
import java.util.Calendar;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.jcr.AccessDeniedException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.ValueFactory;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.auth.core.spi.AbstractAuthenticationHandler;
import org.apache.sling.auth.core.spi.AuthenticationHandler;
import org.apache.sling.auth.core.spi.AuthenticationInfo;
import org.apache.sling.auth.core.spi.DefaultAuthenticationFeedbackHandler;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, immediate=true, label="%granite.auth.saml.label", description="%granite.auth.saml.description", policy=ConfigurationPolicy.REQUIRE)
@Service(value={AuthenticationHandler.class})
@Properties(value={@Property(name="service.description", value={"Adobe Granite SAML Authentication Handler"}, propertyPrivate=true), @Property(name="service.vendor", value={"Adobe"}, propertyPrivate=true), @Property(name="path", value={"/"}, cardinality=100, propertyPrivate=false), @Property(name="service.ranking", intValue={5002}, propertyPrivate=false), @Property(name="authtype", value={"SAML"}, propertyPrivate=true)})
public class SamlAuthenticationHandler
extends AbstractAuthenticationHandler
implements AuthenticationHandler {
    private static final String DEFAULT_IDP_URL = "";
    private static final boolean DEFAULT_IDP_HTTP_REDIRECT = false;
    private static final String DEFAULT_SP_ENTITY_ID = "";
    private static final String DEFAULT_DEFAULT_REDIRECT_URL = "/";
    private static final boolean DEFAULT_USE_ENCRYPTION = true;
    private static final String DEFAULT_USER_ID_ATTRIBUTE = "uid";
    private static final boolean DEFAULT_CREATE_USER = true;
    private static final boolean DEFAULT_ADD_GROUP_MEMBERSHIPS = true;
    private static final String DEFAULT_GROUPS_ATTRIBUTE = "groupMembership";
    private static final String DEFAULT_NAMEIDFORMAT_ATTRIBUTE = "urn:oasis:names:tc:SAML:2.0:nameid-format:transient";
    @Property(value={""})
    public static final String OSGI_PROPERTY_IDP_URL = "idpUrl";
    @Property(boolValue={false})
    public static final String OSGI_PROPERTY_IDP_HTTP_REDIRECT = "idpHttpRedirect";
    @Property(value={""})
    public static final String OSGI_PROPERTY_SP_ENTITY_ID = "serviceProviderEntityId";
    @Property(value={"/"})
    public static final String OSGI_PROPERTY_DEFAULT_REDIRECT_URL = "defaultRedirectUrl";
    @Property(value={"uid"})
    public static final String OSGI_PROPERTY_USER_ID_ATTRIBUTE = "userIDAttribute";
    @Property(boolValue={true})
    public static final String OSGI_PROPERTY_USE_ENCRYPTION = "useEncryption";
    @Property(boolValue={true})
    public static final String OSGI_PROPERTY_CREATE_USER = "createUser";
    @Property(boolValue={true})
    public static final String OSGI_PROPERTY_ADD_GROUP_MEMBERSHIPS = "addGroupMemberships";
    @Property(value={"groupMembership"})
    public static final String OSGI_PROPERTY_GROUPS_ATTRIBUTE = "groupMembershipAttribute";
    @Property(value={"urn:oasis:names:tc:SAML:2.0:nameid-format:transient"})
    public static final String OSGI_PROPERTY_NAMEIDFORMAT = "nameIdFormat";
    static final String AUTH_TYPE = "SAML";
    private static final String LOGIN_SUFFIX = "/saml_login";
    private static final String REQUEST_PATH_COOKIE = "saml_request_path";
    private static final int COOKIE_MAX_AGE = 300;
    private static final String PROPERTY_SAML_RESPONSE = "samlResponse";
    @Reference
    private SlingRepository repository;
    @Reference
    private CryptoSupport cryptoSupport;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    private KeyProvider keyProvider;
    private IdpConfiguration idpConfiguration;
    private boolean idpHttpRedirect;
    private SpConfiguration spConfiguration;
    private String defaultRedirectUrl;
    private String userIDAttribute;
    private String groupsAttribute;
    private boolean createUser;
    private boolean addGroupMemberships;
    private RequestBinding requestBinding;
    private ResponseBinding responseBinding;
    private String nameIdFormat;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public SamlAuthenticationHandler() {
        this(new SlingKeyProvider());
    }

    public SamlAuthenticationHandler(KeyProvider keyProvider) {
        PostBinding postBinding = new PostBinding();
        this.requestBinding = postBinding;
        this.responseBinding = postBinding;
        this.keyProvider = keyProvider;
        this.idpConfiguration = new IdpConfiguration();
        this.spConfiguration = new SpConfiguration(this.keyProvider);
    }

    @Activate
    public void activate(ComponentContext context) {
        this.idpConfiguration.setIdpPostUrl(OsgiUtil.toString(context.getProperties().get(OSGI_PROPERTY_IDP_URL), (String)""));
        this.idpHttpRedirect = OsgiUtil.toBoolean(context.getProperties().get(OSGI_PROPERTY_IDP_HTTP_REDIRECT), (boolean)false);
        this.spConfiguration.setEntityId(OsgiUtil.toString(context.getProperties().get(OSGI_PROPERTY_SP_ENTITY_ID), (String)""));
        this.spConfiguration.setUseEncryption(OsgiUtil.toBoolean(context.getProperties().get(OSGI_PROPERTY_USE_ENCRYPTION), (boolean)true));
        this.defaultRedirectUrl = OsgiUtil.toString(context.getProperties().get(OSGI_PROPERTY_DEFAULT_REDIRECT_URL), (String)DEFAULT_DEFAULT_REDIRECT_URL);
        this.userIDAttribute = OsgiUtil.toString(context.getProperties().get(OSGI_PROPERTY_USER_ID_ATTRIBUTE), (String)DEFAULT_USER_ID_ATTRIBUTE);
        this.createUser = OsgiUtil.toBoolean(context.getProperties().get(OSGI_PROPERTY_CREATE_USER), (boolean)true);
        this.addGroupMemberships = OsgiUtil.toBoolean(context.getProperties().get(OSGI_PROPERTY_ADD_GROUP_MEMBERSHIPS), (boolean)true);
        this.groupsAttribute = OsgiUtil.toString(context.getProperties().get(OSGI_PROPERTY_GROUPS_ATTRIBUTE), (String)DEFAULT_GROUPS_ATTRIBUTE);
        this.nameIdFormat = OsgiUtil.toString(context.getProperties().get(OSGI_PROPERTY_NAMEIDFORMAT), (String)DEFAULT_NAMEIDFORMAT_ATTRIBUTE);
    }

    public void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
        if (this.keyProvider instanceof SlingKeyProvider) {
            ((SlingKeyProvider)this.keyProvider).setResourceResolverFactory(resourceResolverFactory);
        }
        this.idpConfiguration.setResourceResolverFactory(resourceResolverFactory);
    }

    public void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
            if (this.keyProvider instanceof SlingKeyProvider) {
                ((SlingKeyProvider)this.keyProvider).setResourceResolverFactory(null);
            }
            this.idpConfiguration.setResourceResolverFactory(null);
        }
    }

    public AuthenticationInfo extractCredentials(HttpServletRequest request, HttpServletResponse response) {
        if (this.isDisabled()) {
            return null;
        }
        if (request.getPathInfo().endsWith(LOGIN_SUFFIX)) {
            return this.handleLogin(request, response);
        }
        return null;
    }

    public boolean requestCredentials(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Cookie[] cookies = request.getCookies();
        boolean requestPathCookieSet = false;
        if (null != cookies) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(REQUEST_PATH_COOKIE) || "".equals(cookie.getValue())) continue;
                requestPathCookieSet = true;
            }
        }
        String queryString = request.getQueryString();
        String requestPath = request.getRequestURI();
        if (!requestPathCookieSet) {
            Cookie cookie = null == queryString ? new Cookie(REQUEST_PATH_COOKIE, requestPath) : new Cookie(REQUEST_PATH_COOKIE, requestPath + queryString);
            cookie.setMaxAge(300);
            cookie.setPath(DEFAULT_DEFAULT_REDIRECT_URL);
            response.addCookie(cookie);
        }
        if (this.idpHttpRedirect) {
            response.sendRedirect(this.idpConfiguration.getIdpPostUrl());
        } else {
            try {
                MessageContext messageContext = new MessageContext(this.idpConfiguration, this.spConfiguration);
                messageContext.setMessage(this.createAuthnRequest());
                Key privateKey = this.spConfiguration.getDecryptionKey();
                if (privateKey == null) {
                    this.log.warn("Private key of SP not provided: Cannot sign Authn request.");
                }
                this.requestBinding.send(messageContext, response, privateKey);
            }
            catch (IOException e) {
                this.log.warn("Could not send authentication request message", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return true;
    }

    public void dropCredentials(HttpServletRequest request, HttpServletResponse response) throws IOException {
    }

    private void clearRequestPathCookie(HttpServletRequest request, HttpServletResponse response) {
        Cookie[] cookies = request.getCookies();
        if (null != cookies) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(REQUEST_PATH_COOKIE)) continue;
                cookie.setValue("");
            }
        }
        Cookie cookie = new Cookie(REQUEST_PATH_COOKIE, "");
        cookie.setMaxAge(1);
        cookie.setPath(DEFAULT_DEFAULT_REDIRECT_URL);
        response.addCookie(cookie);
    }

    public void authenticationFailed(HttpServletRequest request, HttpServletResponse response, AuthenticationInfo authInfo) {
        this.clearRequestPathCookie(request, response);
    }

    public boolean authenticationSucceeded(HttpServletRequest request, HttpServletResponse response, AuthenticationInfo authInfo) {
        if (request.getPathInfo().endsWith(LOGIN_SUFFIX)) {
            try {
                String redirectUrl = this.defaultRedirectUrl;
                Cookie[] cookies = request.getCookies();
                if (null != cookies) {
                    for (Cookie cookie : cookies) {
                        if (!REQUEST_PATH_COOKIE.equals(cookie.getName())) continue;
                        redirectUrl = cookie.getValue();
                        break;
                    }
                }
                this.clearRequestPathCookie(request, response);
                response.sendRedirect(redirectUrl);
            }
            catch (IOException e) {
                this.log.error("Could not read request.", (Throwable)e);
                return false;
            }
            return true;
        }
        return DefaultAuthenticationFeedbackHandler.handleRedirect((HttpServletRequest)request, (HttpServletResponse)response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AuthenticationInfo handleLogin(HttpServletRequest request, HttpServletResponse response) {
        MessageContext messageContext = new MessageContext(this.idpConfiguration, this.spConfiguration);
        MessageContext responseContext = null;
        try {
            responseContext = this.responseBinding.receive(messageContext, request);
        }
        catch (IOException e) {
            this.log.error("Fatal failure while parsing the request.", (Throwable)e);
        }
        if (responseContext == null) {
            this.log.error("SAML response parameter was not provided or invalid.");
            return null;
        }
        Response samlResponse = (Response)responseContext.getMessage();
        List<Assertion> assertions = samlResponse.getAssertions();
        if (assertions.size() > 0) {
            Assertion assertion = assertions.get(0);
            if (!assertion.isValid(this.spConfiguration)) {
                this.log.info("Login failed. SAML token invalid.");
                return AuthenticationInfo.FAIL_AUTH;
            }
            Authorizable authorizable = null;
            Session adminSession = null;
            AuthenticationInfo authInfo = new AuthenticationInfo(AUTH_TYPE);
            try {
                if (!assertion.getAttributes().containsKey(this.userIDAttribute)) {
                    this.log.error("Could not extract UserID from assertion.");
                    AuthenticationInfo authenticationInfo = AuthenticationInfo.FAIL_AUTH;
                    return authenticationInfo;
                }
                String username = assertion.getAttributes().get(this.userIDAttribute).getValue().toString();
                adminSession = this.repository.loginAdministrative(null);
                authorizable = this.createOrUpdateCRXUser(adminSession, username, samlResponse.getRawMessage());
                if (authorizable != null && this.addGroupMemberships && assertion.getAttributes().containsKey(this.groupsAttribute)) {
                    this.addUserToGroups(adminSession, authorizable, assertion.getAttributes().get(this.groupsAttribute));
                }
                adminSession.save();
                authInfo = TokenUtil.createCredentials((HttpServletRequest)request, (HttpServletResponse)response, (SlingRepository)this.repository, (String)username, (boolean)true);
            }
            catch (RepositoryException e) {
                this.log.error("User synchronization failed: Could not access repository.", (Throwable)e);
                authInfo = AuthenticationInfo.FAIL_AUTH;
            }
            finally {
                if (null != adminSession) {
                    adminSession.logout();
                }
            }
            if (authorizable == null) {
                return AuthenticationInfo.FAIL_AUTH;
            }
            authInfo.put("$$auth.info.login$$", new Object());
            return authInfo;
        }
        return null;
    }

    private void addUserToGroups(Session adminSession, Authorizable user, Attribute groupsAttribute) {
        try {
            UserManager um = ((JackrabbitSession)adminSession).getUserManager();
            if (um == null) {
                this.log.error("Group synchronization failed: Could not get user manager.");
                return;
            }
            for (Object groupId : groupsAttribute.getListValue()) {
                Group group = (Group)um.getAuthorizable((String)groupId);
                if (group == null || group.isMember(user)) continue;
                group.addMember(user);
            }
        }
        catch (AccessDeniedException e) {
            this.log.error("Group synchronization failed: Access denied.", (Throwable)e);
        }
        catch (RepositoryException e) {
            this.log.error("Group synchronization failed: Could not access repository.", (Throwable)e);
        }
    }

    private Authorizable createOrUpdateCRXUser(Session adminSession, String username, String samlResponseParameter) {
        try {
            UserManager um = ((JackrabbitSession)adminSession).getUserManager();
            Authorizable authorizable = um.getAuthorizable(username);
            if (authorizable == null && this.createUser) {
                byte[] key = new byte[16];
                try {
                    this.cryptoSupport.nextRandomBytes(key);
                }
                catch (CryptoException e) {
                    this.log.error("cryptoSupport.nextRandomBytes failed", (Throwable)e);
                    new Random().nextBytes(key);
                }
                authorizable = um.createUser(username, StringUtils.newStringUtf8((byte[])Base64.encodeBase64((byte[])key)));
            }
            if (authorizable != null && !authorizable.isGroup()) {
                ValueFactory vf = adminSession.getValueFactory();
                try {
                    authorizable.setProperty(PROPERTY_SAML_RESPONSE, vf.createValue(this.cryptoSupport.protect(samlResponseParameter)));
                }
                catch (CryptoException e) {
                    this.log.error("Encryption of samlResponse failed.", (Throwable)e);
                }
            }
            return authorizable;
        }
        catch (AccessDeniedException e) {
            this.log.error("User synchronization failed: Could not get user manager.", (Throwable)e);
        }
        catch (RepositoryException e) {
            this.log.error("User synchronization failed: Could not access repository.", (Throwable)e);
        }
        return null;
    }

    private AuthnRequest createAuthnRequest() {
        AuthnRequest authnRequest = new AuthnRequest();
        authnRequest.setId("_" + UUID.randomUUID().toString());
        authnRequest.setVersion("2.0");
        authnRequest.setDestination(this.idpConfiguration.getIdpPostUrl());
        authnRequest.setProtocolBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        authnRequest.setIssueInstant(Calendar.getInstance());
        Issuer issuer = new Issuer(this.spConfiguration.getEntityId());
        authnRequest.setIssuer(issuer);
        NameIdPolicy nameIdPolicy = new NameIdPolicy();
        nameIdPolicy.setFormat(this.nameIdFormat);
        nameIdPolicy.setAllowCreate(true);
        authnRequest.setNameIdPolicy(nameIdPolicy);
        return authnRequest;
    }

    private boolean isDisabled() {
        return "".equals(this.idpConfiguration.getIdpPostUrl()) || "".equals(this.spConfiguration.getEntityId());
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected void bindCryptoSupport(CryptoSupport cryptoSupport) {
        this.cryptoSupport = cryptoSupport;
    }

    protected void unbindCryptoSupport(CryptoSupport cryptoSupport) {
        if (this.cryptoSupport == cryptoSupport) {
            this.cryptoSupport = null;
        }
    }
}

