/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.auth.saml.binding;

import com.adobe.granite.auth.saml.binding.MessageContext;
import com.adobe.granite.auth.saml.binding.RequestBinding;
import com.adobe.granite.auth.saml.binding.ResponseBinding;
import com.adobe.granite.auth.saml.impl.SamlReader;
import com.adobe.granite.auth.saml.impl.SamlReaderException;
import com.adobe.granite.auth.saml.impl.SamlWriter;
import com.adobe.granite.auth.saml.impl.SamlWriterException;
import com.adobe.granite.auth.saml.model.AuthnRequest;
import com.adobe.granite.auth.saml.model.Message;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.Key;
import java.security.PublicKey;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.xml.security.exceptions.Base64DecodingException;
import org.apache.xml.security.utils.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostBinding
implements RequestBinding,
ResponseBinding {
    public static final String SAML_RESPONSE_PARAM = "SAMLResponse";
    public static final String SAML_REQUEST_PARAM = "SAMLRequest";
    public static final String RELAY_STATE_PARAM = "RelayState";
    private SamlWriter samlWriter;
    private SamlReader samlReader;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public PostBinding() {
        this.samlWriter = new SamlWriter();
        this.samlReader = new SamlReader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageContext receive(MessageContext messageContext, HttpServletRequest httpRequest) throws IOException {
        String samlResponse = httpRequest.getParameter(SAML_RESPONSE_PARAM);
        if (null == samlResponse || samlResponse.length() == 0) {
            return null;
        }
        ByteArrayInputStream input = null;
        try {
            byte[] decodedResponse = Base64.decode((String)samlResponse);
            input = new ByteArrayInputStream(decodedResponse);
            PublicKey idpPublicKey = messageContext.getIdpConfiguration().getCertificate().getPublicKey();
            Key decryptionKey = null;
            if (messageContext.getSpConfiguration().getUseEncryption()) {
                decryptionKey = messageContext.getSpConfiguration().getDecryptionKey();
            }
            Message response = this.samlReader.read(input, decryptionKey, idpPublicKey);
            messageContext.setMessage(response);
            String relayState = httpRequest.getParameter(RELAY_STATE_PARAM);
            if (null != relayState) {
                messageContext.setRelayState(relayState.getBytes());
            }
            MessageContext messageContext2 = messageContext;
            return messageContext2;
        }
        catch (Base64DecodingException e) {
            MessageContext messageContext3 = null;
            return messageContext3;
        }
        catch (SamlReaderException e) {
            MessageContext messageContext4 = null;
            return messageContext4;
        }
        finally {
            if (null != input) {
                try {
                    input.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(MessageContext messageContext, HttpServletResponse httpResponse, Key privateKey) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            Message message = messageContext.getMessage();
            if (!(message instanceof AuthnRequest)) {
                throw new RuntimeException("Messages of type " + message.getClass().getName() + " are not currently supported.");
            }
            this.samlWriter.write(message, out, privateKey);
            String encodedRequest = Base64.encode((byte[])out.toByteArray());
            StringBuilder builder = new StringBuilder();
            builder.append("<!DOCTYPE html PUBLIC '-//W3C//DTD XHTML 1.0 Transitional//EN' 'http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd'>");
            builder.append("<html xmlns='http://www.w3.org/1999/xhtml' xml:lang='en' lang='en'>");
            builder.append("<head>");
            builder.append("<meta http-equiv='content-type' content='text/html; charset=utf-8' />");
            builder.append("<title>POST data</title>");
            builder.append("</head>");
            builder.append("<body onload='document.forms[0].submit()'>");
            builder.append("<noscript>");
            builder.append("<p><strong>Note:</strong> Since your browser does not support JavaScript, you must press the button below once to proceed.</p>");
            builder.append("</noscript>");
            builder.append("<form method='post' action='");
            builder.append(messageContext.getIdpConfiguration().getIdpPostUrl());
            builder.append("'>");
            byte[] relayState = messageContext.getRelayState();
            if (null != relayState && 0 < relayState.length) {
                builder.append("<input type='hidden' name='");
                builder.append(RELAY_STATE_PARAM);
                builder.append("' value='");
                builder.append(new String(relayState));
                builder.append("' />");
            }
            builder.append("<input type='hidden' name='");
            builder.append(SAML_REQUEST_PARAM);
            builder.append("' value='");
            builder.append(encodedRequest);
            builder.append("' />");
            builder.append("<noscript><input type='submit' value='Submit' /></noscript>");
            builder.append("</form>");
            builder.append("</body>");
            builder.append("</html>");
            httpResponse.setContentType("text/html");
            httpResponse.getOutputStream().print(builder.toString());
        }
        catch (SamlWriterException e) {
            this.log.error("Fatal error while sending Authn request.", (Throwable)e);
            httpResponse.sendError(500, "Internal server error, please contact your administrator");
        }
        finally {
            try {
                out.close();
            }
            catch (IOException e) {}
        }
    }
}

