/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.auth.saml.configuration;

import java.io.IOException;
import java.io.InputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ValueMap;

public class IdpConfiguration {
    private String idpPostUrl;
    private String KEY_ROOT = "/etc/key/saml";
    private String IDP_CERT = "idp_cert";
    private ResourceResolverFactory resourceResolverFactory;

    public void setResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    public void setIdpPostUrl(String idpPostUrl) {
        this.idpPostUrl = idpPostUrl;
    }

    public String getIdpPostUrl() {
        return this.idpPostUrl;
    }

    public Certificate getCertificate() {
        ResourceResolver resourceResolver = null;
        InputStream inputStream = null;
        try {
            resourceResolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
            Resource keyRoot = resourceResolver.getResource(this.KEY_ROOT);
            ValueMap valueMap = (ValueMap)keyRoot.adaptTo(ValueMap.class);
            inputStream = (InputStream)valueMap.get(this.IDP_CERT, InputStream.class);
            if (null == inputStream) {
                throw new RuntimeException("Public key has not been configured - please contact your administrator");
            }
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            Certificate certificate = certFactory.generateCertificate(inputStream);
            return certificate;
        }
        catch (LoginException e) {
            throw new RuntimeException("Unable to retrieve admin resource resolver", e);
        }
        catch (CertificateException e) {
            throw new RuntimeException("Error reading certificate", e);
        }
        finally {
            if (null != inputStream) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {}
            }
            if (null != resourceResolver) {
                resourceResolver.close();
            }
        }
    }
}

