/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.auth.saml.impl;

import com.adobe.granite.auth.saml.impl.SamlReaderException;
import com.adobe.granite.auth.saml.model.Assertion;
import com.adobe.granite.auth.saml.model.Attribute;
import com.adobe.granite.auth.saml.model.Issuer;
import com.adobe.granite.auth.saml.model.Message;
import com.adobe.granite.auth.saml.model.Response;
import com.adobe.granite.auth.saml.model.Status;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.security.Key;
import java.util.Calendar;
import java.util.Locale;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.xml.security.Init;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.joda.time.DateTimeZone;
import org.joda.time.format.ISODateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SamlReader {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public Message read(InputStream inputStream, Key decryptionKey, Key verificationKey) throws SamlReaderException, IOException {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        builderFactory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            Document doc = builder.parse(inputStream);
            if (decryptionKey != null) {
                doc = this.decryptResponse(doc, decryptionKey);
            }
            Response msg = this.parse(doc, verificationKey);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            StringWriter sw = new StringWriter();
            transformer.transform(new DOMSource(doc), new StreamResult(sw));
            msg.setRawMessage(sw.toString());
            return msg;
        }
        catch (ParserConfigurationException e) {
            throw new SamlReaderException("Unable to parse document from stream", e);
        }
        catch (SAXException e) {
            throw new SamlReaderException("Unable to parse document from stream", e);
        }
        catch (TransformerConfigurationException e) {
            throw new SamlReaderException("Unable to parse document from stream", e);
        }
        catch (TransformerException e) {
            throw new SamlReaderException("Unable to parse document from stream", e);
        }
    }

    protected Response parse(Document document, Key verificationKey) {
        Element issuerElement;
        Element responseElement = this.getChildElement(document, "Response");
        Response response = new Response();
        response.setId(responseElement.getAttribute("ID"));
        response.setVersion(responseElement.getAttribute("Version"));
        response.setIssueInstant(this.getDateAttr(responseElement, "IssueInstant"));
        Element statusElement = this.getChildElement(responseElement, "Status");
        if (null != statusElement) {
            response.setStatus(this.parseStatus(statusElement));
        }
        if (null != (issuerElement = this.getChildElement(responseElement, "Issuer"))) {
            response.setIssuer(this.parseIssuer(issuerElement));
        }
        response.setInResponseTo(responseElement.getAttribute("InResponseTo"));
        response.setDestination(responseElement.getAttribute("Destination"));
        NodeList nodeList = responseElement.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "Assertion");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Assertion assertion = this.parseAssertion((Element)nodeList.item(i));
            assertion.setSignatureValid(this.verifySignatures((Element)nodeList.item(i), verificationKey));
            response.addAssertion(assertion);
        }
        return response;
    }

    private boolean verifySignatures(Element assertionElement, Key publicKey) {
        if (publicKey != null) {
            NodeList signatureNodes = assertionElement.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
            if (signatureNodes.getLength() == 0) {
                this.log.warn("Received SAML assertion without signature element.");
                return false;
            }
            for (int j = 0; j < signatureNodes.getLength(); ++j) {
                try {
                    DOMValidateContext valContext = new DOMValidateContext(publicKey, signatureNodes.item(j));
                    XMLSignatureFactory sigFactory = XMLSignatureFactory.getInstance("DOM");
                    XMLSignature signature = sigFactory.unmarshalXMLSignature(valContext);
                    if (signature.validate(valContext)) continue;
                    return false;
                }
                catch (MarshalException e) {
                    this.log.error("Could not unmarshal XML signature.", (Throwable)e);
                    return false;
                }
                catch (XMLSignatureException e) {
                    this.log.error("Failed validating signature.", (Throwable)e);
                    return false;
                }
            }
        } else {
            this.log.warn("Could not verify signatures. Public key of IdP not provided.");
            return false;
        }
        return true;
    }

    protected Document decryptResponse(Document document, Key decryptionKey) {
        NodeList encryptedAssertions = document.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "EncryptedAssertion");
        if (0 >= encryptedAssertions.getLength()) {
            throw new RuntimeException("No EncryptedAssertion element was found");
        }
        for (int i = 0; i < encryptedAssertions.getLength(); ++i) {
            this.decryptAssertion((Element)encryptedAssertions.item(i), decryptionKey);
        }
        return document;
    }

    protected void decryptAssertion(Element encryptedAssertion, Key decryptionKey) {
        try {
            XMLCipher xmlCipher = XMLCipher.getInstance();
            xmlCipher.init(2, null);
            xmlCipher.setKEK(decryptionKey);
            xmlCipher.doFinal(encryptedAssertion.getOwnerDocument(), encryptedAssertion, true);
            Element parentElement = (Element)encryptedAssertion.getParentNode();
            Element assertion = (Element)encryptedAssertion.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "Assertion").item(0);
            parentElement.removeChild(encryptedAssertion);
            parentElement.appendChild(assertion);
        }
        catch (XMLEncryptionException e) {
            throw new RuntimeException("Error decrypting response", e);
        }
        catch (Exception e) {
            throw new RuntimeException("Error decrypting response", e);
        }
    }

    protected Issuer parseIssuer(Element issuerElement) {
        String value = issuerElement.getTextContent();
        if (null == value) {
            return null;
        }
        return new Issuer(value.trim());
    }

    protected Assertion parseAssertion(Element assertionElement) {
        Element audienceRestrictionElement;
        Element conditionsElement;
        Assertion assertion = new Assertion();
        Element attributeStatement = this.getChildElement(assertionElement, "AttributeStatement");
        if (null != attributeStatement) {
            NodeList nodeList = attributeStatement.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "Attribute");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                assertion.addAttribute(this.parseAttribute((Element)nodeList.item(i)));
            }
        }
        if ((conditionsElement = this.getChildElement(assertionElement, "Conditions")).hasAttribute("NotBefore")) {
            assertion.setNotBefore(this.getDateAttr(conditionsElement, "NotBefore"));
        }
        if (conditionsElement.hasAttribute("NotOnOrAfter")) {
            assertion.setNotOnOrAfter(this.getDateAttr(conditionsElement, "NotOnOrAfter"));
        }
        if (null != (audienceRestrictionElement = this.getChildElement(conditionsElement, "AudienceRestriction"))) {
            NodeList nodeList = audienceRestrictionElement.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "Audience");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                assertion.addAudienceRestriction(nodeList.item(i).getTextContent());
            }
        }
        return assertion;
    }

    protected Attribute parseAttribute(Element attributeElement) {
        Attribute attribute = new Attribute();
        attribute.setName(attributeElement.getAttribute("Name"));
        attribute.setNameFormat(attributeElement.getAttribute("NameFormat"));
        NodeList valueElements = attributeElement.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "AttributeValue");
        for (int i = 0; i < valueElements.getLength(); ++i) {
            Element valueElement = (Element)valueElements.item(i);
            attribute.addAttributeValue(valueElement.getTextContent().trim());
        }
        return attribute;
    }

    protected Status parseStatus(Element statusElement) {
        Status status = new Status();
        Element statusCodeElement = this.getChildElement(statusElement, "StatusCode");
        if (null != statusCodeElement) {
            status.setStatusCode(statusCodeElement.getAttribute("Value"));
            return status;
        }
        return null;
    }

    protected Calendar getDateAttr(Element element, String attrName) {
        String value = element.getAttribute(attrName);
        if (null != value && !"".equals(value)) {
            Calendar calendar = ISODateTimeFormat.dateTimeParser().withZone(DateTimeZone.forOffsetHours((int)0)).parseDateTime(value).toCalendar(Locale.getDefault());
            return calendar;
        }
        return null;
    }

    protected Element getChildElement(Node node, String name) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node child = nodeList.item(i);
            if (1 != child.getNodeType() || !child.getLocalName().equals(name)) continue;
            return (Element)child;
        }
        return null;
    }

    static {
        Init.init();
    }
}

