/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.auth.saml.model;

import com.adobe.granite.auth.saml.configuration.SpConfiguration;
import com.adobe.granite.auth.saml.model.Attribute;
import com.adobe.granite.auth.saml.model.Issuer;
import com.adobe.granite.auth.saml.model.Subject;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Assertion {
    private String version;
    private Calendar issueInstant;
    private String id;
    private Issuer issuer;
    private Subject subject;
    private Calendar notBefore;
    private Calendar notOnOrAfter;
    private LinkedList<String> audienceRestrictions;
    private boolean signatureValid;
    private final int CLOCK_SYNC_TOLERANCE = 60;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private Map<String, Attribute> attributeStatements;

    public void addAttribute(Attribute attribute) {
        if (null == this.attributeStatements) {
            this.attributeStatements = new HashMap<String, Attribute>();
        }
        this.attributeStatements.put(attribute.getName(), attribute);
    }

    public Map<String, Attribute> getAttributes() {
        if (null == this.attributeStatements) {
            return Collections.emptyMap();
        }
        return this.attributeStatements;
    }

    public boolean isValid(SpConfiguration spConfiguration) {
        Calendar now = Calendar.getInstance();
        now.add(13, 60);
        if (this.notBefore != null && now.before(this.notBefore)) {
            this.log.debug("Invalid Assertion: notBefore violated (" + now.toString() + " < " + this.notBefore.toString() + ").");
            return false;
        }
        if (this.notOnOrAfter != null && (now.after(this.notOnOrAfter) || now.equals(this.notOnOrAfter))) {
            this.log.debug("Invalid Assertion: notOnOrAfter violated: (" + now.toString() + " >= " + this.notOnOrAfter.toString() + ").");
            return false;
        }
        if (!this.audienceRestrictions.contains(spConfiguration.getEntityId())) {
            this.log.debug("Invalid Assertion: audienceRestrictions violated.");
            return false;
        }
        if (!this.signatureValid) {
            this.log.debug("Invalid Assertion: Signature invalid.");
            return false;
        }
        return true;
    }

    public Calendar getNotBefore() {
        return this.notBefore;
    }

    public void setNotBefore(Calendar notBefore) {
        this.notBefore = notBefore;
    }

    public Calendar getNotOnOrAfter() {
        return this.notOnOrAfter;
    }

    public void setNotOnOrAfter(Calendar notOnOrAfter) {
        this.notOnOrAfter = notOnOrAfter;
    }

    public void addAudienceRestriction(String audience) {
        if (null == this.audienceRestrictions) {
            this.audienceRestrictions = new LinkedList();
        }
        this.audienceRestrictions.add(audience);
    }

    public boolean isSignatureValid() {
        return this.signatureValid;
    }

    public void setSignatureValid(boolean signatureValid) {
        this.signatureValid = signatureValid;
    }
}

