/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.explorer.impl;

import com.day.crx.explorer.impl.JspServletConfig;
import com.day.crx.explorer.impl.JspServletContext;
import com.day.crx.explorer.impl.j2ee.JCRExplorerServlet;
import com.day.crx.explorer.impl.ui.NodeTreeServlet;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import javax.servlet.GenericServlet;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspFactory;
import org.apache.jasper.runtime.JspFactoryImpl;
import org.apache.sling.commons.mime.MimeTypeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainServlet
extends GenericServlet {
    private static final Logger log = LoggerFactory.getLogger(MainServlet.class);
    private MimeTypeService mimeTypeService = null;
    private JspFactoryImpl defaultFactory;
    private final Map<String, GenericServlet> servlets = new HashMap<String, GenericServlet>();

    protected void activate() {
        this.defaultFactory = new JspFactoryImpl();
        JspFactory.setDefaultFactory((JspFactory)this.defaultFactory);
    }

    protected void deactivate() {
        this.defaultFactory = null;
        JspFactory.setDefaultFactory(null);
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        if (!(req instanceof HttpServletRequest) || !(res instanceof HttpServletResponse)) {
            throw new ServletException("Not a http servlet request");
        }
        this.doService((HttpServletRequest)req, (HttpServletResponse)res);
    }

    private void doService(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String servletPath;
        String servletClass;
        String pathInfo;
        if (req.getAttribute("javax.servlet.include.context_path") == null) {
            req.setAttribute("javax.servlet.include.context_path", (Object)req.getContextPath());
        }
        if ((pathInfo = (String)req.getAttribute("javax.servlet.include.path_info")) == null) {
            pathInfo = req.getPathInfo();
        }
        if (pathInfo == null || pathInfo.length() == 0) {
            pathInfo = "/";
        }
        if (pathInfo.endsWith("/")) {
            res.sendRedirect(req.getContextPath() + req.getServletPath() + pathInfo + "index.jsp");
            return;
        }
        if (pathInfo.startsWith("/ui/nodetree/")) {
            servletClass = NodeTreeServlet.class.getName();
            servletPath = "/crx/explorer/ui/nodetree";
            pathInfo = pathInfo.substring("/ui/nodetree".length());
        } else if (pathInfo.endsWith(".jsp")) {
            try {
                pathInfo = new URI(pathInfo).normalize().getPath();
            }
            catch (URISyntaxException e) {
                log.error("Error while normalizing path.");
            }
            servletPath = "/crx/explorer" + pathInfo;
            servletClass = "com.day.crx.explorer.impl.jsp." + MainServlet.makeJavaPackage(pathInfo);
            log.debug("Resolved JSP servlet. {} -> {}", (Object)pathInfo, (Object)servletClass);
            pathInfo = null;
        } else {
            if (this.spoolResource(req, res, pathInfo)) {
                return;
            }
            if (pathInfo.startsWith("/imgs/nodetypes/")) {
                this.spoolNodeTypeIcon(req, res, pathInfo.substring("/imgs/nodetypes/".length()));
                return;
            }
            res.sendError(404);
            return;
        }
        GenericServlet servlet = this.servlets.get(servletClass);
        if (servlet == null) {
            ClassLoader cl = ((Object)((Object)this)).getClass().getClassLoader();
            try {
                Class<?> c = cl.loadClass(servletClass);
                servlet = (GenericServlet)c.newInstance();
                JspServletContext ctx = new JspServletContext(this.getServletContext());
                JspServletConfig config = new JspServletConfig(ctx, servletPath);
                servlet.init((ServletConfig)config);
                this.servlets.put(servletClass, servlet);
            }
            catch (ClassNotFoundException e) {
                log.error("Unable to load JSP class for {}: {}", (Object)servletPath, (Object)e.toString());
            }
            catch (InstantiationException e) {
                log.error("Unable to init JSP class for {}.", (Object)servletPath, (Object)e);
            }
            catch (IllegalAccessException e) {
                log.error("Unable to init JSP class for {}.", (Object)servletPath, (Object)e);
            }
        }
        if (servlet != null) {
            JspRequestWrapper request = new JspRequestWrapper(req, servletPath, pathInfo);
            servlet.service((ServletRequest)request, (ServletResponse)res);
        } else {
            res.sendError(404);
        }
    }

    private static String makeJavaPackage(String path) {
        StringBuilder ret = new StringBuilder();
        String delim = "";
        for (String seg : path.split("/")) {
            if (seg.length() <= 0) continue;
            seg = seg.replace("_", "_005f");
            seg = seg.replace(".", "_");
            ret.append(delim).append(seg);
            delim = ".";
        }
        return ret.toString();
    }

    private void spoolNodeTypeIcon(HttpServletRequest request, HttpServletResponse response, String path) throws IOException {
        Session repSession = JCRExplorerServlet.getSession(request);
        if (repSession == null) {
            response.sendError(403);
            return;
        }
        int pos = path.indexOf(46);
        if (pos > 0) {
            path = path.substring(0, pos);
        }
        String nodeTypeName = path.replace('/', ':');
        URL resource = null;
        try {
            NodeType nt = repSession.getWorkspace().getNodeTypeManager().getNodeType(nodeTypeName);
            LinkedList<NodeType> superTypes = null;
            while (resource == null) {
                String src = "/imgs/nodetypes/" + nt.getName().replace(':', '/') + ".gif";
                resource = this.getServletContext().getResource("/docroot" + src);
                if (resource != null) continue;
                if (superTypes == null) {
                    superTypes = this.buildSuperTypes(nt);
                }
                if (!superTypes.isEmpty()) {
                    nt = superTypes.removeFirst();
                    continue;
                }
                break;
            }
        }
        catch (RepositoryException e) {
            // empty catch block
        }
        if (resource == null) {
            resource = this.getServletContext().getResource("/docroot/imgs/nodetypes/mix/default.gif");
        }
        if (!this.spoolResource(request, response, resource)) {
            response.sendError(404);
        }
    }

    private LinkedList<NodeType> buildSuperTypes(NodeType nt) {
        LinkedList<NodeType> list = new LinkedList<NodeType>();
        this.addSuperTypes(list, nt.getDeclaredSupertypes());
        return list;
    }

    private void addSuperTypes(LinkedList<NodeType> list, NodeType[] nodeTypes) {
        list.addAll(Arrays.asList(nodeTypes));
        for (NodeType nodeType : nodeTypes) {
            this.addSuperTypes(list, nodeType.getDeclaredSupertypes());
        }
    }

    private boolean spoolResource(HttpServletRequest request, HttpServletResponse response, String path) throws IOException {
        log.debug("SpoolResource: servletPath=" + request.getServletPath());
        log.debug("SpoolResource: pathInfo = " + request.getPathInfo());
        log.debug("SpoolResource: pathTranslated = " + request.getPathTranslated());
        log.debug("SpoolResource: requestURI = " + request.getRequestURI());
        log.debug("SpoolResource: path = " + path);
        if (path.equals("") || path.endsWith("/")) {
            String loc = request.getRequestURI();
            loc = loc.endsWith("/") ? loc + "index.jsp" : loc + "/index.jsp";
            log.debug("SpoolResource: sending redirect: " + loc);
            response.setHeader("Location", loc);
            response.setStatus(301);
            response.getWriter().println("moved");
            response.flushBuffer();
            return true;
        }
        return this.spoolResource(request, response, this.getServletContext().getResource("/docroot" + path));
    }

    private boolean spoolResource(HttpServletRequest request, HttpServletResponse response, URL res) throws IOException {
        int read;
        String ct;
        if (res == null) {
            log.debug("SpoolResource: resource == null");
            return false;
        }
        String fileName = res.toExternalForm();
        log.debug("SpoolResource: URL={}", (Object)fileName);
        URLConnection con = res.openConnection();
        if (con == null) {
            log.debug("SpoolResource: connection == null");
            return false;
        }
        long lastModified = con.getLastModified();
        if (lastModified == 0L) {
            lastModified = Long.MAX_VALUE;
        }
        log.debug("SpoolResource: lastModified=" + lastModified);
        if (lastModified <= request.getDateHeader("If-Modified-Since")) {
            log.debug("SpoolResource: If-Modified-Since=" + request.getDateHeader("If-Modified-Since"));
            response.setStatus(304);
            return true;
        }
        if (lastModified != Long.MAX_VALUE) {
            response.setDateHeader("Last-Modified", lastModified);
        }
        response.setIntHeader("Content-Length", con.getContentLength());
        MimeTypeService mts = this.mimeTypeService;
        String string = ct = mts != null ? mts.getMimeType(fileName) : null;
        if (ct != null && ct.length() > 0) {
            response.setContentType(ct);
        }
        byte[] buffer = new byte[8192];
        InputStream in = con.getInputStream();
        ServletOutputStream out = response.getOutputStream();
        while ((read = in.read(buffer)) >= 0) {
            out.write(buffer, 0, read);
        }
        in.close();
        return true;
    }

    protected void bindMimeTypeService(MimeTypeService mimeTypeService) {
        this.mimeTypeService = mimeTypeService;
    }

    protected void unbindMimeTypeService(MimeTypeService mimeTypeService) {
        if (this.mimeTypeService == mimeTypeService) {
            this.mimeTypeService = null;
        }
    }

    private static class JcrIncludeRequest
    extends HttpServletRequestWrapper {
        private final String includePath;

        private JcrIncludeRequest(HttpServletRequest request, String includePath) {
            super(request);
            this.includePath = includePath;
        }

        public String getPathInfo() {
            return this.includePath;
        }
    }

    private static class JspRequestWrapper
    extends HttpServletRequestWrapper {
        private final HttpServletRequest httpServletRequest;
        private final String servletPath;
        private final String pathInfo;

        private JspRequestWrapper(HttpServletRequest request, String servletPath, String pathInfo) {
            super(request);
            this.httpServletRequest = request;
            this.servletPath = servletPath;
            this.pathInfo = pathInfo;
        }

        public String getServletPath() {
            return this.servletPath;
        }

        public String getPathInfo() {
            return this.pathInfo;
        }

        public String getContextPath() {
            String contextPath = (String)this.getAttribute("javax.servlet.include.context_path");
            if (contextPath == null) {
                contextPath = super.getContextPath();
            }
            return contextPath;
        }

        public RequestDispatcher getRequestDispatcher(final String path) {
            return new RequestDispatcher(){

                public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
                    JspRequestWrapper.this.httpServletRequest.getRequestDispatcher(path).forward(request, response);
                }

                public void include(ServletRequest request, ServletResponse response) throws ServletException, IOException {
                    JcrIncludeRequest req = new JcrIncludeRequest((HttpServletRequest)request, path);
                    JspRequestWrapper.this.httpServletRequest.getRequestDispatcher(path).include((ServletRequest)req, response);
                }
            };
        }
    }
}

