/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.explorer.impl.compat;

import com.day.crx.explorer.impl.compat.SecurityProvider;
import com.day.crx.sling.server.jmx.ManagedRepositoryMBean;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.webconsole.WebConsoleSecurityProvider;

public class ClusterServlet
extends HttpServlet {
    private static final long serialVersionUID = 4981740207052526136L;
    private ManagedRepositoryMBean repository;
    private volatile WebConsoleSecurityProvider security;

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (new SecurityProvider(this.security).authenticate(request, response)) {
            super.service(request, response);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Properties properties = new Properties();
        TabularData tabular = this.repository.getClusterProperties();
        for (Object entry : tabular.values()) {
            if (!(entry instanceof CompositeData)) continue;
            CompositeData cd = (CompositeData)entry;
            properties.setProperty(cd.get("key").toString(), cd.get("value").toString());
        }
        response.setContentType("text/plain; charset=ISO-8859-1");
        properties.store((OutputStream)response.getOutputStream(), "Cluster properties");
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.repository.joinCluster(request.getParameter("masterURL"), request.getParameter("username"), request.getParameter("password"));
        }
        catch (Exception e) {
            throw new ServletException("Failed to join cluster", (Throwable)e);
        }
    }

    protected void bindRepository(ManagedRepositoryMBean managedRepositoryMBean) {
        this.repository = managedRepositoryMBean;
    }

    protected void unbindRepository(ManagedRepositoryMBean managedRepositoryMBean) {
        if (this.repository == managedRepositoryMBean) {
            this.repository = null;
        }
    }

    protected void bindSecurity(WebConsoleSecurityProvider webConsoleSecurityProvider) {
        this.security = webConsoleSecurityProvider;
    }

    protected void unbindSecurity(WebConsoleSecurityProvider webConsoleSecurityProvider) {
        if (this.security == webConsoleSecurityProvider) {
            this.security = null;
        }
    }
}

