/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.explorer.impl.compat;

import com.day.crx.explorer.impl.compat.SecurityProvider;
import com.day.crx.sling.server.jmx.ManagedRepositoryMBean;
import java.io.IOException;
import java.io.PrintWriter;
import javax.jcr.RepositoryException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.webconsole.WebConsoleSecurityProvider;

public class DataStoreGarbageCollectionServlet
extends HttpServlet {
    private static final long serialVersionUID = -66796003658579449L;
    private ManagedRepositoryMBean repository;
    private volatile WebConsoleSecurityProvider security;

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (new SecurityProvider(this.security).authenticate(request, response)) {
            super.service(request, response);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/plain; charset=UTF-8");
        PrintWriter writer = response.getWriter();
        writer.println(this.repository.getBackupProgress());
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String action = request.getParameter("action");
        if ("run".equals(action)) {
            String delete = request.getParameter("delete");
            try {
                this.repository.runDataStoreGarbageCollection(Boolean.valueOf(delete != null && delete.length() > 0));
            }
            catch (RepositoryException e) {
                throw new ServletException("Failed to run data store garbage collection", (Throwable)e);
            }
        } else {
            throw new ServletException("Unsupported action");
        }
    }

    protected void bindRepository(ManagedRepositoryMBean managedRepositoryMBean) {
        this.repository = managedRepositoryMBean;
    }

    protected void unbindRepository(ManagedRepositoryMBean managedRepositoryMBean) {
        if (this.repository == managedRepositoryMBean) {
            this.repository = null;
        }
    }

    protected void bindSecurity(WebConsoleSecurityProvider webConsoleSecurityProvider) {
        this.security = webConsoleSecurityProvider;
    }

    protected void unbindSecurity(WebConsoleSecurityProvider webConsoleSecurityProvider) {
        if (this.security == webConsoleSecurityProvider) {
            this.security = null;
        }
    }
}

