/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.explorer.impl.j2ee;

import com.day.crx.explorer.impl.j2ee.CRXSessionCache;
import com.day.crx.explorer.impl.j2ee.JCRExplorerServlet;
import com.day.crx.explorer.impl.j2ee.LoginServlet;
import com.day.crx.explorer.impl.util.JSR283Helper;
import com.day.crx.explorer.impl.util.RequestData;
import com.day.crx.i18n.Dictionary;
import com.day.crx.i18n.LanguageManager;
import java.io.IOException;
import java.util.Locale;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.PageContext;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CRXContext {
    private static Logger log = LoggerFactory.getLogger(CRXContext.class);
    public static final String ATTR_NAME = "CRXContext";
    private static final String S_ATTR_LOCALE = "CRXLocale";
    public static final String REQ_PARAM_PATH = "Path";
    public static final String REQ_PARAM_PATH2 = "path";
    public static final String REQ_PARAM_ACTION = "CRXAction";
    public static final String REQ_PARAM_ACTION_ARG = "CRXActionArg";
    private final ServletContext servletCtx;
    private final Repository repository;
    private final boolean ownSession;
    private final RequestData data;
    private final String docroot;
    private final HttpServletRequest request;
    private boolean initializedSession;
    private Session repSession;
    private CRXSessionCache.CRXSessionId sessionId;

    public static CRXContext getInstance(PageContext pCtx, HttpServletRequest request) {
        return CRXContext.getInstance(pCtx.getServletContext(), request);
    }

    public static CRXContext getInstance(PageContext pCtx, HttpServletRequest request, boolean ownSession) {
        return CRXContext.getInstance(pCtx.getServletContext(), request, ownSession);
    }

    public static CRXContext getInstance(ServletContext sCtx, HttpServletRequest request) {
        return CRXContext.getInstance(sCtx, request, false);
    }

    public static CRXContext getInstance(ServletContext sCtx, HttpServletRequest request, boolean ownSession) {
        CRXContext ctx = (CRXContext)request.getAttribute(ATTR_NAME);
        if (ctx == null) {
            ctx = new CRXContext(sCtx, request, ownSession);
            request.setAttribute(ATTR_NAME, (Object)ctx);
        }
        return ctx;
    }

    private CRXContext(ServletContext ctx, HttpServletRequest request, boolean ownSession) {
        this.data = new RequestData(request, JCRExplorerServlet.getTempDirectory(ctx));
        this.docroot = JCRExplorerServlet.getDocrootPrefix(request);
        this.repository = JCRExplorerServlet.getInstance() == null ? null : JCRExplorerServlet.getInstance().getRepository();
        this.request = request;
        this.servletCtx = ctx;
        this.ownSession = ownSession;
        this.getCurrentDictionary();
    }

    public Item getItem() {
        String path = this.getPath();
        try {
            Session session = this.getSession();
            return path == null || session == null ? null : JSR283Helper.getItem(session, path);
        }
        catch (RepositoryException e) {
            return null;
        }
    }

    public String getPath() {
        String path = this.data.getParameter(REQ_PARAM_PATH);
        if (path == null) {
            path = this.data.getParameter(REQ_PARAM_PATH2);
        }
        return "".equals(path) ? "/" : path;
    }

    public Node getNode() {
        String path = this.getPath();
        try {
            Session session = this.getSession();
            return path == null || session == null ? null : JSR283Helper.getNode(session, path);
        }
        catch (RepositoryException e) {
            return null;
        }
    }

    public Property getProperty() {
        String path = this.getPath();
        try {
            Session session = this.getSession();
            return path == null || session == null ? null : JSR283Helper.getProperty(session, path);
        }
        catch (RepositoryException e) {
            return null;
        }
    }

    public String getDocroot() {
        return this.docroot;
    }

    public boolean isAdmin() {
        Session session = this.getSession();
        if (session instanceof JackrabbitSession) {
            try {
                UserManager manager = ((JackrabbitSession)session).getUserManager();
                Authorizable authorizable = manager.getAuthorizable(session.getUserID());
                if (authorizable instanceof User) {
                    return ((User)authorizable).isAdmin();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "admin".equals(session.getUserID());
    }

    public String getUsersPath() {
        return "/home/users";
    }

    public String getGroupsPath() {
        return "/home/groups";
    }

    public Session getSession() {
        if (!this.initializedSession) {
            if (this.ownSession) {
                try {
                    this.repSession = LoginServlet.login(this, null);
                }
                catch (RepositoryException e) {
                    log.error("Unable to retrieve session: " + e.toString());
                }
                catch (ServletException e) {
                    log.error("Unable to retrieve session: " + e.toString());
                }
            } else {
                this.repSession = JCRExplorerServlet.getDefaultSession(this.request);
            }
            this.initializedSession = true;
        }
        return this.repSession;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public RequestData getRequestData() {
        return this.data;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public ServletContext getServletContext() {
        return this.servletCtx;
    }

    public void lockSession() {
        this.getSession();
        if (this.sessionId == null && !this.ownSession && this.repSession != null) {
            this.sessionId = JCRExplorerServlet.getInstance().getSessionCache().getSessionId(this.request);
            if (this.sessionId != null) {
                this.sessionId.acquire();
            }
        }
    }

    public void close() {
        try {
            this.data.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.request.removeAttribute(ATTR_NAME);
        if (this.ownSession && this.repSession != null) {
            this.repSession.logout();
        }
        if (this.sessionId != null) {
            this.sessionId.release();
        }
    }

    public Dictionary getCurrentDictionary() {
        HttpSession s = this.request.getSession(false);
        Dictionary dict = Dictionary.getCurrent();
        if (s == null) {
            return dict;
        }
        Locale locale = (Locale)s.getAttribute(S_ATTR_LOCALE);
        if (locale == null) {
            return dict;
        }
        if (!locale.equals(dict.getLocale())) {
            dict = Dictionary.setCurrent(null, (Locale)locale);
        }
        return dict;
    }

    public void setCurrentLocale(String localeStr) {
        this.setCurrentLocale(LanguageManager.getLocale((String)localeStr));
    }

    public void setCurrentLocale(Locale locale) {
        HttpSession s = this.request.getSession();
        if (s == null) {
            throw new IllegalStateException("Session must not be null at this time.");
        }
        s.setAttribute(S_ATTR_LOCALE, (Object)locale);
    }
}

