/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.explorer.impl.j2ee;

import com.day.crx.explorer.impl.j2ee.BasicCredentialsProvider;
import com.day.crx.explorer.impl.j2ee.LoginServlet;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.SimpleCredentials;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.jackrabbit.api.security.authentication.token.TokenCredentials;

public class CRXCredentialsProvider
extends BasicCredentialsProvider {
    private static final Set<String> SPECIAL_PARAMS = new HashSet<String>(6);
    private static final String ATTR_TOKEN = ".token";
    private static final String ATTR_TOKEN_IP = ".token.ip";
    private static final String ATTR_TOKEN_AGENT = ".token.useragent";
    private static final String ATTR_REFERER = "referer";

    public CRXCredentialsProvider() {
        this(null);
    }

    public CRXCredentialsProvider(String defaultHeaderValue) {
        super(defaultHeaderValue);
    }

    public Credentials getCredentials(HttpServletRequest request) throws LoginException, ServletException {
        Credentials creds = CRXCredentialsProvider.getCredentialsFromParam(request);
        if (creds == null && (creds = CRXCredentialsProvider.getCredentialsFromToken(request)) == null) {
            creds = super.getCredentials(request);
        }
        CRXCredentialsProvider.setCredentialsAttributes(creds, request);
        return creds;
    }

    private static Credentials getCredentialsFromToken(HttpServletRequest request) {
        String token = LoginServlet.getLoginTokenFromCookies(request);
        if (token == null) {
            return null;
        }
        return new TokenCredentials(token);
    }

    private static Credentials getCredentialsFromParam(HttpServletRequest request) {
        TokenCredentials creds;
        String userid = request.getParameter("UserId");
        String passwd = request.getParameter("Password");
        if (passwd == null) {
            passwd = "";
        }
        String token = request.getParameter(ATTR_TOKEN);
        if (userid != null && userid.length() > 0) {
            creds = new SimpleCredentials(userid, passwd.toCharArray());
            if (token != null) {
                ((SimpleCredentials)creds).setAttribute(ATTR_TOKEN, (Object)token);
            }
        } else {
            creds = token != null ? new TokenCredentials(token) : null;
        }
        return creds;
    }

    private static void setCredentialsAttributes(Credentials creds, HttpServletRequest request) {
        block12: {
            block11: {
                String referrer;
                String ip;
                if (!(creds instanceof SimpleCredentials)) break block11;
                SimpleCredentials sCreds = (SimpleCredentials)creds;
                if (sCreds.getAttribute(ATTR_TOKEN) == null) break block12;
                String xff = request.getHeader("X-Forwarded-For");
                if (xff == null) {
                    ip = request.getRemoteAddr();
                } else {
                    String[] ips = xff.split(",");
                    ip = ips[ips.length - 1].trim();
                }
                sCreds.setAttribute(ATTR_TOKEN_IP, (Object)ip);
                String userAgent = request.getHeader("User-Agent");
                if (userAgent != null) {
                    sCreds.setAttribute(ATTR_TOKEN_AGENT, (Object)userAgent);
                }
                if ((referrer = request.getHeader("Referer")) != null) {
                    sCreds.setAttribute(ATTR_REFERER, (Object)referrer);
                }
                Enumeration names = request.getParameterNames();
                while (names.hasMoreElements()) {
                    String name = names.nextElement().toString();
                    String param = request.getParameter(name);
                    if (param == null || SPECIAL_PARAMS.contains(name)) continue;
                    sCreds.setAttribute(name, (Object)param);
                }
                break block12;
            }
            if (creds instanceof TokenCredentials) {
                String referrer;
                String ip;
                TokenCredentials tc = (TokenCredentials)creds;
                String xff = request.getHeader("X-Forwarded-For");
                if (xff == null) {
                    ip = request.getRemoteAddr();
                } else {
                    String[] ips = xff.split(",");
                    ip = ips[ips.length - 1].trim();
                }
                tc.setAttribute(ATTR_TOKEN_IP, ip);
                String userAgent = request.getHeader("User-Agent");
                if (userAgent != null) {
                    tc.setAttribute(ATTR_TOKEN_AGENT, userAgent);
                }
                if ((referrer = request.getHeader("Referer")) != null) {
                    tc.setAttribute(ATTR_REFERER, referrer);
                }
                Enumeration names = request.getParameterNames();
                while (names.hasMoreElements()) {
                    String name = names.nextElement().toString();
                    String param = request.getParameter(name);
                    if (param == null || SPECIAL_PARAMS.contains(name)) continue;
                    tc.setAttribute(name, param);
                }
            }
        }
    }

    static {
        SPECIAL_PARAMS.add("UserId");
        SPECIAL_PARAMS.add("Password");
        SPECIAL_PARAMS.add("Workspace");
        SPECIAL_PARAMS.add(ATTR_TOKEN);
        SPECIAL_PARAMS.add("redirect");
        SPECIAL_PARAMS.add("_charset_");
    }
}

