/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.explorer.impl.j2ee;

import com.day.crx.explorer.impl.j2ee.JCRExplorerServlet;
import com.day.crx.explorer.impl.j2ee.SessionProvider;
import java.util.HashMap;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;

public class CRXSessionProvider
implements SessionProvider {
    private SessionProvider base;
    private ServletContext ctx;
    private final HashMap<Session, Counter> ownSessions = new HashMap();

    public CRXSessionProvider(ServletContext ctx, SessionProvider base) {
        this.base = base;
        this.ctx = ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session getSession(HttpServletRequest request, Repository rep, String workspace) throws ServletException, RepositoryException {
        Session session = JCRExplorerServlet.getSession(request);
        if (session == null && this.base != null) {
            return this.base.getSession(request, rep, workspace);
        }
        HashMap<Session, Counter> hashMap = this.ownSessions;
        synchronized (hashMap) {
            Counter c = this.ownSessions.get(session);
            if (c == null) {
                c = new Counter();
                this.ownSessions.put(session, c);
            }
            c.inc();
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseSession(Session session) {
        HashMap<Session, Counter> hashMap = this.ownSessions;
        synchronized (hashMap) {
            Counter c = this.ownSessions.get(session);
            if (c == null) {
                this.base.releaseSession(session);
            } else if (c.dec() == 0) {
                this.ownSessions.remove(session);
            }
        }
    }

    private static class Counter {
        private int i = 0;

        private Counter() {
        }

        public int inc() {
            return ++this.i;
        }

        public int dec() {
            return --this.i;
        }
    }
}

