/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.explorer.impl.j2ee;

import com.day.crx.explorer.impl.j2ee.CRXContext;
import com.day.crx.explorer.impl.j2ee.CRXSessionCache;
import com.day.crx.explorer.impl.j2ee.LoginServlet;
import com.day.crx.explorer.impl.j2ee.RelaxedUTF8Decoder;
import com.day.crx.i18n.LanguageManager;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import javax.jcr.Credentials;
import javax.jcr.PropertyType;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRExplorerServlet {
    private static JCRExplorerServlet instance;
    private static Logger log;
    public static final String CTX_ATTR_TMP_DIRECTORY = "crx.explorer.tmpdir";
    public static final String CTX_ATTR_CHECKER_UPDATE_URL = "crx.explorer.checker.updateurl";
    public static final String CTX_ATTR_SUPPORT_EMAIL = "crx.explorer.support.email";
    public static final String PARAM_USER = "UserId";
    public static final String S_ATTR_CRX_SESSION_ID = "CRX_SESSION_ID";
    public static final String NT_PREFIX = "/imgs/nodetypes/";
    public static final String PT_PREFIX = "/imgs/pt/";
    public static final String REP_VERSION_DISPLAY_DESC = "jcr.repository.version.display";
    private SlingRepository repository = null;
    private final CRXSessionCache sessionCache = new CRXSessionCache(this);

    protected void activate(ComponentContext ctx) {
        instance = this;
        LoginServlet.initRepositoryId((Repository)this.repository);
        try {
            URL url = ctx.getBundleContext().getBundle().getResource("/languages/en.properties");
            LanguageManager.getInstance().addTranslation(Locale.ENGLISH, url);
        }
        catch (IOException e) {
            log.error("Error while adding languages:" + e.toString());
        }
        LanguageManager.getInstance();
    }

    protected void deactivate() {
        this.sessionCache.logoutAll();
        instance = null;
    }

    public Repository getRepository() {
        if (this.repository == null) {
            log.warn("Repository not available yet.");
        }
        return this.repository;
    }

    public CRXSessionCache getSessionCache() {
        return this.sessionCache;
    }

    public static File getTempDirectory(ServletContext ctx) {
        return (File)ctx.getAttribute(CTX_ATTR_TMP_DIRECTORY);
    }

    public static String getVersion() {
        try {
            return JCRExplorerServlet.getInstance().getRepository().getDescriptor("jcr.repository.version");
        }
        catch (IllegalStateException e) {
            return "";
        }
    }

    public static String getProductVersion() {
        try {
            String ret = JCRExplorerServlet.getInstance().getRepository().getDescriptor(REP_VERSION_DISPLAY_DESC);
            if (ret == null) {
                ret = JCRExplorerServlet.getVersion();
            }
            return ret;
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String getCrxUpdateUrl(ServletContext ctx) {
        return (String)ctx.getAttribute(CTX_ATTR_CHECKER_UPDATE_URL);
    }

    public static String getCrxSupportEmail(ServletContext ctx) {
        return (String)ctx.getAttribute(CTX_ATTR_SUPPORT_EMAIL);
    }

    public static JCRExplorerServlet getInstance() {
        return instance;
    }

    public static Session login(HttpServletRequest req, Credentials creds, String workspace) throws RepositoryException {
        return JCRExplorerServlet.getInstance().sessionCache.login(req, creds, workspace);
    }

    public static Session login(CRXContext ctx, HttpServletResponse response) throws RepositoryException, ServletException {
        return JCRExplorerServlet.getInstance().sessionCache.login(ctx, response);
    }

    public static Session switchWorkspace(HttpServletRequest req, String workspace) throws RepositoryException {
        return JCRExplorerServlet.getInstance().sessionCache.switchWorkspace(req, workspace);
    }

    public static Session impersonate(HttpServletRequest req, String userId) throws RepositoryException {
        return JCRExplorerServlet.getInstance().sessionCache.impersonate(req, userId);
    }

    public static void logout(HttpServletRequest req, HttpServletResponse response) {
        LoginServlet.setLoginCookies(null, req, response);
        HttpSession httpSession = req.getSession(false);
        if (httpSession != null) {
            httpSession.removeAttribute(S_ATTR_CRX_SESSION_ID);
        }
    }

    public static Session getDefaultSession(HttpServletRequest req) {
        return JCRExplorerServlet.getInstance().sessionCache.getDefaultSession(req);
    }

    public static Session getSession(HttpServletRequest req) {
        return JCRExplorerServlet.getInstance().sessionCache.getSession(req);
    }

    public static String getNTIcon(NodeType nt) {
        return JCRExplorerServlet.getNTIcon(nt.getName());
    }

    public static String getNTIcon(String ntName) {
        return NT_PREFIX + Text.encodeIllegalXMLCharacters((String)ntName).replace(':', '/') + ".gif";
    }

    public static String getPTIcon(int propertyType) {
        return PT_PREFIX + PropertyType.nameFromValue((int)propertyType).toLowerCase() + ".gif";
    }

    public static String getPTIcon(String propertyType) {
        return PT_PREFIX + propertyType.toLowerCase() + ".gif";
    }

    public ServletContext getServletContext() {
        return null;
    }

    public static String getServletPath(HttpServletRequest request) {
        String ctx;
        String path = RelaxedUTF8Decoder.unescape(request.getRequestURI());
        if (path.startsWith(ctx = request.getContextPath())) {
            path = path.substring(ctx.length());
        }
        return path;
    }

    public static String getDocrootPrefix(HttpServletRequest request) {
        String prefix = request.getContextPath();
        if (prefix.equals("/")) {
            prefix = "";
        }
        return prefix + "/crx/explorer";
    }

    static {
        log = LoggerFactory.getLogger(JCRExplorerServlet.class);
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }
}

