/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.explorer.impl.j2ee.mapping;

import com.day.crx.explorer.impl.j2ee.mapping.AbstractMapping;
import java.util.regex.Pattern;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.RepositoryException;

public class PathMapping
extends AbstractMapping {
    public static final String CRX_PATH_REQUEST_MAPPING = "crx:PathRequestMapping";
    public static final String CRX_PATTERN = "crx:pattern";
    private final Pattern pattern;

    public PathMapping(Node def) throws RepositoryException {
        super(def);
        assert (def.isNodeType(CRX_PATH_REQUEST_MAPPING));
        String p = def.getProperty(CRX_PATTERN).getString();
        if (p.endsWith("//")) {
            p = p.substring(0, p.length() - 2) + "(/.*)?";
        }
        this.pattern = Pattern.compile(p);
    }

    public String toString() {
        return this.pattern + super.toString();
    }

    public boolean contains(Item i) throws RepositoryException {
        if (!i.isNode() && !this.isIncludeProps()) {
            return false;
        }
        return this.pattern.matcher(i.getPath()).matches();
    }
}

