/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.explorer.impl.j2ee.mapping;

import com.day.crx.explorer.impl.j2ee.mapping.AbstractMapping;
import com.day.crx.explorer.impl.j2ee.mapping.Mapping;
import com.day.crx.explorer.impl.j2ee.mapping.NodeTypeMapping;
import com.day.crx.explorer.impl.j2ee.mapping.PathMapping;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.ObservationManager;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestMapper
implements EventListener {
    public static final String CRX_REQUEST_MAPPING = "crx:RequestMapping";
    private static final Logger log = LoggerFactory.getLogger(RequestMapper.class);
    private Map mappings = new HashMap();
    private Session session;

    public RequestMapper(Session session) {
        this.session = session;
        this.initMappings();
        try {
            ObservationManager obs = session.getWorkspace().getObservationManager();
            obs.addEventListener((EventListener)this, 31, "/", true, null, new String[]{CRX_REQUEST_MAPPING}, false);
            obs.addEventListener((EventListener)new RemoveListener(), 2, "/", true, null, null, false);
        }
        catch (RepositoryException e) {
            log.error("Unable to get ObservationManager: {}", (Object)e.toString());
        }
    }

    private void initMappings() {
        try {
            QueryManager qmgr = this.session.getWorkspace().getQueryManager();
            Query query = qmgr.createQuery("select * from crx:RequestMapping", "sql");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            while (iter.hasNext()) {
                this.addMapping(iter.nextNode().getPath());
            }
        }
        catch (RepositoryException e) {
            log.error("Error during initialization of request mappings: {}", (Object)e.getMessage());
        }
    }

    public Mapping getMapping(Item i) throws RepositoryException {
        for (Mapping map : this.mappings.values()) {
            if (!map.contains(i)) continue;
            return map;
        }
        return null;
    }

    private void addMapping(String path) throws RepositoryException {
        Node n = (Node)this.session.getItem(path);
        AbstractMapping map = null;
        if (n.isNodeType("crx:NodeTypeRequestMapping")) {
            map = new NodeTypeMapping(n);
        } else if (n.isNodeType("crx:PathRequestMapping")) {
            map = new PathMapping(n);
        } else {
            log.info("Invalid mapping at " + path);
        }
        this.mappings.put(path, map);
        log.info("Adding mapping: {}", (Object)map);
    }

    private void removeMapping(String path) {
        Mapping map = (Mapping)this.mappings.remove(path);
        if (map != null) {
            log.info("Removed mapping: {}", (Object)map);
        }
    }

    public void onEvent(EventIterator eventIterator) {
        HashSet<String> modifiedNodes = new HashSet<String>();
        HashSet<String> removedNodes = new HashSet<String>();
        while (eventIterator.hasNext()) {
            try {
                Event evt = eventIterator.nextEvent();
                String path = evt.getPath();
                switch (evt.getType()) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        removedNodes.add(path);
                        break;
                    }
                    case 4: 
                    case 8: 
                    case 16: {
                        String parent = Text.getRelativeParent((String)path, (int)1);
                        modifiedNodes.add(parent);
                    }
                }
            }
            catch (RepositoryException e) {}
        }
        for (String path : removedNodes) {
            this.removeMapping(path);
        }
        for (String path : modifiedNodes) {
            try {
                this.removeMapping(path);
                this.addMapping(path);
            }
            catch (RepositoryException e) {
                log.error("Error during modification: {}", (Object)e.getMessage());
            }
        }
    }

    private class RemoveListener
    implements EventListener {
        private RemoveListener() {
        }

        public void onEvent(EventIterator eventIterator) {
            while (eventIterator.hasNext()) {
                try {
                    Event evt = eventIterator.nextEvent();
                    String path = evt.getPath();
                    switch (evt.getType()) {
                        case 2: {
                            RequestMapper.this.removeMapping(path);
                        }
                    }
                }
                catch (RepositoryException repositoryException) {}
            }
        }
    }
}

