/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.explorer.impl.jsp.diagnostic;

import com.day.crx.explorer.impl.j2ee.CRXContext;
import com.day.crx.i18n.Dictionary;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.jcr.Session;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.SkipPageException;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.jasper.runtime.HttpJspBase;
import org.apache.jasper.runtime.JspSourceDependent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class prof_jsp
extends HttpJspBase
implements JspSourceDependent {
    private static final Logger log = LoggerFactory.getLogger((String)"jsp.prof");
    private static volatile Profiler prof;
    private static List _jspx_dependants;

    public Object getDependants() {
        return _jspx_dependants;
    }

    /*
     * Loose catch block
     */
    public void _jspService(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Dictionary dict;
        PageContext _jspx_page_context;
        JspWriter _jspx_out;
        JspWriter out;
        JspFactory _jspxFactory;
        block19: {
            block20: {
                _jspxFactory = null;
                PageContext pageContext = null;
                out = null;
                _jspx_out = null;
                _jspx_page_context = null;
                _jspxFactory = JspFactory.getDefaultFactory();
                response.setContentType("text/html");
                _jspx_page_context = pageContext = _jspxFactory.getPageContext((Servlet)this, (ServletRequest)request, (ServletResponse)response, null, false, 8192, true);
                pageContext.getServletContext();
                pageContext.getServletConfig();
                _jspx_out = out = pageContext.getOut();
                response.setContentType("text/html; charset=utf-8");
                CRXContext ctx = CRXContext.getInstance(pageContext, request);
                dict = ctx.getCurrentDictionary();
                Session repSession = ctx.getSession();
                if (repSession != null) break block19;
                if (_jspxFactory == null) break block20;
                _jspxFactory.releasePageContext(_jspx_page_context);
            }
            return;
        }
        try {
            String action = request.getParameter("action");
            out.write("<html>\n<head>\n    <style>\n        body {\n            font-family:Verdana;\n            font-size:12px;\n            line-height:14px;\n        }\n    </style>\n</head>\n<body>\n<h2>Profiling Tool</h2>\n<div style=\"max-width: 470px\">\n<p>\nCollects statistics about thread dumps similar to <code>java -agentlib:hprof</code>.\nStack traces from runnable threads are then listed sorted by count.\n</p>\n");
            if ("start".equals(action) && "POST".equals(request.getMethod())) {
                prof = new Profiler();
                prof_jsp.prof.interval = Integer.parseInt(request.getParameter("interval"));
                prof_jsp.prof.depth = Integer.parseInt(request.getParameter("depth"));
                String ignoreList = request.getParameter("ignoreList");
                String ignoreThreadList = request.getParameter("ignoreThreadList");
                String ignorePackageList = request.getParameter("ignorePackageList");
                prof_jsp.prof.ignoreThreads = Profiler.arraySplit(ignoreList, ',', true);
                prof_jsp.prof.ignoreThreads = Profiler.arraySplit(ignoreThreadList, ',', true);
                prof_jsp.prof.ignorePackages = Profiler.arraySplit(ignorePackageList, ',', true);
                out.write("<form method=\"post\">\n            <input type=\"hidden\" name=\"action\" value=\"stop\">\n            <input type=\"submit\" value=\"Stop\">\n        </form>\n        Sample interval (milliseconds): ");
                out.print(prof_jsp.prof.interval);
                out.write("<br>\n        Stack trace depth: ");
                out.print(prof_jsp.prof.depth);
                out.write("<br>\n        Collecting...<br>\n        ");
                prof.startCollecting();
                out.flush();
                long oldTick = prof_jsp.prof.total;
                while (prof != null) {
                    try {
                        long newTick = prof_jsp.prof.total;
                        if (newTick != oldTick) {
                            out.println('.');
                            out.flush();
                            oldTick = newTick;
                        }
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {}
                }
            } else if (action == null || "stop".equals(action)) {
                out.write("<form method=\"post\">\n        \n            <input type=\"button\" class=\"submit\" style=\"width: 80px\"\n                    onclick=\"javascript: var os = document.getElementById('options').style; os.display=(os.display=='none' ? '' : 'none');\"\n                    value=\"");
                out.print(dict.msg("Options >"));
                out.write("\"><br>\n        \n            <div id=\"options\" style=\"display: none\">\n            <p>\n            Sample interval (ms): <input type=\"text\" name=\"interval\" value=\"5\"><br>\n            To increase accuracy, use 1000 or higher when running for many hours.\n            </p><p>\n            Stack trace depth: <input type=\"text\" name=\"depth\" value=\"160\"><br>\n            The number of stack trace lines to analyze.\n            </p><p>\n            Ignore threads: \n<textarea cols=50 rows=4 name=\"ignoreThreadList\">\njava.lang.Object.wait,\njava.lang.Thread.dumpThreads,\njava.lang.Thread.getThreads,\njava.lang.Thread.sleep,\njava.lang.UNIXProcess.waitForProcessExit,\njava.net.PlainSocketImpl.accept,\njava.net.PlainSocketImpl.socketAccept,\njava.net.SocketInputStream.socketRead,\njava.net.SocketOutputStream.socketWrite,\nsun.awt.windows.WToolkit.eventLoop,\nsun.misc.Unsafe.park,\nEDU.oswego,\njava.lang.Object.$$YJP$$wait, \njava.lang.Thread.$$YJP$$sleep,\nsun.misc.Unsafe.$$YJP$$park, \njava.net.PlainSocketImpl.$$YJP$$socketAccept, \njava.net.SocketInputStream.$$YJP$$socketRead,\n");
                out.write("java.net.PlainSocketImpl.$$YJP$$accept,\njava.lang.Thread.$$YJP$$dumpThreads,\n</textarea><br>\n            Threads where the first line start with one of these prefixes are ignored.\n            </p><p>\n            Ignore lines:\n<textarea cols=50 rows=2 name=\"ignoreList\">\norg.apache.commons,\norg.apache.tika.parser.txt.Charset,\nEDU.oswego,\n</textarea><br>\n            Lines that start one of these prefixes are not included in a stack trace.\n            </p><p>\n            Ignore packages:\n<textarea cols=50 rows=2 name=\"ignorePackageList\">\njava,\nsun,\ncom.sun.,\nEDU,\norg.apache.jsp.,\norg.apache.commons.,\norg.eclipse.jdt,\norg.json.,\norg.kxml2.,\ncom.apple.,\n</textarea><br>\n            These packages are ignored in the package summary.\n            </p>\n            </div>\n            <br>\n            <input type=\"hidden\" name=\"action\" value=\"start\">\n            <input type=\"submit\" style=\"width: 100px\" value=\"Start Collecting\">\n        </form>\n        ");
                Profiler old = prof;
                prof = null;
                if (old != null) {
                    out.println("<pre>");
                    out.println(StringEscapeUtils.escapeHtml4((String)old.getTop(20)));
                    out.println("</pre>");
                    out.flush();
                }
            }
            out.write("</div>\n");
        }
        catch (Throwable t) {
            if (!(t instanceof SkipPageException)) {
                out = _jspx_out;
                if (out != null && out.getBufferSize() != 0) {
                    out.clearBuffer();
                }
                if (_jspx_page_context != null) {
                    _jspx_page_context.handlePageException(t);
                }
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            finally {
                if (_jspxFactory != null) {
                    _jspxFactory.releasePageContext(_jspx_page_context);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Profiler
    implements Runnable {
        private static final String LINE_SEPARATOR = System.getProperty("line.separator", "\n");
        private static final int MAX_ELEMENTS = 1000;
        public int interval = 50;
        public int depth = 16;
        public boolean paused;
        String[] ignoreLines = Profiler.arraySplit("", ',', true);
        String[] ignorePackages = Profiler.arraySplit("java.", ',', true);
        String[] ignoreThreads = Profiler.arraySplit("java.lang.Thread.dumpThreads,java.lang.Thread.getThreads,java.net.PlainSocketImpl.socketAccept,java.net.SocketInputStream.socketRead0,java.net.SocketOutputStream.socketWrite0,java.lang.UNIXProcess.waitForProcessExit,java.lang.Object.wait,java.lang.Thread.sleep,sun.awt.windows.WToolkit.eventLoop,sun.misc.Unsafe.park,dalvik.system.VMStack.getThreadStackTrace,dalvik.system.NativeStart.run", ',', true);
        volatile boolean stop;
        private HashMap<String, Integer> counts = new HashMap();
        private HashMap<String, Integer> packages = new HashMap();
        private int minCount = 1;
        int total;
        private Thread thread;
        private long time;

        Profiler() {
        }

        public void startCollecting() {
            this.thread = new Thread(this);
            this.thread.setName("Profiler");
            this.thread.setDaemon(true);
            this.thread.start();
        }

        public void stopCollecting() {
            this.stop = true;
            if (this.thread != null) {
                try {
                    this.thread.join();
                }
                catch (InterruptedException interruptedException) {}
                this.thread = null;
            }
        }

        @Override
        public void run() {
            this.time = System.currentTimeMillis();
            while (!this.stop) {
                try {
                    this.tick();
                }
                catch (Throwable throwable) {
                    break;
                }
            }
            this.time = System.currentTimeMillis() - this.time;
        }

        private void tick() {
            if (this.interval > 0) {
                if (this.paused) {
                    return;
                }
                try {
                    Thread.sleep(this.interval);
                }
                catch (Exception exception) {}
            }
            Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
            for (Map.Entry<Thread, StackTraceElement[]> entry : map.entrySet()) {
                StackTraceElement[] dump;
                Thread t = entry.getKey();
                if (t.getState() != Thread.State.RUNNABLE || (dump = entry.getValue()) == null || dump.length == 0 || Profiler.startsWithAny(dump[0].toString(), this.ignoreThreads)) continue;
                StringBuilder buff = new StringBuilder();
                String last = null;
                boolean packageCounts = false;
                int j = 0;
                int i = 0;
                while (i < dump.length && j < this.depth) {
                    String el = dump[i].toString();
                    if (!el.equals(last) && !Profiler.startsWithAny(el, this.ignoreLines)) {
                        last = el;
                        buff.append("at ").append(el);
                        if (!packageCounts && !Profiler.startsWithAny(el, this.ignorePackages)) {
                            packageCounts = true;
                            int index = 0;
                            while (index < el.length()) {
                                char c = el.charAt(index);
                                if (Character.isUpperCase(c) || c == '(') break;
                                ++index;
                            }
                            if (index > 0 && el.charAt(index - 1) == '.') {
                                --index;
                            }
                            String packageName = el.substring(0, index);
                            Profiler.increment(this.packages, packageName, 0);
                            while ((index = packageName.lastIndexOf(46)) >= 0) {
                                packageName = packageName.substring(0, index);
                                Profiler.increment(this.packages, String.valueOf(packageName) + ".*", 0);
                            }
                            buff.append('+');
                        }
                        buff.append(LINE_SEPARATOR);
                        ++j;
                    }
                    ++i;
                }
                if (buff.length() <= 0) continue;
                this.minCount = Profiler.increment(this.counts, buff.toString().trim(), this.minCount);
                ++this.total;
            }
        }

        private static boolean startsWithAny(String s, String[] prefixes) {
            String[] stringArray = prefixes;
            int n = 0;
            int n2 = stringArray.length;
            while (n < n2) {
                String p = stringArray[n];
                if (p.length() > 0 && s.startsWith(p)) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        private static int increment(HashMap<String, Integer> map, String trace, int minCount) {
            Integer oldCount = map.get(trace);
            if (oldCount == null) {
                map.put(trace, 1);
            } else {
                map.put(trace, oldCount + 1);
            }
            while (map.size() > 1000) {
                Iterator<Map.Entry<String, Integer>> ei = map.entrySet().iterator();
                while (ei.hasNext()) {
                    Map.Entry<String, Integer> e = ei.next();
                    if (e.getValue() > minCount) continue;
                    ei.remove();
                }
                if (map.size() <= 1000) continue;
                ++minCount;
            }
            return minCount;
        }

        public String getTop(int count) {
            this.stopCollecting();
            StringBuilder buff = new StringBuilder();
            buff.append("Profiler Results").append(LINE_SEPARATOR).append(LINE_SEPARATOR).append("Packages:").append(LINE_SEPARATOR);
            for (String k : new TreeSet(this.packages.keySet())) {
                int percent = 100 * this.packages.get(k) / Math.max(this.total, 1);
                if (percent < 5) continue;
                if (percent < 10) {
                    buff.append('0');
                }
                buff.append(percent).append("%: ").append(k).append(LINE_SEPARATOR);
            }
            buff.append(LINE_SEPARATOR).append("Top ").append(count).append(" stack trace(s) of ").append(this.time).append(" ms ").append(LINE_SEPARATOR);
            if (this.counts.size() == 0) {
                buff.append("(none)");
            }
            Profiler.appendTop(buff, this.counts, count, this.total);
            buff.append('.');
            return buff.toString();
        }

        private static void appendTop(StringBuilder buff, HashMap<String, Integer> map, int count, int total) {
            int x = 0;
            int min = 0;
            while (true) {
                int highest = 0;
                Map.Entry<String, Integer> best = null;
                for (Map.Entry<String, Integer> el : map.entrySet()) {
                    if (el.getValue() <= highest && (el.getValue() != highest || el.getKey().length() >= best.getKey().length())) continue;
                    best = el;
                    highest = el.getValue();
                }
                if (best == null) break;
                map.remove(best.getKey());
                if (++x >= count) {
                    if (best.getValue() < min) break;
                    min = best.getValue();
                }
                int c = best.getValue();
                int percent = 100 * c / Math.max(total, 1);
                buff.append(c).append('/').append(total).append(" (").append(percent).append("%):").append(LINE_SEPARATOR).append(best.getKey()).append(LINE_SEPARATOR);
            }
        }

        public static String[] arraySplit(String s, char separatorChar, boolean trim) {
            if (s == null) {
                return null;
            }
            if (s.length() == 0) {
                return new String[0];
            }
            ArrayList<String> list = new ArrayList<String>();
            StringBuilder buff = new StringBuilder(s.length());
            int i = 0;
            while (i < s.length()) {
                char c = s.charAt(i);
                if (c == separatorChar) {
                    String e = buff.toString();
                    list.add(trim ? e.trim() : e);
                    buff.setLength(0);
                } else if (c == '\\' && i < s.length() - 1) {
                    buff.append(s.charAt(++i));
                } else {
                    buff.append(c);
                }
                ++i;
            }
            String e = buff.toString();
            list.add(trim ? e.trim() : e);
            String[] array = new String[list.size()];
            list.toArray(array);
            return array;
        }
    }
}

