/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.explorer.impl.nodetype;

import com.day.crx.explorer.impl.util.NodeType2RepoMapping;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.InvalidNodeTypeDefinitionException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeDefinition;
import javax.jcr.nodetype.NodeTypeExistsException;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.NodeTypeTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomNodeTypeMgr {
    private static Logger log = LoggerFactory.getLogger(CustomNodeTypeMgr.class);
    public static final String NODENAME_NODESTORE = "crx:nodeTypes";
    public static final String NODENAME_SYSTEM = "jcr:system";
    public static final String PATH_NODETYPE_STORE = "/jcr:system/crx:nodeTypes";
    public static final String NODENAME_NODEDEF = "crx:nodeDef";
    public static final String PROPNAME_NODEDEFLOC = "crx:nodeDefLoc";
    public static final String PROPNAME_IS_BUILTIN = "crx:isBuiltin";
    public static final String PROPNAME_IS_REGISTERED = "crx:isRegistered";
    public static final String NT_NODESTORE = "nt:unstructured";
    public static final String NT_NODEINFO = "nt:unstructured";
    public static final String NT_NODETYPE = "nt:unstructured";
    public static final String PROPNAME_JCR_NODETYPENAME = "jcr:nodeTypeName";
    protected Session session;
    private NodeTypeManager ntMgr;
    private final NodeType2RepoMapping ntMapping;

    protected CustomNodeTypeMgr(Session session) throws RepositoryException {
        this.session = session;
        this.ntMgr = session.getWorkspace().getNodeTypeManager();
        this.ntMapping = new NodeType2RepoMapping(this.ntMgr);
    }

    public static CustomNodeTypeMgr create(Session session) throws RepositoryException {
        CustomNodeTypeMgr cntMgr = null;
        try {
            cntMgr = null;
        }
        catch (NoClassDefFoundError e) {
            log.warn("Unable to create CRXCustomNodeTypeMgr. Probably no CRX Repository. " + e.toString());
        }
        catch (Exception e) {
            log.warn("Unable to create CRXCustomNodeTypeMgr. Probably no CRX Repository. " + e.toString());
        }
        if (cntMgr == null) {
            cntMgr = new CustomNodeTypeMgr(session);
        }
        return cntMgr;
    }

    public synchronized Node getNodeTypeStore() throws RepositoryException {
        try {
            return (Node)this.session.getItem(PATH_NODETYPE_STORE);
        }
        catch (PathNotFoundException e) {
            log.info("Nodetype folder /jcr:system/crx:nodeTypes does not exist and will be created.");
            Node system = this.session.getRootNode().getNode(NODENAME_SYSTEM);
            system.addNode(NODENAME_NODESTORE, "nt:unstructured");
            system.save();
            return (Node)this.session.getItem(PATH_NODETYPE_STORE);
        }
    }

    public synchronized Node getNodeTypeNode(String nodeTypeName, boolean create) throws RepositoryException {
        Node info = this.getNodeTypeInfo(nodeTypeName, create);
        if (CustomNodeTypeMgr.getProperty(info, PROPNAME_IS_BUILTIN, false)) {
            return null;
        }
        if (info.hasProperty(PROPNAME_NODEDEFLOC)) {
            String path = info.getProperty(PROPNAME_NODEDEFLOC).getString();
            try {
                return (Node)this.session.getItem(path);
            }
            catch (RepositoryException e) {
                // empty catch block
            }
        }
        if (info.hasNode(NODENAME_NODEDEF)) {
            return info.getNode(NODENAME_NODEDEF);
        }
        if (create) {
            Node nodeDef = null;
            try {
                NodeType nt = this.ntMgr.getNodeType(nodeTypeName);
                info.setProperty(PROPNAME_IS_REGISTERED, true);
                boolean isBuiltin = this.isBuiltin(nt);
                if (!isBuiltin) {
                    nodeDef = NodeType2RepoMapping.mapNodeType(info, nt, NODENAME_NODEDEF);
                }
                info.setProperty(PROPNAME_IS_BUILTIN, isBuiltin);
            }
            catch (NoSuchNodeTypeException e) {
                nodeDef = info.addNode(NODENAME_NODEDEF, "nt:unstructured");
                nodeDef.setProperty(PROPNAME_JCR_NODETYPENAME, nodeTypeName);
                nodeDef.setProperty("jcr:isMixin", false);
                nodeDef.setProperty("jcr:hasOrderableChildNodes", false);
                nodeDef.setProperty("jcr:supertypes", new Value[0]);
            }
            info.save();
            return nodeDef;
        }
        throw new NoSuchNodeTypeException(nodeTypeName);
    }

    public synchronized void setNodeTypeNode(Node node) throws RepositoryException {
        if (!node.hasProperty("jcr:isMixin")) {
            node.setProperty("jcr:isMixin", false);
        }
        if (!node.hasProperty("jcr:hasOrderableChildNodes")) {
            node.setProperty("jcr:hasOrderableChildNodes", false);
        }
        if (!node.hasProperty("jcr:supertypes")) {
            node.setProperty("jcr:supertypes", new Value[0]);
        }
        if (!node.hasProperty(PROPNAME_JCR_NODETYPENAME)) {
            return;
        }
        String nodeTypeName = node.getProperty(PROPNAME_JCR_NODETYPENAME).getString();
        Node info = this.getNodeTypeInfo(nodeTypeName, true);
        if (info.hasNode(NODENAME_NODEDEF)) {
            Node def = info.getNode(NODENAME_NODEDEF);
            if (def.isSame((Item)node)) {
                return;
            }
            def.remove();
        }
        info.setProperty(PROPNAME_NODEDEFLOC, node.getPath());
        info.save();
    }

    public boolean hasNodeTypeInfo(String nodeTypeName) throws RepositoryException {
        return this.getNodeTypeStore().hasNode(nodeTypeName);
    }

    public synchronized Node getNodeTypeInfo(String nodeTypeName, boolean create) throws RepositoryException {
        Node nodeStore = this.getNodeTypeStore();
        if (nodeStore.hasNode(nodeTypeName)) {
            return nodeStore.getNode(nodeTypeName);
        }
        if (create) {
            Node node = nodeStore.addNode(nodeTypeName, "nt:unstructured");
            node.setProperty(PROPNAME_IS_BUILTIN, false);
            node.setProperty(PROPNAME_IS_REGISTERED, false);
            try {
                NodeType nt = this.ntMgr.getNodeType(nodeTypeName);
                node.setProperty(PROPNAME_IS_REGISTERED, true);
                boolean isBuiltin = this.isBuiltin(nt);
                if (!isBuiltin) {
                    Node nodeDef = NodeType2RepoMapping.mapNodeType(node, nt, NODENAME_NODEDEF);
                    node.setProperty(PROPNAME_NODEDEFLOC, nodeDef.getPath());
                }
                node.setProperty(PROPNAME_IS_BUILTIN, isBuiltin);
            }
            catch (NoSuchNodeTypeException e) {
                // empty catch block
            }
            nodeStore.save();
            return node;
        }
        throw new NoSuchNodeTypeException(nodeTypeName);
    }

    public synchronized void setNodeTypeName(String oldName, String newName) throws RepositoryException {
        if (newName.equals(oldName)) {
            return;
        }
        if (this.hasNodeTypeInfo(newName)) {
            throw new RepositoryException("Unable to change name. Already exists: " + newName);
        }
        try {
            this.session.getWorkspace().getNodeTypeManager().getNodeType(newName);
            throw new RepositoryException("Unable to change name. Already exists as registered: " + newName);
        }
        catch (NoSuchNodeTypeException e) {
            if (oldName == null) {
                this.getNodeTypeInfo(newName, true);
            } else {
                Node info = this.getNodeTypeInfo(oldName, false);
                if (CustomNodeTypeMgr.getProperty(info, PROPNAME_IS_REGISTERED, false)) {
                    throw new RepositoryException("Unable to change name of a registered nodetype: " + info.getName());
                }
                String newPath = "/jcr:system/crx:nodeTypes/" + newName;
                this.session.move(info.getPath(), newPath);
                this.getNodeTypeStore().save();
            }
            try {
                Node node = this.getNodeTypeNode(newName, false);
                node.setProperty(PROPNAME_JCR_NODETYPENAME, newName);
                node.getProperty(PROPNAME_JCR_NODETYPENAME).save();
            }
            catch (NoSuchNodeTypeException noSuchNodeTypeException) {
                // empty catch block
            }
            return;
        }
    }

    public boolean hasNodeType(String nodeTypeName) {
        try {
            this.getNodeTypeInfo(nodeTypeName, false);
            return true;
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    public boolean isRegistered(String nodeTypeName) {
        if (nodeTypeName != null) {
            try {
                this.ntMgr.getNodeType(nodeTypeName);
                return true;
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean isBuiltin(String nodeTypeName) {
        try {
            return this.getNodeTypeInfo(nodeTypeName, true).getProperty(PROPNAME_IS_BUILTIN).getBoolean();
        }
        catch (RepositoryException e) {
            return true;
        }
    }

    public NodeTypeManager getNodeTypeManager() {
        return this.ntMgr;
    }

    public List<String> getUnregisteredNames() throws RepositoryException {
        NodeIterator iter = this.getNodeTypeStore().getNodes();
        ArrayList<String> list = new ArrayList<String>();
        while (iter.hasNext()) {
            Node info = iter.nextNode();
            if (CustomNodeTypeMgr.getProperty(info, PROPNAME_IS_REGISTERED, false)) continue;
            list.add(info.getName());
        }
        return list;
    }

    public synchronized void removeNodeType(String nodeTypeName) throws RepositoryException {
        if (this.isRegistered(nodeTypeName)) {
            throw new RepositoryException("Unable to remove registered node type: " + nodeTypeName);
        }
        Node info = this.getNodeTypeInfo(nodeTypeName, false);
        info.remove();
        this.getNodeTypeStore().save();
    }

    protected static boolean getProperty(Node node, String propname, boolean def) throws RepositoryException {
        return node.hasProperty(propname) ? node.getProperty(propname).getBoolean() : def;
    }

    public boolean canRegister() {
        return true;
    }

    public synchronized void registerNodeTypes(String[] names, boolean force) throws RepositoryException {
        ArrayList<NodeTypeTemplate> ntDefs = new ArrayList<NodeTypeTemplate>(names.length);
        Node[] infos = new Node[names.length];
        for (int i = 0; i < names.length; ++i) {
            String ntName = names[i];
            Node info = infos[i] = this.getNodeTypeInfo(ntName, false);
            if (!force && CustomNodeTypeMgr.getProperty(info, PROPNAME_IS_REGISTERED, false)) {
                throw new RepositoryException("NodeType already registered: " + ntName);
            }
            Node nodeDef = this.getNodeTypeNode(ntName, false);
            ntDefs.add(this.ntMapping.createNodeTypeDef(nodeDef));
        }
        Throwable error = null;
        try {
            this.ntMgr.registerNodeTypes(ntDefs.toArray(new NodeTypeDefinition[ntDefs.size()]), false);
        }
        catch (InvalidNodeTypeDefinitionException e) {
            error = e;
        }
        catch (NodeTypeExistsException e) {
            error = e;
        }
        for (int i = 0; i < names.length; ++i) {
            infos[i].setProperty(PROPNAME_IS_REGISTERED, this.isRegistered(names[i]));
            infos[i].save();
        }
        if (error != null) {
            throw new RepositoryException(error);
        }
    }

    public synchronized void registerNodeType(String nodeTypeName, boolean force) throws RepositoryException {
        Node info = this.getNodeTypeInfo(nodeTypeName, false);
        if (!force && CustomNodeTypeMgr.getProperty(info, PROPNAME_IS_REGISTERED, false)) {
            throw new RepositoryException("NodeType already registered: " + nodeTypeName);
        }
        info.save();
        Node nodeDef = this.getNodeTypeNode(nodeTypeName, false);
        NodeTypeTemplate ntDef = this.ntMapping.createNodeTypeDef(nodeDef);
        this.ntMgr.registerNodeType((NodeTypeDefinition)ntDef, true);
        info.setProperty(PROPNAME_IS_REGISTERED, true);
        info.save();
    }

    public synchronized void unregisterNodeType(String nodeTypeName) throws RepositoryException {
        Node info = this.getNodeTypeInfo(nodeTypeName, false);
        if (!CustomNodeTypeMgr.getProperty(info, PROPNAME_IS_REGISTERED, false)) {
            return;
        }
        this.ntMgr.unregisterNodeType(nodeTypeName);
        info.setProperty(PROPNAME_IS_REGISTERED, false);
        info.save();
    }

    protected boolean isBuiltin(NodeType nt) {
        return true;
    }
}

