/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.explorer.impl.ui;

import com.day.crx.explorer.impl.j2ee.JCRExplorerServlet;
import com.day.crx.explorer.impl.ui.NodeTree;
import com.day.crx.explorer.impl.ui.NodeTreeHTMLProvider;
import java.io.IOException;
import java.util.TreeMap;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.jackrabbit.util.Text;

public class DefaultNodeTreeHTMLProvider
implements NodeTreeHTMLProvider {
    public void drawLevel(PageContext context, String treeName, Node parentNode, String openNode, String selectedNode) throws IOException, RepositoryException {
        if (!parentNode.getPrimaryNodeType().hasOrderableChildNodes()) {
            NodeIterator children = parentNode.getNodes();
            TreeMap<String, Node> map = new TreeMap<String, Node>();
            while (children.hasNext()) {
                Node node = children.nextNode();
                map.put(node.getPath(), node);
            }
            for (Node node : map.values()) {
                this.drawNode(context, treeName, node, openNode, selectedNode);
                this.drawSubNodes(context, treeName, node, openNode, selectedNode);
            }
        } else {
            NodeIterator children = parentNode.getNodes();
            while (children.hasNext()) {
                Node node = children.nextNode();
                this.drawNode(context, treeName, node, openNode, selectedNode);
                this.drawSubNodes(context, treeName, node, openNode, selectedNode);
            }
        }
    }

    public void drawNode(PageContext context, String treeName, Node node, String openNode, String selectedNode) throws IOException, RepositoryException {
        String docroot = JCRExplorerServlet.getDocrootPrefix((HttpServletRequest)context.getRequest());
        JspWriter out = context.getOut();
        String path = node.getPath();
        String id = NodeTree.getIdFromPath(treeName, path);
        boolean isOpen = Text.isDescendantOrEqual((String)path, (String)openNode);
        boolean isSelected = selectedNode.equals(path);
        boolean hasChildren = node.hasNodes();
        String imageSrc = node.isModified() ? "/imgs/icons/folder_edit.gif" : (node.isNew() ? "/imgs/icons/folder_new.gif" : JCRExplorerServlet.getNTIcon(node.getPrimaryNodeType()));
        String title = Text.getName((String)node.getPath());
        if (path.equals("/")) {
            title = "/";
        }
        String nodeClass = "node " + (hasChildren ? (isOpen ? "nOpen" : "nClosed") : "nLeaf");
        String nameClass = "nodeName" + (isSelected ? " nnSelected" : "");
        out.write("<div id=\"" + StringEscapeUtils.escapeHtml4((String)id) + "\" class=\"" + nodeClass + "\" onClick=\"NodeTree.toggleNode('" + StringEscapeUtils.escapeHtml4((String)treeName) + "', this, event)\">");
        out.write("<span class=\"nodeItem\" onClick=\"NodeTree.selectNode('" + StringEscapeUtils.escapeHtml4((String)treeName) + "', this, true, event)\" onContextmenu=\"NodeTree.selectNode('" + StringEscapeUtils.escapeHtml4((String)treeName) + "', this, false, event);try{toggleContextMenu(event);return false;}catch(e){}\";>");
        out.write("<img class=\"nodeIcon\" src=\"" + docroot + imageSrc + "\" border=\"0\">");
        out.write("<span onMouseEnter=\"NodeTree.addClass(this, 'nnHover')\" onMouseLeave=\"NodeTree.removeClass(this, 'nnHover')\" class=\"" + nameClass + "\">" + StringEscapeUtils.escapeHtml4((String)title) + "</span>");
        out.write("</span>");
        out.write("</div>");
    }

    public void drawSubNodes(PageContext context, String treeName, Node node, String openNode, String selectedNode) throws IOException, RepositoryException {
        JspWriter out = context.getOut();
        String path = node.getPath();
        boolean isOpen = Text.isDescendantOrEqual((String)path, (String)openNode);
        if (isOpen) {
            out.write("<div class=\"subNodes snOpen\">");
            this.drawLevel(context, treeName, node, openNode, selectedNode);
            out.write("</div>");
        } else {
            out.write("<div class=\"subNodes snClosed\"></div>");
        }
    }
}

