/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.explorer.impl.ui;

import com.day.crx.explorer.impl.j2ee.JCRExplorerServlet;
import com.day.crx.explorer.impl.ui.NodeTypeTree;
import com.day.crx.explorer.impl.ui.NodeTypeTreeHTMLProvider;
import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import org.apache.jackrabbit.util.Text;

public class MVControl
implements NodeTypeTreeHTMLProvider {
    public static final String ATTR_CONTEXT = "UI_MVCONTROL_CONTEXT";
    public static final String PROP_NODEBROWSE_SHOWNODES = "ShowNodes";
    public static final String PROP_NODEBROWSE_SHOWPROPS = "ShowProps";
    public static final String PROP_HIDE_NODETYPE_ICON = "HideNodeTypeIcon";
    public static final String PROP_DISABLE_MIXIN = "DisableMixinTypes";
    public static final String PROP_DISABLE_PRIMARY = "DisablePrimaryTypes";
    private final String name;
    private final String type;
    private final boolean isMultiple;
    private String[] values;
    private NodeTypeTree ntTree;
    private Properties props = new Properties();
    private Properties events = new Properties();
    private boolean allowEmpty = false;

    public MVControl(String name, String type, boolean isMultiple) {
        this.name = name;
        this.type = type;
        this.isMultiple = isMultiple;
    }

    public void setProperty(String name, String value) {
        this.props.setProperty(name, value);
    }

    public String getProperty(String name) {
        return this.props.getProperty(name);
    }

    public void setAllowEmpty(boolean allow) {
        this.allowEmpty = allow;
    }

    public void setValues(String[] values) {
        this.values = values;
    }

    public void setValues(Value[] values) throws RepositoryException {
        if (values == null) {
            this.values = null;
        } else {
            this.values = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                this.values[i] = values[i].getString();
            }
        }
    }

    public void setNodeTypes(NodeTypeTree ntTree) {
        this.ntTree = ntTree;
    }

    public void setEvent(String eventName, String function) {
        this.events.setProperty(eventName, function);
    }

    public static void init(PageContext context) throws IOException {
        Object obj = context.getAttribute(ATTR_CONTEXT);
        if (obj == null) {
            obj = new Object();
            context.setAttribute(ATTR_CONTEXT, obj);
            JspWriter out = context.getOut();
            String docroot = JCRExplorerServlet.getDocrootPrefix((HttpServletRequest)context.getRequest());
            out.println("<script src=\"" + docroot + "/ui/mvcontrol.js?ck=" + System.currentTimeMillis() + "\"></script>");
            out.println("<script>");
            out.println("MVControl.setDocroot(\"" + docroot + "\");");
            out.println("</script>");
        }
    }

    /*
     * WARNING - void declaration
     */
    public void draw(PageContext context) throws IOException, RepositoryException {
        JspWriter out = context.getOut();
        out.println("<script>\nvar mv = new MVControl(\"" + Text.encodeIllegalXMLCharacters((String)this.name) + "\", \"" + Text.encodeIllegalXMLCharacters((String)this.type) + "\"," + this.isMultiple + ");");
        if (this.type.equals("NodeType") && this.ntTree != null) {
            this.ntTree.draw(context, this);
        }
        if (this.allowEmpty) {
            out.println("mv.setAllowEmpty(true);");
        }
        for (String string : this.props.keySet()) {
            out.println("mv.setProperty(\"" + Text.encodeIllegalXMLCharacters((String)string) + "\",\"" + Text.encodeIllegalXMLCharacters((String)this.props.getProperty(string)) + "\");");
        }
        for (String string : this.events.keySet()) {
            out.println("mv.setEvent(\"" + Text.encodeIllegalXMLCharacters((String)string) + "\",\"" + Text.encodeIllegalXMLCharacters((String)this.events.getProperty(string)) + "\");");
        }
        out.println("mv.drawBegin();");
        if (this.values != null) {
            void var4_8;
            boolean bl = false;
            while (var4_8 < this.values.length) {
                if (this.values[var4_8] != null) {
                    out.println("mv.drawValue(\"" + Text.encodeIllegalXMLCharacters((String)Text.escape((String)this.values[var4_8])) + "\");");
                }
                ++var4_8;
            }
        }
        out.println("mv.drawEnd();\n</script>");
    }

    public void drawLevel(PageContext context, NodeTypeTree.Item item, int indent) throws IOException, RepositoryException {
        Iterator iter = item.getChildren();
        while (iter.hasNext()) {
            this.drawItem(context, (NodeTypeTree.Item)iter.next(), indent);
        }
    }

    public void drawItem(PageContext context, NodeTypeTree.Item item, int indent) throws IOException, RepositoryException {
        JspWriter out = context.getOut();
        out.print("mv.addNodeType(");
        out.print("\"" + Text.encodeIllegalXMLCharacters((String)item.getName()) + "\"");
        out.print("," + item.isMixin() + "");
        out.print(",\"" + JCRExplorerServlet.getNTIcon(item.getName()) + "\"");
        out.println("," + indent + ");");
        this.drawLevel(context, item, indent + 1);
    }
}

