/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.explorer.impl.ui;

import com.day.crx.explorer.impl.ui.MVControl;
import com.day.crx.explorer.impl.ui.NodeTypeView;
import com.day.crx.explorer.impl.util.Values;
import com.day.crx.i18n.Dictionary;
import java.io.IOException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.version.OnParentVersionAction;
import javax.servlet.jsp.JspWriter;
import org.apache.jackrabbit.util.Text;

public class NodeDefView {
    private final NodeTypeView parent;
    private final Dictionary dict = Dictionary.getCurrent();

    public NodeDefView(NodeTypeView parent) {
        this.parent = parent;
    }

    public void drawTableHeader() throws IOException {
        this.drawTableHeader(this.dict.msg("crex.child_node_definitions.txt"), "");
    }

    public void drawTableHeader(String title) throws IOException {
        this.drawTableHeader(title, "");
    }

    public void drawTableHeader(String title, String description) throws IOException {
        JspWriter out = this.parent.getOut();
        out.print("<tr><th title=\"" + description + "\" class=\"listTitle\" colspan=\"1\">" + Text.encodeIllegalXMLCharacters((String)title) + "</th></tr>\n" + "<tr><th class=\"firstCol\" title=\"" + this.dict.msg("crex.childnode_definition_name.txt") + "\">" + this.dict.msg("crex.name.lab") + "</th>\n" + "<th title=\"" + this.dict.msg("crex.required_node_types.txt") + "\">" + this.dict.msg("crex.req_node_types.txt") + "</th>\n" + "<th title=\"" + this.dict.msg("crex.default_node_type.txt") + "\"colspan=\"2\">" + this.dict.msg("crex.def_node_type.txt") + "</th>\n" + "<th title=\"" + this.dict.msg("crex.onparentversion.lab") + "\">" + this.dict.msg("crex.opv.lab") + "</th>\n" + "<th title=\"" + this.dict.msg("crex.autocreate.lab") + "\">" + this.dict.msg("crex.ac.lab") + "</th>\n" + "<th title=\"" + this.dict.msg("crex.mandatory.lab") + "\">" + this.dict.msg("crex.man.lab") + "</th>\n" + "<th title=\"" + this.dict.msg("crex.protected.lab") + "\">" + this.dict.msg("crex.prot.lab") + "</th>\n" + "<th title=\"" + this.dict.msg("crex.same_name_siblings.txt") + "\">" + this.dict.msg("crex.sns.lab") + "</th>\n" + "<th title=\"" + this.dict.msg("crex.declaring_nodetype.tit") + "\" >" + this.dict.msg("crex.decl_node_type.txt") + "</th>\n" + "</tr>");
    }

    public void drawTableFooter() throws IOException {
        JspWriter out = this.parent.getOut();
        out.print("<tr><td class=\"listFooter\" colspan=\"11\">&nbsp;</td></tr>");
    }

    public void drawNodeDef(NodeType nt, NodeDefinition nd, int count) throws IOException {
        JspWriter out = this.parent.getOut();
        String name = nd.getName() == null ? "*" : nd.getName();
        String piName = nt == null ? "" : nt.getPrimaryItemName();
        String declNodeTypeName = nd.getDeclaringNodeType() == null ? null : nd.getDeclaringNodeType().getName();
        String style = "";
        if (nt == null || !nt.getName().equals(declNodeTypeName)) {
            style = style + "color:#888888;";
        }
        if (name.equals(piName)) {
            style = style + "font-weight:bold;";
        }
        if (style.length() > 0) {
            style = " style=\"" + style + "\"";
        }
        if (count % 2 == 0) {
            out.print("<tr class=\"zebra\">");
        } else {
            out.print("<tr>");
        }
        out.print("<td class=\"firstCol\"" + style + ">");
        out.print(Text.encodeIllegalXMLCharacters((String)name));
        out.print("</td>");
        out.print("<td" + style + ">");
        this.parent.drawNodeTypes(nd.getRequiredPrimaryTypes(), null);
        out.print("</td>");
        out.print("<td colspan=\"2\"" + style + ">");
        this.parent.drawNodeType(nd.getDefaultPrimaryType());
        out.print("</td>");
        out.print("<td" + style + ">");
        out.print(OnParentVersionAction.nameFromValue((int)nd.getOnParentVersion()));
        out.print("</td>");
        out.print("<td" + style + ">");
        out.print(nd.isAutoCreated() ? "X" : "-");
        out.print("</td>");
        out.print("<td" + style + ">");
        out.print(nd.isMandatory() ? "X" : "-");
        out.print("</td>");
        out.print("<td" + style + ">");
        out.print(nd.isProtected() ? "X" : "-");
        out.print("</td>");
        out.print("<td" + style + ">");
        out.print(nd.allowsSameNameSiblings() ? "X" : "-");
        out.print("</td>");
        out.print("<td class=\"lastCol\"" + style + ">");
        this.parent.drawNodeType(nd.getDeclaringNodeType());
        out.print("</td>");
        out.print("</tr>");
    }

    public void drawNodeDef(Node node, String declaringNodeTypeName, int count) throws IOException, RepositoryException {
        JspWriter out = this.parent.getOut();
        boolean edit = declaringNodeTypeName == null;
        String path = node == null ? "" : node.getPath();
        String style = "";
        String action = edit ? "" : " onClick=\"javascript:doAction('edit', '" + Text.encodeIllegalXMLCharacters((String)node.getPath()) + "')\"";
        boolean isAutoCreate = Values.getProperty(node, "jcr:autoCreated", false);
        boolean isMandatory = Values.getProperty(node, "jcr:mandatory", false);
        String piName = node == null ? "" : Values.getProperty(node.getParent(), "jcr:primaryItemName", "");
        boolean isProtected = Values.getProperty(node, "jcr:protected", false);
        boolean isSNS = Values.getProperty(node, "jcr:sameNameSiblings", false);
        String name = Values.getProperty(node, "jcr:name", "*");
        if (!edit && name.equals(piName)) {
            style = style + "font-weight:bold;";
        }
        if (style.length() > 0) {
            style = " style=\"" + style + "\"";
        }
        if (count % 2 == 0) {
            out.print("<tr" + action + " class=\"zebra\">");
        } else {
            out.print("<tr" + action + ">");
        }
        out.print("<td class=\"firstCol\"" + style + ">");
        if (edit) {
            out.print("<input title=\"" + this.dict.msg("crex.childnode_definition_name.txt") + "\" type=\"text\" name=\"nd_name\" value=\"" + Text.encodeIllegalXMLCharacters((String)name) + "\">");
        } else {
            out.print(Text.encodeIllegalXMLCharacters((String)name));
        }
        out.print("&nbsp;</td>");
        String[] reqPrimTypes = Values.getProperty(node, "jcr:requiredPrimaryTypes", new String[0]);
        out.print("<td" + style + ">");
        if (edit) {
            MVControl mv = new MVControl("nd_requiredPrimaryTypes", "NodeType", true);
            mv.setValues(reqPrimTypes);
            mv.setNodeTypes(this.parent.getNodeTypeTree());
            mv.draw(this.parent.getPageContext());
        } else {
            this.parent.drawNodeTypes(reqPrimTypes, null);
        }
        out.print("</td>");
        String defPrimaryType = Values.getProperty(node, "jcr:defaultPrimaryType", "");
        out.print("<td colspan=\"2\"" + style + ">");
        if (edit) {
            MVControl mv = new MVControl("nd_defaultPrimaryType", "NodeType", false);
            mv.setValues(new String[]{defPrimaryType});
            mv.setAllowEmpty(true);
            mv.setNodeTypes(this.parent.getNodeTypeTree());
            mv.draw(this.parent.getPageContext());
        } else if (!defPrimaryType.equals("")) {
            this.parent.drawNodeType(defPrimaryType);
        }
        out.print("</td>");
        String onVers = Values.getProperty(node, "jcr:onParentVersion", "");
        out.print("<td" + style + ">");
        if (edit) {
            out.print("<select title=\"" + this.dict.msg("crex.onparentversion.lab") + "\" name=\"nd_onParentVersion\">");
            for (int i = 0; i < NodeTypeView.ON_VERSION_ACTIONS.length; ++i) {
                String selected = NodeTypeView.ON_VERSION_ACTIONS[i].equals(onVers) ? " selected" : "";
                out.print("<option value=\"" + NodeTypeView.ON_VERSION_ACTIONS[i] + "\"" + selected + ">" + NodeTypeView.ON_VERSION_ACTIONS[i]);
            }
            out.print("</select>");
        } else {
            out.print(Text.encodeIllegalXMLCharacters((String)onVers));
        }
        out.print("</td>");
        out.print("<td" + style + ">");
        if (edit) {
            out.print("<input title=\"" + this.dict.msg("crex.autocreate.lab.0") + "\" type=\"checkbox\" name=\"nd_autoCreate\" value=\"true\" " + (isAutoCreate ? "checked" : "") + ">");
        } else {
            out.print(isAutoCreate ? "X" : "-");
        }
        out.print("</td>");
        out.print("<td" + style + ">");
        if (edit) {
            out.print("<input title=\"" + this.dict.msg("crex.mandatory.lab") + "\" type=\"checkbox\" name=\"nd_mandatory\" value=\"true\" " + (isMandatory ? "checked" : "") + ">");
        } else {
            out.print(isMandatory ? "X" : "-");
        }
        out.print("</td>");
        out.print("<td" + style + ">");
        if (edit) {
            out.print("<input title=\"" + this.dict.msg("crex.protected.lab") + "\" type=\"checkbox\" name=\"nd_protected\" value=\"true\" " + (isProtected ? "checked" : "") + ">");
        } else {
            out.print(isProtected ? "X" : "-");
        }
        out.print("</td>");
        out.print("<td" + style + ">");
        if (edit) {
            out.print("<input title=\"" + this.dict.msg("crex.same_name_siblings.txt") + "\" type=\"checkbox\" name=\"nd_sameNameSibs\" value=\"true\" " + (isSNS ? "checked" : "") + ">");
        } else {
            out.print(isSNS ? "X" : "-");
        }
        out.print("</td>");
        out.print("<td class=\"lastCol\"" + style + ">");
        if (edit) {
            out.print("<img class=\"button\" alt=\"" + this.dict.msg("crex.ok.lab") + "\" src=\"" + this.parent.getDocroot() + "/imgs/icons/check.gif\" onClick=\"doAction('setChildNodeDef', '" + path + "')\">");
            if (!path.equals("")) {
                out.print("<img class=\"button\" alt=\"" + this.dict.msg("crex.cancel.lab") + "\" src=\"" + this.parent.getDocroot() + "/imgs/icons/delete.gif\" onClick=\"resetForm()\">");
                out.print("<img class=\"button\" alt=\"" + this.dict.msg("crex.delete.lab") + "\" src=\"" + this.parent.getDocroot() + "/imgs/icons/garbage_empty.gif\" onClick=\"doAction('delete', '" + path + "')\">");
            }
        } else {
            this.parent.drawNodeType(declaringNodeTypeName);
        }
        out.print("</td>");
        out.print("</tr>");
    }
}

