/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.explorer.impl.ui;

import com.day.crx.explorer.impl.j2ee.JCRExplorerServlet;
import com.day.crx.explorer.impl.ui.DefaultNodeTreeHTMLProvider;
import com.day.crx.explorer.impl.ui.NodeTreeHTMLProvider;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import org.apache.jackrabbit.util.Text;

public class NodeTree {
    public static final String PARAM_OPEN_NODE = "OpenNode";
    public static final String PARAM_SELECTED_NODE = "SelectedNode";
    private static final HashMap providers = new HashMap();
    private String openNode = null;
    private String selectedNode = null;
    private String onSelectNode = "";
    private String levelURI = "/ui/nodetree/level.html";
    private final NodeTreeHTMLProvider provider;
    private final String name;

    public NodeTree(String name) {
        this(name, DefaultNodeTreeHTMLProvider.class);
    }

    public NodeTree(String name, Class providerClass) {
        this.name = name;
        this.provider = NodeTree.getProvider(providerClass);
    }

    public void draw(PageContext context, Node rootNode) throws IOException, RepositoryException {
        String docroot = JCRExplorerServlet.getDocrootPrefix((HttpServletRequest)context.getRequest());
        JspWriter out = context.getOut();
        Map parameters = context.getRequest().getParameterMap();
        if (this.openNode == null) {
            String string = this.openNode = parameters.containsKey(PARAM_OPEN_NODE) ? ((String[])parameters.get(PARAM_OPEN_NODE))[0] : "/";
        }
        if (this.selectedNode == null) {
            this.selectedNode = parameters.containsKey(PARAM_SELECTED_NODE) ? ((String[])parameters.get(PARAM_SELECTED_NODE))[0] : "";
        }
        out.println();
        out.println("<link rel=\"stylesheet\" href=\"" + docroot + "/ui/default.css\" type=\"text/css\" title=\"style\" />");
        out.println("<link rel=\"stylesheet\" href=\"" + docroot + "/ui/nodetree.css\" type=\"text/css\" title=\"style\" />");
        out.println("<script src=\"" + docroot + "/ui/nodetree.js\"></script>");
        out.println("<script>");
        out.println("var tree=NodeTree.createTree(\"" + Text.encodeIllegalXMLCharacters((String)this.name) + "\", \"" + Text.getName((String)this.provider.getClass().getName(), (char)'.') + "\", \"" + docroot + this.levelURI + "\");");
        if (!this.onSelectNode.equals("")) {
            out.println("tree.registerOnSelectNode(" + this.onSelectNode + ");");
        }
        out.println("tree.setSelectedNode(\"" + Text.encodeIllegalXMLCharacters((String)this.selectedNode) + "\");");
        out.println("</script>");
        out.print("<div class=\"nodeTree\" id=\"NodeTree_" + Text.encodeIllegalXMLCharacters((String)this.name) + "\">");
        this.provider.drawNode(context, this.name, rootNode, this.openNode, this.selectedNode);
        this.provider.drawSubNodes(context, this.name, rootNode, this.openNode, this.selectedNode);
        out.println("</div>");
    }

    public static synchronized NodeTreeHTMLProvider getProvider(String className) {
        return (NodeTreeHTMLProvider)providers.get(className);
    }

    public static synchronized NodeTreeHTMLProvider getProvider(Class clazz) {
        String className = Text.getName((String)clazz.getName(), (char)'.');
        NodeTreeHTMLProvider provider = (NodeTreeHTMLProvider)providers.get(className);
        if (provider == null) {
            try {
                provider = (NodeTreeHTMLProvider)clazz.newInstance();
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException(e.toString());
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(e.toString());
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException(e.toString());
            }
            providers.put(className, provider);
        }
        return provider;
    }

    public static String getIdFromPath(String treeName, String path) {
        return treeName + ":" + path;
    }

    public String getOnSelectNode() {
        return this.onSelectNode;
    }

    public void setOnSelectNode(String onSelectNode) {
        this.onSelectNode = onSelectNode;
    }

    public String getOpenNode() {
        return this.openNode;
    }

    public void setOpenNode(String openNode) {
        this.openNode = openNode;
    }

    public String getSelectedNode() {
        return this.selectedNode;
    }

    public void setSelectedNode(String selectedNode) {
        this.selectedNode = selectedNode;
    }
}

